/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.sams.web;

import com.gtis.sams.core.web.BaseEntityAction;
import com.gtis.sams.services.FCBService;
import com.gtis.sams.services.FCPService;
import com.gtis.sams.services.GeoService;
import com.gtis.sams.vo.FCPVo;
import com.gtis.sams.vo.base.BaseBatchVo;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchAction
extends BaseEntityAction<BaseBatchVo> {
    @Autowired
    private FCBService fcbService;
    @Autowired
    private GeoService geoService;
    @Autowired
    private FCPService fcpService;
    private String coords;
    private List<FCPVo> statisticData;

    public String execute() throws Exception {
        return super.execute();
    }

    public String getProType() {
        return this.getType().equals("fcb") ? "fcp" : "";
    }

    public String getCoords() {
        String coords = "";
        List coordsStr = this.fcbService.getCoords(this.getId());
        try {
            for (String c : coordsStr) {
                Geometry geometry = this.geoService.parseWtkCoords(c);
                coords = coords + this.geoService.transform2GtCoordsFromat(geometry);
            }
        }
        catch (ParseException e) {
            this.logger.error("\u89e3\u6790\u5750\u6807\u4e32\u5f02\u5e38\u3010{}\u3011", (Object)e.toString());
        }
        return coords;
    }

    public BaseBatchVo getEntity() {
        if (this.entity == null) {
            this.entity = this.baseService.find(this.getId());
        }
        return (BaseBatchVo)this.entity;
    }

    public String mapInfo() {
        return "mapInfo";
    }
}

