package com.gtis.portal.web.login;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.gtis.common.http.Utf8PostMethod;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.server.UseridMachinePzService;
import com.gtis.portal.web.TurnWorkFlowController;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2020/11/11.
 */
@Controller
@RequestMapping("")
public class MokeLoginController {
    private static final Log log = LogFactory.getLog(MokeLoginController.class);
    @Autowired
    SysUserService sysUserService;
    @Autowired
    UseridMachinePzService useridMachinePzService;

    @RequestMapping("mokeLogin")
    @ResponseBody
    public Object mokeLogin(@RequestParam(value = "loginName", required = false) String loginName) throws Exception {
        HashMap map= Maps.newHashMap();
        String sfzh="";
        if (StringUtils.isNotBlank(loginName)){
            PfUserVo pfUserVo= sysUserService.getUserByloginName(loginName);
            if(pfUserVo!=null && StringUtils.isNotBlank(pfUserVo.getUserId())){
                String jqbm=useridMachinePzService.getJqbm(pfUserVo.getUserId());
                if(StringUtils.isNotBlank(jqbm)){
                    String url=AppConfig.getProperty("mokeLogin.url");
                    if (StringUtils.isNotBlank(url)) {
                        HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
                        PostMethod postMethod = new Utf8PostMethod(url);
                        NameValuePair[] data = {
                                new NameValuePair("id", UUIDGenerator.generate()),
                                new NameValuePair("sysIp", jqbm)
                        };

                        postMethod.setRequestBody(data);
                        int status = 0;
                        try {
                            status = httpClient.executeMethod(postMethod);
                        } catch (IOException e) {
                            log.error("TurnInfo filter url request failer{}", e);
                        }
                        if (status == HttpStatus.SC_OK) {
                            try {
                                String xml = postMethod.getResponseBodyAsString();
//                                String xml = "{" +
//                                        "    \"data\": {" +
//                                        "        \"idNo\": \"320115199012121214\"," +
//                                        "        \"birth\": \"1990年12月12日\"," +
//                                        "        \"sex\": \"男\"," +
//                                        "        \"police\": \"南京市公安局建邺分局\"," +
//                                        "        \"address\": \"南京市建邺区奥体大街71号\"," +
//                                        "        \"validPeriod\": \"2015.11.29-2025.11.29\"," +
//                                        "        \"name\": \"王一民\"," +
//                                        "        \"nation\": \"汉\"," +
//                                        "        \"photoBase64\": \"xxxxxxxxxxxx……\"," +
//                                        "'serviceId': '32101412123'" +
//                                        "    }," +
//                                        "    \"message\": \"人证核验结束\"," +
//                                        "    \"code\": 1" +
//                                        "}";
                                if (StringUtils.isNotBlank(xml)) {
                                   HashMap map1 = JSON.parseObject(xml, HashMap.class);
                                    if(map1!=null && map1.get("data")!=null){
                                        Map resultData = (Map) map1.get("data");
                                        if(resultData!=null && resultData.get("idNo")!=null){
                                            sfzh=resultData.get("idNo").toString();
                                        }
                                    }
                                }
                            } catch (Exception e) {
                                log.error("TurnInfo filter url request success,prase failure{}", e);
                            }
                        } else {
                            log.error("TurnInfo filter url request failer");
                        }
                    }
                }
            }

        }
        map.put("sfzh",sfzh);
        return map;
    }
}
