package com.gtis.portal.web;

import com.alibaba.fastjson.JSONArray;
import com.gtis.common.http.Utf8PostMethod;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.tree.DefaultText;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * 转发
 * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/turnBackWorkFlow")
public class TurnBackWorkFlowController {
    private static final Log log = LogFactory.getLog(TurnBackWorkFlowController.class);
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService taskService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    SysOpinionService opinionService;

    @RequestMapping("")
    public String turnBackWorkFlow(Model model,@RequestParam(value = "taskid", required = false) String taskid) throws Exception {
        WorkFlowInfo info=workFlowService.getWorkFlowTurnBackInfo(SessionUtil.getCurrentUserId(), taskid);
        List<PfActivityVo> backActivitys=info.getTargetActivitys();
        if(backActivitys==null)
            backActivitys=new ArrayList<PfActivityVo>();
        model.addAttribute("taskid",taskid);
        model.addAttribute("backActivitys",backActivitys);

        PfActivityVo sourceActivity=info.getSourceActivity();
        if(sourceActivity==null){
            sourceActivity=new PfActivityVo();
        }
        model.addAttribute("sourceActivity",sourceActivity);
        model.addAttribute("userid",SessionUtil.getCurrentUserId());

        return "turnBack-workFlow";
    }
}
