package com.gtis.portal.web;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.service.server.BdcXmxxService;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.RiskModel;
import com.gtis.portal.entity.BdcJyshxx;
import com.gtis.portal.entity.Bdcdy;
import com.gtis.portal.model.Menu;
import com.gtis.portal.service.LogService;
import com.gtis.portal.service.TaskCenterService;
import com.gtis.portal.service.server.BdcJyhtService;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.service.server.BdcdyService;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.ReadXmlProps;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 任务验证中心
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/taskValidate")
public class TaskValidateController {
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysSignService sysSignService;
    @Autowired
    SysTaskService taskService;

    @Autowired
    SysUserService sysUserService;

    @Autowired
    SysActivityService sysActivityService;

    /**
     * @param taskid 当前任务ID
     * @return 提示信息
     * @author <a href="mailto:zhaodongdong@gtmap.cn">zdd</a>
     * @description 已办理的任务验证
     */
    @ResponseBody
    @RequestMapping("/checkRetrieveTask")
    public Object checkRetrieveTask(String taskid) {
        HashMap map = new HashMap();
        String msg = "取回失败";
        try {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(taskid)) {
                PfTaskVo selfPfTaskVo = taskService.getHistoryTask(taskid);
                PfActivityVo pfActivityVo = sysActivityService.getActivityById(selfPfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId())) {
                    List<PfTaskVo> pfTaskVoList = taskService.getTaskListByInstance(pfActivityVo.getWorkflowInstanceId());
                    PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    String proid = "";
                    if (pfWorkFlowInstanceVo != null && StringUtils.isNotBlank(pfWorkFlowInstanceVo.getProId()))
                        proid = pfWorkFlowInstanceVo.getProId();
                    if (CollectionUtils.isNotEmpty(pfTaskVoList)) {
                        boolean turnedTask = true;
                        for (PfTaskVo pfTaskVo : pfTaskVoList) {
                            if (pfTaskVo.getFinishTime() == null) {
                                turnedTask = false;
                                break;
                            }
                        }

                        String activityId = pfTaskVoList.get(0).getActivityId();
                        PfActivityVo activityVo = sysActivityService.getActivityById(activityId);
                        if (activityVo != null && StringUtils.isNotBlank(activityVo.getActivityName())) {
                            String signKey = ReadXmlProps.getSignKeyByActivityName(activityVo.getActivityName());
                            if (StringUtils.isNotBlank(signKey) && StringUtils.isNotBlank(proid)) {
                                List<PfSignVo> pfSignVoList = sysSignService.getSignList(signKey, proid);
                                if (CollectionUtils.isEmpty(pfSignVoList) && !turnedTask)
                                    msg = "成功";
                                else
                                    msg = "该业务已签字，取回失败";
                            } else if(!turnedTask){
                                msg = "成功";
                            }
                            if(StringUtils.equals(activityVo.getActivityName(),"缮证"))
                                msg = "缮证环节不能取回，取回失败";
                        } else if(!turnedTask){
                            msg = "成功";
                        }
                    }
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        map.put("msg", msg);
        return map;
    }
}
