package com.gtis.portal.web;

import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.*;

/**
 * Created by shenjian on 2014/5/12.
 */
@Controller
@RequestMapping("/home")
public class HomeController {

    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;

    @RequestMapping("")
    public String index(Model model) {
        return "home";
    }

    @RequestMapping("category")
    public String category(Model model) {
        List<PfWorkFlowDefineVo> lstWorkFlowDefine = sysWorkFlowDefineService.getWorkFlowDefineList();
        Map<String,List<PfWorkFlowDefineVo>> mapWorkFlowDefine = new LinkedHashMap<String,List<PfWorkFlowDefineVo>>();
        for(PfWorkFlowDefineVo wfd : lstWorkFlowDefine){
            String businessName = wfd.getBusinessVo().getBusinessName();
            String groupId = wfd.getGroupId();
            String categoryName =  businessName;
            String createUrl = wfd.getCreateUrl() == null ? "" : wfd.getCreateUrl();
            wfd.setCreateUrl(AppConfig.getPlaceholderValue(createUrl));
            if(StringUtils.isNotBlank(groupId))
                categoryName = wfd.getResourceGroupVo().getGroupName();
            if(mapWorkFlowDefine.get(categoryName) != null){
                mapWorkFlowDefine.get(categoryName).add(wfd);
            }else {
                List<PfWorkFlowDefineVo> wfdList = new ArrayList<PfWorkFlowDefineVo>();
                wfdList.add(wfd);
                mapWorkFlowDefine.put(categoryName, wfdList);
            }
        }
        Set<Map.Entry<String,List<PfWorkFlowDefineVo>>> setWorkFlowDefine = mapWorkFlowDefine.entrySet();
        model.addAttribute("setWorkFlowDefine",setWorkFlowDefine);
        return "business/category";
    }
}
