package com.gtis.portal.util;

import com.google.zxing.common.BitMatrix;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

/**
 * @文件名 MatrixToImageWriter.java
 * @作者 卢向伟
 * @创建日期 2014年10月13日
 * @创建时间 下午7:18:03
 * @版本号 V 1.0
 */
public class MatrixToImageWriter {
	private static final int BLACK = 0xFF000000;
	private static final int WHITE = 0xFFFFFFFF;

	private MatrixToImageWriter() {
	}

	public static BufferedImage toBufferedImage(BitMatrix matrix) {
		int width = matrix.getWidth();
		int height = matrix.getHeight();
		BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		for (int x = 0; x < width; x++) {
			for (int y = 0; y < height; y++) {
				image.setRGB(x, y, matrix.get(x, y) ? BLACK : WHITE);
			}
		}
		return image;
	}

	public static void writeToFile(BitMatrix matrix, String format, File file) throws IOException {
		BufferedImage image = toBufferedImage(matrix);
		if (!ImageIO.write(image, format, file)) {
			throw new IOException("Could not write an image of format " + format + " to " + file);
		}
	}

	public static void writeToStream(BitMatrix matrix, String format, OutputStream stream) throws IOException {
		BufferedImage image = toBufferedImage(matrix);
		if (!ImageIO.write(image, format, stream)) {
			throw new IOException("Could not write an image of format " + format);
		}
	}

	/**
	 * 根据二维码返回前台二维码图片
	 * @param matrix
	 * @param format
	 * @param response
	 * @throws IOException
	 */
	public static void writeToResponse(BitMatrix matrix, String format, HttpServletResponse response) throws IOException {
		BufferedImage image = toBufferedImage(matrix);
		if (!ImageIO.write(image, format, response.getOutputStream())) {
			throw new IOException("Could not write an image of format " + format);
		}
	}

	/**
	 * 根据图片路径返回前台
	 * @param imgPath
	 * @param format
	 * @param response
	 * @throws IOException
	 */
	public static void writeToResponse(String imgPath, String format, HttpServletResponse response) throws IOException {
		BufferedImage image = ImageIO.read(new URL(imgPath));
		if (!ImageIO.write(image, format, response.getOutputStream())) {
			throw new IOException("Could not write an image of format " + format);
		}
	}
}
