package com.gtis.portal.service.server.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.server.WorkFlowCommissionDao;
import com.gtis.portal.entity.WorkFlowCommission;
import com.gtis.portal.service.server.WorkFlowCommissionService;
import com.gtis.portal.util.QueryCondition;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

import static com.gtis.portal.entity.QWorkFlowCommission.workFlowCommission;


/**
 * @author <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @version 1.0 , 2019/12/25
 * @description
 **/
@Service
public class WorkFlowCommissionServiceImpl implements WorkFlowCommissionService {
    @Autowired
    WorkFlowCommissionDao workFlowCommissionDao;
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysUserService sysUserService;

    @Override
    public Page<WorkFlowCommission> queryWorkFlowCommissionList(String workFlowId, String principalId, String agentId, Pageable page) {
        BooleanExpression expression = null;
        if(StringUtils.isNotBlank(workFlowId)) {
            expression = workFlowCommission.workFlowId.eq(workFlowId);
        }

        if (StringUtils.isNotBlank(principalId)) {
            if (expression == null)
                expression = workFlowCommission.principalId.eq(principalId);
            else
                expression = expression.and(workFlowCommission.principalId.eq(principalId));
        }

        if (StringUtils.isNotBlank(agentId)) {
            if (expression == null)
                expression = workFlowCommission.agentId.eq(agentId);
            else
                expression = expression.and(workFlowCommission.agentId.eq(agentId));
        }
        return workFlowCommissionDao.findAll(expression, page);
    }

    @Override
    public WorkFlowCommission getWorkFlowCommissionByWdidAndYhid(String workFlowId, String principalId, String agentId) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("workFlowId", QueryCondition.EQ, workFlowId);
        QueryCondition queryCondition1 = new QueryCondition("principalId", QueryCondition.EQ, principalId);
        QueryCondition queryCondition2 = new QueryCondition("agentId", QueryCondition.EQ, agentId);

        queryConditions.add(queryCondition);
        queryConditions.add(queryCondition1);
        queryConditions.add(queryCondition2);

        List<WorkFlowCommission> bdcZdpjjlList = baseDao.get(WorkFlowCommission.class, queryConditions);
        if (CollectionUtils.isNotEmpty(bdcZdpjjlList))
            return bdcZdpjjlList.get(0);
        return null;
    }

    @Override
    public void save(WorkFlowCommission workFlowCommission) {
        if (StringUtils.isBlank(workFlowCommission.getWorkFlowCommissionId()))
            workFlowCommission.setWorkFlowCommissionId(UUIDGenerator.generate());
        //数据库查询出的对象
        WorkFlowCommission getWorkFlowCommission = getWorkFlowCommission(workFlowCommission.getWorkFlowCommissionId());
        if (StringUtils.isNotBlank(workFlowCommission.getWorkFlowId()))
            workFlowCommission.setWorkFlowName(sysWorkFlowDefineService.getWorkFlowDefine(workFlowCommission.getWorkFlowId()).getWorkflowName());

        if (StringUtils.isNotBlank(workFlowCommission.getPrincipalId())) {
            PfUserVo pfPrincipalUserVo = sysUserService.getUserVo(workFlowCommission.getPrincipalId());
            if (pfPrincipalUserVo != null)
                workFlowCommission.setPrincipalName(pfPrincipalUserVo.getUserName());
        }
        if (StringUtils.isNotBlank(workFlowCommission.getAgentId())) {
            PfUserVo pfAgentUserVo = sysUserService.getUserVo(workFlowCommission.getAgentId());
            if (pfAgentUserVo != null)
                workFlowCommission.setAgentName(pfAgentUserVo.getUserName());
        }

        if (getWorkFlowCommission != null) {
            updateWorkFlowCommission(workFlowCommission);
        } else {
            addWorkFlowCommission(workFlowCommission);
        }
    }

    public WorkFlowCommission getWorkFlowCommission(String workFlowCommissionId) {
        return baseDao.getById(WorkFlowCommission.class, workFlowCommissionId);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void delWorkFlowCommission(String id) {
        baseDao.delete(WorkFlowCommission.class, id);
    }

    @Override
    public List<WorkFlowCommission> getWorkFlowCommissionByAgentId(String agentId) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("agentId", QueryCondition.EQ, agentId);
        queryConditions.add(queryCondition);
        return baseDao.get(WorkFlowCommission.class,queryConditions);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void updateWorkFlowCommission(WorkFlowCommission workFlowCommission) {
        baseDao.update(workFlowCommission);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void addWorkFlowCommission(WorkFlowCommission workFlowCommission) {
        baseDao.save(workFlowCommission);
    }
}
