package com.gtis.portal.service.server.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.*;
import com.gtis.portal.service.server.BdcSfxxService;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.util.QueryCondition;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 不动产收费信息接口实现
 */
@Service
public class BdcSfxxServiceImpl implements BdcSfxxService {
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;

    @Override
    public List<BdcSfxx> getBdcSfxxList(String proid){
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("proid", QueryCondition.EQ, proid);
        queryConditions.add(queryCondition);

        List<BdcSfxx> result = baseDao.get(BdcSfxx.class, queryConditions);
        return result;
    }

}
