package com.gtis.portal.service.server;

import com.gtis.portal.entity.WorkFlowCommission;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @version 1.0 , 2019/12/25
 * @description
 **/
public interface WorkFlowCommissionService {
    /**
     * 获取代办配置分页数据
     * @param workFlowId 工作流id
     * @param principalId 委托人id
     * @param agentId 代办人id
     * @param page 分页
     * @return Page<WorkFlowCommission>
     */
    Page<WorkFlowCommission> queryWorkFlowCommissionList(String workFlowId, String principalId, String agentId, Pageable page);

    /**
     * 获取唯一记录
     * @param workFlowId 工作流id
     * @param principalId 委托人id
     * @param agentId 代办人id
     * @return WorkFlowCommission
     */
    WorkFlowCommission getWorkFlowCommissionByWdidAndYhid(String workFlowId, String principalId, String agentId);

    /**
     * 保存记录
     * @param workFlowCommission 实体类
     */
    void save(WorkFlowCommission workFlowCommission);

    /**
     * 通过id获取记录
     * @param workFlowCommissionId id
     * @return WorkFlowCommission
     */
    WorkFlowCommission getWorkFlowCommission(String workFlowCommissionId);

    /**
     * 根据单个id删除记录
     * @param id id
     */
    void delWorkFlowCommission(String id);

    /**
     * 根据代办人id获取用户代办信息
     * @param agentId 代办人id
     * @return List<WorkFlowCommission>
     */
    List<WorkFlowCommission> getWorkFlowCommissionByAgentId(String agentId);
}
