package com.gtis.portal.service.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.*;
import com.gtis.portal.model.Menu;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfAuthorizeService;
import com.gtis.portal.service.PfBusinessService;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

@Service
public class PfMenuServiceImpl extends BaseServiceImpl<PfMenu, String> implements PfMenuService {
    @Resource(name = "baseDaoImpl")
    BaseDao baseDao;

    @PersistenceContext(unitName = "entityManagerFactory")
    EntityManager em;
    @Autowired
    PfResourceService resourceService;
    @Autowired
    PfBusinessService businessService;
    @Autowired
    PfAuthorizeService authorizeService;
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public PfMenu getMenu(String menuId) {
        return baseDao.getById(PfMenu.class, menuId);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void updateMenu(PfMenu menu) {
        baseDao.update(menu);
    }

    public void addMenu(PfMenu menu) {
        baseDao.save(menu);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void delMenu(PfMenu menu) {
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPQLQuery query = new JPAQuery(em);
        List<PfMenu> menuList = query.from(qPfMenu).where(qPfMenu.menuParentId.eq(menu.getMenuId())).list(qPfMenu);
        if (menuList == null || menuList.size() == 0) {
            new JPADeleteClause(em, qPfMenu).where(qPfMenu.menuId.eq(menu.getMenuId())).execute();
        } else {
            for (PfMenu menuVo : menuList) {
                this.delMenu(menuVo);
            }
        }

    }

    @Cacheable(value = "menuCache", key = "#roles+'getMenusByRole'")
    public Menu getMenusByRole(String roles) {
        List<PfMenu> menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPQLQuery query = new JPAQuery(em);
        if (StringUtils.isBlank(roles))
            menuList = query.from(qPfMenu).orderBy(qPfMenu.menuOrder.asc()).list(qPfMenu);
        else {
            QPfAuthorize qPfAuthorize = QPfAuthorize.pfAuthorize;
            roles = roles.replace("'", "");
            String[] roleList = roles.split(",");
            menuList = query.from(qPfMenu).where(qPfMenu.menuId.in(query.from(qPfAuthorize).where(qPfAuthorize.
                    authorizeObjType.eq(1), qPfAuthorize.menuVisible.gt(0), qPfAuthorize.undertakerId.in(roleList)).
                    distinct().list(qPfAuthorize.authorizeObjId))).orderBy(qPfMenu.menuOrder.asc()).list(qPfMenu);
        }
        HashMap<String, Menu> menuMap = new LinkedHashMap<String, Menu>();
        Menu root = null;
        for (PfMenu menuVo : menuList) {
            Menu menu = toMenu(menuVo);
            menuMap.put(menu.getId(), menu);
        }
        for (Menu menu : menuMap.values()) {
            if (menu.getPid() != null) {
                Menu pMenu = menuMap.get(menu.getPid());
                if (pMenu != null) {
                    pMenu.addChild(menu);
                }
            } else {
                root = menu;
            }
        }
        return root;
    }

    @Override
    @Cacheable(value = "menuCache", key = "#roles+'_'+#subsystem+'getMenusByRole'")
    public Menu getMenusByRole(String roles, String subsystem) {
        List<PfMenu> menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPQLQuery query = new JPAQuery(em);
        if (StringUtils.isBlank(roles))
            menuList = query.from(qPfMenu).orderBy(qPfMenu.menuOrder.asc()).list(qPfMenu);
        else {
            QPfAuthorize qPfAuthorize = QPfAuthorize.pfAuthorize;
            roles = roles.replace("'", "");
            String[] roleList = roles.split(",");
            menuList = query.from(qPfMenu).where(qPfMenu.menuId.in(query.from(qPfAuthorize).where(qPfAuthorize.
                    authorizeObjType.eq(1), qPfAuthorize.menuVisible.gt(0), qPfAuthorize.undertakerId.in(roleList)).
                    distinct().list(qPfAuthorize.authorizeObjId))).orderBy(qPfMenu.menuOrder.asc()).list(qPfMenu);
        }
        HashMap<String, Menu> menuMap = new LinkedHashMap<String, Menu>();
        Menu root = null;
        for (PfMenu menuVo : menuList) {
            Menu menu = toMenu(menuVo);
            menuMap.put(menu.getId(), menu);
        }
        for (Menu menu : menuMap.values()) {
            if (menu.getPid() != null) {
                Menu pMenu = menuMap.get(menu.getPid());
                if (pMenu != null) {
                    pMenu.addChild(menu);
                }
            } else {
                root = menu;
            }
        }
        return root;
    }


    private static Menu toMenu(PfMenu menuVo) {
        Menu menu = new Menu();
        menu.setId(menuVo.getMenuId());
        menu.setIcon(menuVo.getMenuCode());
        menu.setText(menuVo.getMenuName());
        menu.setPid(StringUtils.trimToNull(menuVo.getMenuParentId()));
        menu.setCls(menuVo.getMenuCss());
        menu.setExpanded(menuVo.isMenuExpanded());
        String rid = menuVo.getResourceId();
        if (rid != null) {
            menu.setLink("r:" + rid);
        }
        menu.setModel(menuVo.getMenuModel());
        return menu;
    }

    private PfMenu toMenuByMap(HashMap map) {
        PfMenu menu = new PfMenu();
        menu.setMenuId(MapUtils.getString(map, "MENU_ID"));
        menu.setMenuCode(MapUtils.getString(map, "MENU_CODE"));
        menu.setMenuName(MapUtils.getString(map, "MENU_NAME"));
        menu.setMenuParentId(MapUtils.getString(map, "MENU_PARENT_ID"));
        menu.setResourceId(MapUtils.getString(map, "RESOURCE_ID"));
        menu.setMenuOrder(MapUtils.getIntValue(map, "MENU_ORDER"));
        menu.setMenuCss(MapUtils.getString(map, "MENU_CSS"));
        menu.setMenuExpanded(MapUtils.getBooleanValue(map, "MENU_EXPANDED"));
        menu.setMenuModel(MapUtils.getIntValue(map, "MENU_MODEL"));
        return menu;
    }

    /**
     * 根据菜单id，获取该菜单下所有的上级菜单，包含上级菜单之上的迭代菜单
     * 包含本身
     *
     * @param menuId
     * @return
     */
    public List<PfMenu> getAllParentMenuListByMenuId(String menuId) {
        List<PfMenu> menuList = new ArrayList<PfMenu>();
        String sql = "select m.* from pf_menu m start with m.menu_id='" + menuId
                + "'connect by prior m.menu_parent_id= m.menu_id "
                + " order by m.menu_order";
        List<HashMap> mapList = baseDao.getMapBySql(sql);
        for (HashMap tmp : mapList) {
            menuList.add(toMenuByMap(tmp));
        }
        return menuList;
    }

    @Override
    public Ztree getAllMenuTree() {
        List<PfMenu> menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPQLQuery query = new JPAQuery(em);
        menuList = query.from(qPfMenu).orderBy(qPfMenu.menuOrder.asc()).list(qPfMenu);
        return initZtreeByMenuList(menuList);
    }

    public Ztree initZtreeByMenuList(List<PfMenu> menuList) {
        Ztree root = null;
        if (menuList != null && menuList.size() > 0) {
            HashMap<String, Ztree> menuMap = new LinkedHashMap<String, Ztree>();
            for (PfMenu menuVo : menuList) {
                Ztree tree = toZtree(menuVo);
                menuMap.put(tree.getId(), tree);
            }
            for (Ztree tree : menuMap.values()) {
                if (tree.getPid() != null) {
                    Ztree ztree = menuMap.get(tree.getPid());
                    if (ztree != null) {
                        ztree.addChild(tree);
                    }
                } else {
                    tree.setOpen(true);
                    root = tree;
                }
            }
        }
        return root;
    }

    private Ztree toZtree(PfMenu menuVo) {
        Ztree tree = new Ztree();
        tree.setId(menuVo.getMenuId());
        tree.setName(menuVo.getMenuName());
        tree.setPid(StringUtils.trimToNull(menuVo.getMenuParentId()));
//        tree.setUrl(menuVo.getResourceId());
        return tree;
    }

    public PfMenu getMenuHasResNoSub(String menuId) {
        PfMenu menu = findById(menuId);
        if (menu != null) {
//            menu.setSubsystems(null);
            if (StringUtils.isNotBlank(menu.getResourceId())) {
                PfResource resource = resourceService.findById(menu.getResourceId());
                menu.setResource(resource);
            }
            if (menu.getResource() == null) {
                menu.setResource(new PfResource());
            }
            if (StringUtils.isNotBlank(menu.getResource().getBusinessId())) {
                PfBusiness business = businessService.findById(menu.getResource().getBusinessId());
                menu.getResource().setBusiness(business);
            }
            if (menu.getResource().getBusiness() == null) {
                menu.getResource().setBusiness(new PfBusiness());
            }
        }
        return menu;
    } @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void refreshMenuResouceRel(String menuId,String resourceId) {
        if (StringUtils.isNotBlank(menuId) && StringUtils.isNotBlank(resourceId)){
            String jpql = "update PfMenu t set t.resourceId=?0 where t.menuId=?1 ";
            baseDao.executeJpql(jpql,resourceId,menuId);
        }
    }   public Ztree getMenuTreeByRole(String roleId) {
        List<PfMenu> menuList = authorizeService.getAuthorizeMenuListByRoleId(roleId);
        return initZtreeByMenuList(menuList);
    }  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void resetResouceRel(String resourceId) {
        if (StringUtils.isNotBlank(resourceId)){
            String jpql = "update PfMenu t set t.resourceId=?0 where t.resourceId=?1";
            baseDao.executeJpql(jpql,null,resourceId);
        }
    }
}
