package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.log.AuditLogService;
import cn.gtmap.estateplat.utils.ClientInfoUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysActivityService;
import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.portal.entity.BdcXtLog;
import com.gtis.portal.service.LogService;
import com.gtis.portal.service.server.impl.AuditLogServiceImpl;
import com.gtis.portal.util.CommonUtils;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2016/9/30
 * @description 日志服务实现
 */
@Service
public class LogServiceImpl implements LogService {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    AuditLogServiceImpl auditLogServiceImpl;

    @Override
    public void saveDelTaskLog(String wiid, String taskid, String userid, String reason, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户删除" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            saveLog(request, userid, reason, wiid, content, "删除");
        } catch (Exception e) {

        }

    }

    @Override
    public void saveRetrieveTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户取回" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            saveLog(request, userid, "", wiid, content, "取回");
        } catch (Exception e) {

        }

    }

    public void saveLog(HttpServletRequest request, String userid, String reason, String wiid, String content, String controller) {
        String ip = "";
        String mac = "";
        String computername = "";
        String username = "";
        String macEnable = AppConfig.getProperty("save.log.mac.enable");
        try {
            if (request != null) {
                ip = ClientInfoUtil.getIpAddr(request);
                if (StringUtils.equals(macEnable, "true")) {
                    if (StringUtils.isNotBlank(ip) && !StringUtils.equals(ip, "127.0.0.1")) {
                        mac = ClientInfoUtil.getMACAddress(ip);
                        computername = ClientInfoUtil.getComputerName(ip);
                    }
                }
            }
        } catch (Exception e) {
        }
        if (StringUtils.isNotBlank(userid)) {
            PfUserVo pfUserVo = sysUserService.getUserVo(userid);
            if (pfUserVo != null)
                username = pfUserVo.getUserName();
        }
        BdcXtLog bdcXtLog = new BdcXtLog();
        bdcXtLog.setUserid(userid);
        bdcXtLog.setUsername(username);
        bdcXtLog.setUserid(userid);
        bdcXtLog.setIp(ip);
        bdcXtLog.setMac(mac);
        bdcXtLog.setComputername(computername);
        bdcXtLog.setController(controller);
        bdcXtLog.setCzrq(new Date());
        bdcXtLog.setParmjson(content);
        bdcXtLog.setReason(reason);
        bdcXtLog.setWiid(wiid);
        auditLogServiceImpl.saveAuditLog(bdcXtLog);
    }

    @Override
    public void saveTurnTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户转发" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            saveLog(request, userid, "", wiid, content, "转发");
        } catch (Exception e) {

        }

    }

    @Override
    public void saveTurnBackTaskLog(String wiid, String taskid, String userid, String reason, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户退回" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            saveLog(request, userid, reason, wiid, content, "退回");
        } catch (Exception e) {

        }

    }

    @Override
    public void saveEndTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户办结" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            saveLog(request, userid, "", wiid, content, "办结");
        } catch (Exception e) {

        }

    }

    @Override
    public void saveStopTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户终止" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            saveLog(request, userid, "", wiid, content, "终止");
        } catch (Exception e) {

        }
    }

    @Override
    public void savePostTaskLog(String wiid, String taskid, String userid, String remark, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户挂起" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            saveLog(request, userid, "", wiid, content, "挂起");
        } catch (Exception e) {

        }
    }

    @Override
    public void saveUpPostTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户解挂" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            saveLog(request, userid, "", wiid, content, "解挂");
        } catch (Exception e) {

        }
    }

    @Override
    public void saveCreateTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户创建" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            saveLog(request, userid, "", wiid, content, "创建");
        } catch (Exception e) {

        }
    }

    @Override
    public void savePriorityTaskLog(String wiid, String taskid, String userid, PfWorkFlowInstanceVo pfWorkFlowInstanceVo, HttpServletRequest request) {
        String content = "";
        try {
            if (pfWorkFlowInstanceVo != null) {
                content = "用户调整优先级" + pfWorkFlowInstanceVo.getProId() + "备注：" + pfWorkFlowInstanceVo.getRemark();
                wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
            }
            saveLog(request, userid, "", wiid, content, "调整优先级");
        } catch (Exception e) {

        }
    }

    public void saveLog(HttpServletRequest request, String userid, String content, String controller) {
        String ip = "";
        String mac = "";
        String username = "";
        String macEnable = AppConfig.getProperty("save.log.mac.enable");
        try {
            if (request != null) {
                ip = ClientInfoUtil.getIpAddr(request);
                if (StringUtils.equals(macEnable, "true")) {
                    if (StringUtils.isNotBlank(ip)) {
                        //SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        // System.out.println(sdf.format(new Date()));
                        mac = CommonUtils.getMACAddress(ip);
                        // System.out.println(mac);
                        // System.out.println(sdf.format(new Date()));
                    }
                }
            }
        } catch (Exception e) {
        }
        if (StringUtils.isNotBlank(userid)) {
            PfUserVo pfUserVo = sysUserService.getUserVo(userid);
            if (pfUserVo != null)
                username = pfUserVo.getUserName();
        }
        BdcXtLog bdcXtLog = new BdcXtLog();
        bdcXtLog.setUsername(username);
        bdcXtLog.setUserid(userid);
        bdcXtLog.setIp(ip);
        bdcXtLog.setMac(mac);
        bdcXtLog.setController(controller);
        bdcXtLog.setCzrq(new Date());
        bdcXtLog.setParmjson(content);
        auditLogServiceImpl.saveAuditLog(bdcXtLog);
    }
}
