package com.gtis.portal.service.impl;

import cn.gtmap.estateplat.service.portal.TaskPerformerFilterService;
import com.google.common.collect.Lists;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.portal.entity.BdcXm;
import com.gtis.portal.service.TaskAfterTurnGeneralService;
import com.gtis.portal.service.server.AutoTurnTaskService;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
 * @version 1.0, 2018/7/21
 * @description 创建任务时，固定参与者派件（按照节点配置参与者创建）
 */
public class CreateTaskPerformerFixedServiceImpl implements TaskPerformerFilterService {
    @Autowired
    SysUserService sysUserService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysTaskService sysTaskService;

    @Override
    public List<PfUserVo> getTaskPerformers(String wiid, String targetActivityDefinitionId, PfTaskVo sourceTask, List<PfUserVo> sourceUsers, String wdid) {
        return null;
    }

    @Override
    public WorkFlowInfo createWorkFlowInstance(PfWorkFlowInstanceVo intanceVo, String userId) throws Exception {
        WorkFlowInfo workFlowInfo = null;
        PfWorkFlowDefineVo pfWorkFlowDefineVo = null;
        if (intanceVo == null || StringUtils.isBlank(intanceVo.getWorkflowDefinitionId()))
            return null;
        pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(intanceVo.getWorkflowDefinitionId());
        WorkFlowXml workXml = WorkFlowXmlUtil.getDefineModel(pfWorkFlowDefineVo);
        List<ActivityModel> activityModelList = workXml.getActivityList();
        ActivityModel activityModel = null;
        if (CollectionUtils.isNotEmpty(activityModelList))
            activityModel = activityModelList.get(0);

        //根据模型过滤用户
        if (activityModel != null && CollectionUtils.isNotEmpty(activityModel.getPerformerList())) {
            List<String> pfUserVoList = sysUserService.getAllUserListPerformers(activityModel.getPerformerList());
            workFlowInfo = workFlowService.createWorkFlowInstance(intanceVo, userId);
            // 创建子任务
            if (CollectionUtils.isNotEmpty(pfUserVoList) && workFlowInfo != null && workFlowInfo.getTargetActivitys() != null && StringUtils.isNotBlank(workFlowInfo.getTargetActivitys().get(0).getActivityId())) {
                for (String pfUserId : pfUserVoList) {
                    if(!StringUtils.equals(pfUserId,userId)) {
                        PfTaskVo taskVo = createTaskVo(workFlowInfo.getTargetActivitys().get(0).getActivityId());
                        taskVo.setUserVo(createUserVo(pfUserId));
                        sysTaskService.createTask(taskVo);
                    }
                }
            }
        }

        return workFlowInfo;
    }

    private PfUserVo createUserVo(String userId) {
        PfUserVo userVo = new PfUserVo();
        userVo.setUserId(userId);
        return userVo;
    }

    private PfTaskVo createTaskVo(String activityId) {
        PfTaskVo taskVo = new PfTaskVo();
        String taskId = UUIDGenerator.generate();
        taskVo.setTaskId(taskId);
        taskVo.setActivityId(activityId);
        return taskVo;
    }
}
