package com.gtis.portal.service;

import com.gtis.plat.vo.UserInfo;

import java.util.Map;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/9/30
 * @description 任务中心服务
 */
public interface TaskCenterService {
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否显示已办任务列表
     * @description  是否显示已办任务列表
     */
    boolean handleTaskOverListDisplay(UserInfo userInfo);
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否显示项目任务列表
     * @description 是否显示项目任务列表
     */
    boolean handleProjectListDisplay(UserInfo userInfo);
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否按用户id过滤项目列表
     * @description 是否按用户id过滤项目列表
     */
     boolean handleProjectListFilterUserid(UserInfo userInfo);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否显示超期任务列表
     * @description  是否显示超期任务列表
     */
    boolean handleOverTimeTaskListDisplay(UserInfo userInfo);
    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否显示个人项目列表
     * @description  是否显示个人项目列表
     */
    public boolean handlePersonalProjectListDisplay(UserInfo userInfo);

    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否具有删除任务权限
     * @description  是否具有删除任务权限
     */
    boolean delTaskBtnDisplay(UserInfo userInfo);
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否具有批量转发任务权限
     * @description  是否具有批量转发任务权限
     */
    boolean batchTurnTaskBtnDisplay(UserInfo userInfo);

    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否显示项目转发列表
     * @description  是否显示项目转发列表
     */
    public boolean handleTurnTaskListDisplay(UserInfo userInfo);
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @version 1.0, 2016/9/30
     * @param wiid 工作流实例
     * @return 待办任务、已办任务、项目列表显示房产、国土、不动产超期情况
     * @description  获取待办任务、已办任务、项目列表显示房产、国土、不动产超期情况
     */
    public Map getTaskOverTimeState(String wiid);
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @version 1.0, 2016/9/30
     * @param wiid 工作流实例
     * @return 待办任务、已办任务、项目列表显示项目来源
     * @description  获取待办任务、已办任务、项目列表显示项目来源
     */
    public Map getXmly(String wiid);

    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否显示挂起任务列表
     * @description  是否显示挂起任务列表
     */
    public boolean handlePostTaskListDisplay(UserInfo userInfo);
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否打开待办任务，自动删除其他任务，自动取件
     * @description  是否打开待办任务，自动删除其他任务，自动取件
     */
    public boolean handleTaskDeleteOtherTask(UserInfo userInfo);
    /**
     * @author <a href="mailto:liangxichang@gtmap.cn">liangxichang</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否能进行质检
     * @description  质检
     */
    public boolean handleQualityControlDisplay(UserInfo userInfo);
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
     * @version 1.0, 2016/9/30
     * @param userInfo 当前登录用户信息
     * @return 是否显示监督转发按钮
     * @description  是否显示监督转发按钮
     */
    public boolean turnCheckTaskListDisplay(UserInfo userInfo);
    /**
     * @author <a href="mailto:liangxichang@gtmap.cn">liangxichang</a>
     * @version 1.0, 2020/5/23
     * @param userInfo 当前登录用户信息
     * @return 是否能看到已办任务隐藏的件
     * @description  已办任务
     */
    public boolean handleTaskOverListShowHideDisplay(UserInfo userInfo);
    /**
     * @author <a href="mailto:liangxichang@gtmap.cn">liangxichang</a>
     * @version 1.0, 2020/5/23
     * @param userInfo 当前登录用户信息
     * @return 是否能看到已办任务隐藏的件
     * @description  已办任务
     */
    public boolean batchFinishAndUploadFileBtnDisplay(UserInfo userInfo);
}
