package com.gtis.portal.service;

import com.gtis.portal.entity.PfTaskAgent;

import java.util.List;

/**
 * @author <a href="mailto:liangxichang@gtmap.cn">lxc</a>
 * @version 1.0 , 2020/1/8
 * @description
 **/

public interface PfTaskAgentService {
    /**
     * 通过userId查询记录
     * @param userId 用户 id
     * @return List<PfTaskAgent>
     */
    List<PfTaskAgent> getByUserId(String userId);

    /**
     * 根据受委托人的姓名和代理类型来查找记录
     * @param userId 受委托人的姓名
     * @param agentType 代理类型
     * @return List<PfTaskAgent>
     */
    List<PfTaskAgent> getByUserIdAndAgentType(String userId, Integer agentType);
}
