package com.gtis.portal.service;


import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.model.Menu;
import com.gtis.portal.model.Ztree;

import java.util.List;

public interface PfMenuService extends BaseService<PfMenu, String> {

    /**
     * 获得一个角色下所有的菜单
     *
     * @param roles
     * @return
     */
    Menu getMenusByRole(String roles);

    Menu getMenusByRole(String roles, String subsystem);

    PfMenu getMenu(String menuId);

    /**
     * 保存菜单，修改后的保存
     *
     * @param menu
     */
    void updateMenu(PfMenu menu);

    /**
     * 添加菜单
     *
     * @param menu
     */
    void addMenu(PfMenu menu);

    /**
     * 删除菜单（包括子菜单)
     *
     * @param menu
     */
    void delMenu(PfMenu menu);

    public List<PfMenu> getAllParentMenuListByMenuId(String menuId);

    public Ztree getAllMenuTree();

    public PfMenu getMenuHasResNoSub(String menuId);

    public void refreshMenuResouceRel(String menuId, String resourceId);

    public Ztree getMenuTreeByRole(String roleId);

    public void resetResouceRel(String resourceId);
}
