package com.gtis.portal.web.config;


import cn.gtmap.estateplat.core.support.mybatis.page.model.Page;
import cn.gtmap.estateplat.core.support.mybatis.page.model.PageImpl;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.portal.entity.BdcZdpjjl;
import com.gtis.portal.service.PfMessageService;
import com.gtis.portal.service.server.AutoTurnTaskService;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.web.BaseController;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.QPageRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 自动转发配置
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/autoTurnTask")
public class AutoTurnTaskController extends BaseController {
    private static final Log log = LogFactory.getLog(AutoTurnTaskController.class);

    @Autowired
    AutoTurnTaskService autoTurnTaskService;
    @Autowired
    PfMessageService pfMessageService;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysUserService sysUserService;

    @RequestMapping("")
    public String autoTurnTask(Model model) throws Exception {
        List<PfWorkFlowDefineVo> pfWorkFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();
        List<PfUserVo> pfUserVoList = new ArrayList<PfUserVo>();
        //获取当前用户同部门的人
        if (AppConfig.getBooleanProperty("autoTurnTask.allOrgan_enable", false)) {
            List<PfOrganVo> pfOrganVoList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
            //如果当前用户不属于任何部门，只显示自己
            if (CollectionUtils.isNotEmpty(pfOrganVoList)) {
                List<String> organIdList = new ArrayList<String>();
                for (int i = 0; i < pfOrganVoList.size(); i++) {
                    organIdList.add(pfOrganVoList.get(i).getOrganId());
                }
                pfUserVoList = sysUserService.getUserListByRoleAndOrganIds("", organIdList);
            } else {
                PfUserVo pfUserVo = new PfUserVo();
                pfUserVo.setUserName(SessionUtil.getCurrentUser().getUsername());
                pfUserVo.setUserId(SessionUtil.getCurrentUserId());
                pfUserVoList.add(0, pfUserVo);
            }
        } else {
            pfUserVoList = sysUserService.getAllUsers();
        }

        if (CollectionUtils.isNotEmpty(pfWorkFlowDefineVoList)) {
            PfWorkFlowDefineVo pfWorkFlowDefineVo = new PfWorkFlowDefineVo();
            pfWorkFlowDefineVo.setWorkflowName("全部");
            pfWorkFlowDefineVo.setWorkflowDefinitionId("");
            pfWorkFlowDefineVoList.add(0, pfWorkFlowDefineVo);
        }
        if (CollectionUtils.isNotEmpty(pfUserVoList)) {
            PfUserVo pfUserVo = new PfUserVo();
            pfUserVo.setUserName("全部");
            pfUserVo.setUserId("");
            pfUserVoList.add(0, pfUserVo);
        }
        model.addAttribute("pfWorkFlowDefineVoList", pfWorkFlowDefineVoList);
        model.addAttribute("pfUserVoList", pfUserVoList);
        return "config/auto-turn-task";
    }

    @ResponseBody
    @RequestMapping("/getAutoTurnTaskPagesJson")
    public Object getAutoTurnTaskPagesJson(Pageable pageable, String wdid, String jdmc, String userid, String kqzt, @RequestParam(value = "number", required = false) String number, @RequestParam(value = "currentPage", required = false) String currentPage) {
        int pageNumber = pageable.getPageNumber();
        if (currentPage != null)
            pageNumber = Integer.parseInt(currentPage) - 1;
        QPageRequest pageable1 = new QPageRequest(pageNumber, 10);
        List<PfUserVo> pfUserVoList = new ArrayList<PfUserVo>();
        List<String> userIdList = new ArrayList<String>();
        if (AppConfig.getBooleanProperty("autoTurnTask.allOrgan_enable", false)) {
            //获取当前用户同部门的人,存到pfUserVoList
            List<PfOrganVo> pfOrganVoList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
            //如果当前用户不属于任何部门，只显示自己
            if (CollectionUtils.isNotEmpty(pfOrganVoList)) {
                List<String> organIdList = new ArrayList<String>();
                for (int i = 0; i < pfOrganVoList.size(); i++) {
                    organIdList.add(pfOrganVoList.get(i).getOrganId());
                }
                pfUserVoList = sysUserService.getUserListByRoleAndOrganIds("", organIdList);
            } else {
                PfUserVo pfUserVo = new PfUserVo();
                pfUserVo.setUserName(SessionUtil.getCurrentUser().getUsername());
                pfUserVo.setUserId(SessionUtil.getCurrentUserId());
                pfUserVoList.add(0, pfUserVo);
            }
            for (int i = 0; i < pfUserVoList.size(); i++) {
                userIdList.add(pfUserVoList.get(i).getUserId());
            }
        }

        org.springframework.data.domain.Page<BdcZdpjjl> bdcZdpjjlPage = autoTurnTaskService.queryBdcZdpjjlList(userIdList, wdid, jdmc, userid, kqzt, pageable1);
        Page<BdcZdpjjl> bdcZdpjjlPage1 = null;
        if (bdcZdpjjlPage != null) {
            bdcZdpjjlPage1 = new PageImpl(bdcZdpjjlPage.getContent(), pageNumber + 1, Integer.parseInt(bdcZdpjjlPage.getTotalElements() + ""), 10);
        }
        return bdcZdpjjlPage1;
    }

    @ResponseBody
    @RequestMapping("/getJdAndYhList")
    public Object getJdList(String gzlid, String jdid) {
        Map map = Maps.newHashMap();
        List<PfUserVo> pfUserVoList = Lists.newArrayList();
        List<PfActivityVo> pfActivityVoList = Lists.newArrayList();
        List<ActivityModel> activityModelList = Lists.newArrayList();
        if (StringUtils.isNotBlank(gzlid)) {
            String xml = sysWorkFlowDefineService.getWorkFlowDefineXml(gzlid);
            if (StringUtils.isNotBlank(xml)) {
                WorkFlowXml modelXml = new WorkFlowXml(xml);
                activityModelList = modelXml.getActivityList();
            }
        }
        if (CollectionUtils.isNotEmpty(activityModelList)) {
            if (StringUtils.isBlank(jdid))
                jdid = activityModelList.get(0).getDefineId();
            for (ActivityModel activityModel : activityModelList) {
                if (activityModel != null && StringUtils.equals(activityModel.getDefineId(), jdid)) {
                    List<PerformerModel> performerModelList = activityModel.getPerformerList();
                    if (CollectionUtils.isNotEmpty(performerModelList)) {
                        for (PerformerModel performerModel : performerModelList) {
                            if (StringUtils.isNotBlank(performerModel.getUserId())) {
                                PfUserVo pfUserVo = new PfUserVo();
                                pfUserVo.setUserId(performerModel.getUserId());
                                pfUserVo.setUserName(sysUserService.getUserVo(performerModel.getUserId()).getUserName());
                                pfUserVoList.add(pfUserVo);
                            }
                            if (StringUtils.isNotBlank(performerModel.getRoleId())) {
                                List<PfUserVo> pfUserVoList1 = sysUserService.getUserListByRole(performerModel.getRoleId());
                                if (CollectionUtils.isNotEmpty(pfUserVoList1))
                                    pfUserVoList.addAll(pfUserVoList1);
                            }
                            if (StringUtils.isNotBlank(performerModel.getOrganId())) {
                                List<PfUserVo> pfUserVoList1 = sysUserService.getUserListByOragn(performerModel.getOrganId());
                                if (CollectionUtils.isNotEmpty(pfUserVoList1))
                                    pfUserVoList.addAll(pfUserVoList1);
                            }
                        }
                    }
                }
                PfActivityVo pfActivityVo = new PfActivityVo();
                pfActivityVo.setActivityDefinitionId(activityModel.getDefineId());
                pfActivityVo.setActivityName(activityModel.getActivityDefineName());
                pfActivityVoList.add(pfActivityVo);
            }
        }
        List<PfUserVo> pfUserVoListTemp = Lists.newArrayList();
        List<PfUserVo> pfUserVoList2 = Lists.newArrayList();
        if (AppConfig.getBooleanProperty("autoTurnTask.allOrgan_enable", false)) {
            //获取当前用户同部门的人,存到pfUserVoList
            List<PfOrganVo> pfOrganVoList = sysUserService.getOrganListByUser(SessionUtil.getCurrentUserId());
            //如果当前用户不属于任何部门，只显示自己
            if (CollectionUtils.isNotEmpty(pfOrganVoList)) {
                List<String> organIdList = new ArrayList<String>();
                for (int i = 0; i < pfOrganVoList.size(); i++) {
                    organIdList.add(pfOrganVoList.get(i).getOrganId());
                }
                pfUserVoListTemp = sysUserService.getUserListByRoleAndOrganIds("", organIdList);
            } else {
                PfUserVo pfUserVo = new PfUserVo();
                pfUserVo.setUserName(SessionUtil.getCurrentUser().getUsername());
                pfUserVo.setUserId(SessionUtil.getCurrentUserId());
                pfUserVoListTemp.add(0, pfUserVo);
            }
            for (int i = 0; i < pfUserVoList.size(); i++) {
                boolean flag = false;
                for (int j = 0; j < pfUserVoListTemp.size(); j++) {
                    if (pfUserVoList.get(i).getUserId().equals(pfUserVoListTemp.get(j).getUserId())) {
                        flag = true;
                    }
                }
                if (flag) {
                    pfUserVoList2.add(pfUserVoList.get(i));
                }
            }
        }
        map.put("jdList", pfActivityVoList);
        if (CollectionUtils.isNotEmpty(pfUserVoList2)) {
            map.put("yhList", pfUserVoList2);
        } else {
            map.put("yhList", pfUserVoList);
        }

        return map;
    }

    @ResponseBody
    @RequestMapping("/save")
    public Object save(BdcZdpjjl bdcZdpjjl) {
        String msg = "true";
        try {
            BdcZdpjjl bdcZdpjjl1 = autoTurnTaskService.getBdcZdpjjlByWdidAndJdidAndYhid(bdcZdpjjl.getGzlid(), bdcZdpjjl.getJdid(), bdcZdpjjl.getYhid(), bdcZdpjjl.getKqzt());
            if (bdcZdpjjl1 != null && !StringUtils.equals(bdcZdpjjl1.getPjjlid(), bdcZdpjjl.getPjjlid())) {
                msg = "数据库存在该类型数据！";
                return URLEncoder.encode(msg);
            }
            autoTurnTaskService.save(bdcZdpjjl);
        } catch (Exception e) {
            msg = "保存不成功！";
        }

        return URLEncoder.encode(msg);
    }

    @ResponseBody
    @RequestMapping(value = "del")
    public HashMap del(String ids) {
        HashMap map = new HashMap();
        String result = "删除成功！";
        try {
            if (org.apache.commons.lang3.StringUtils.isNotBlank(ids)) {
                if (ids.contains(",")) {
                    for (String id : ids.split(","))
                        autoTurnTaskService.delBdcZdpjjl(id);
                } else
                    autoTurnTaskService.delBdcZdpjjl(ids);
            }

        } catch (Exception e) {
            result = "删除失败！";
            e.printStackTrace();
        } finally {
            map.put("result", result);
        }
        return map;
    }

    @ResponseBody
    @RequestMapping("/getBdcZdpjjl")
    public Object getBdcZdpjjl(String id) {
        BdcZdpjjl bdcZdpjjl = null;
        if (StringUtils.isNotBlank(id))
            bdcZdpjjl = autoTurnTaskService.getBdcZdpjjl(id);
        if (bdcZdpjjl == null)
            bdcZdpjjl = new BdcZdpjjl();

        return bdcZdpjjl;
    }

    @ResponseBody
    @RequestMapping("/batSaveKqzt")
    public Object batSaveKqzt(String wdid, String jdmc, String userid, String kqzt, @RequestParam(value = "batKqzt", required = false) String batKqzt, @RequestParam(value = "ids", required = false) String ids) {
        String msg = "true";
        List<BdcZdpjjl> bdcZdpjjlList = Lists.newArrayList();
        if (StringUtils.isNotBlank(ids)) {
            String[] idStrs = ids.split(",");
            for (String id : idStrs) {
                BdcZdpjjl bdcZdpjjl = autoTurnTaskService.getBdcZdpjjl(id);
                if (bdcZdpjjl != null)
                    bdcZdpjjlList.add(bdcZdpjjl);
            }
        } else
            bdcZdpjjlList = autoTurnTaskService.queryBdcZdpjjlList(wdid, jdmc, userid, kqzt);
        if (CollectionUtils.isNotEmpty(bdcZdpjjlList)) {
            for (BdcZdpjjl bdcZdpjjl : bdcZdpjjlList) {
                bdcZdpjjl.setKqzt(batKqzt);
                autoTurnTaskService.save(bdcZdpjjl);
            }
        }
        return msg;
    }
}
