package com.gtis.portal.web;

import cn.gtmap.estateplat.service.portal.TaskPerformerFilterService;
import com.alibaba.fastjson.JSONArray;
import com.gtis.common.http.Utf8PostMethod;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.portal.entity.BdcXm;
import com.gtis.portal.entity.BdcZdpjjl;
import com.gtis.portal.entity.BdcZdpjjlAll;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.PortalException;
import com.gtis.portal.service.TaskBeforeTurnValidationService;
import com.gtis.portal.service.impl.TaskBeforeTurnValidationServiceContext;
import com.gtis.portal.service.impl.TaskPerformerFilterServiceContext;
import com.gtis.portal.service.server.AutoTurnAllTaskService;
import com.gtis.portal.service.server.AutoTurnTaskService;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.tree.DefaultText;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/**
 * 转发
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zhangxing</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/turnWorkFlow")
public class TurnWorkFlowController extends BaseController {
    private static final Log log = LogFactory.getLog(TurnWorkFlowController.class);
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    NodeService nodeService;
    @Autowired
    SysWorkFlowInstanceService workFlowIntanceService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    WorkFlowCoreService workFlowService;
    @Autowired
    SysOpinionService opinionService;
    @Autowired
    SysTaskTurnService sysTaskTurnService;
    @Autowired
    TaskPerformerFilterServiceContext taskPerformerFilterServiceContext;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    SysUserService sysUserService;
    @Resource(name = "taskPerformerMinWorkloadFilterService")
    TaskPerformerFilterService taskPerformerFilterService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    TaskBeforeTurnValidationServiceContext taskBeforeTurnValidationServiceContext;
    @Autowired
    SysActivityService sysActivityService;
    @Autowired
    AutoTurnTaskService autoTurnTaskService;
    @Autowired
    AutoTurnAllTaskService autoTurnAllTaskService;
    @Autowired
    BdcXmService bdcXmService;

    /**
     * 弹出窗体再选择转发
     *
     * @param taskid
     * @return
     * @throws Exception
     */
    @RequestMapping("")
    public String turnWorkFlow(Model model, @RequestParam(value = "taskid") String taskid, @RequestParam(value = "backzj") String backzj) throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
        String proid = "";
        String wiid = "";
        if (info != null && info.getWorkFlowIntanceVo() != null) {
            if (StringUtils.isNotBlank(info.getWorkFlowIntanceVo().getProId())) {
                proid = info.getWorkFlowIntanceVo().getProId();
            }
            if (StringUtils.isNotBlank(info.getWorkFlowIntanceVo().getProId())) {
                wiid = info.getWorkFlowIntanceVo().getWorkflowIntanceId();
            }
        }
        //zdd 2016-09-22 调用业务服务  设置任务转发信息
        Boolean resetTurnXml = AppConfig.getBooleanProperty("task.turnPerformer.estatePlatCustomized", false);
        if (resetTurnXml) {
            HashMap param = new HashMap();
            param.put("userid", userId);
            param.put("taskid", taskid);
            param.put("wiid", wiid);
            String bdcdjUrl = AppConfig.getProperty("bdcdj.url");
            String url = bdcdjUrl.concat("/rest/autoTurn/setTurnUser/{userid}/{taskid}/{wiid}");
            Object obj = restTemplate.getForObject(url, String.class, param);
        }

        String taskTurnInfo = sysTaskTurnService.getTurnInfoFromGlobalVal(taskid, info.getWorkFlowIntanceVo().getWorkflowIntanceId());
        String turnXml;
        if (StringUtils.isNotBlank(taskTurnInfo))
            turnXml = taskTurnInfo;
        else
            turnXml = turnInfo(info);
        String opinions = JSONArray.toJSONString(opinionService.getOpinionList(userId, info.getWorkFlowDefineVo().getWorkflowName()));

        WorkFlowXml workFlowXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());

        ActivityModel activityModel = workFlowXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
        String confirmTurnInfo = "false";
        if ("true".equalsIgnoreCase(activityModel.getExtendedAttribute("ConfirmTurnInfo")))
            confirmTurnInfo = "true";
        String version = AppConfig.getProperty("portal.version");

        String taskBeforeTurnValidation = "false";
//        if("true".equalsIgnoreCase(activityModel.getExtendedAttribute("TaskBeforeTurnValidation")))
//            taskBeforeTurnValidation = "true";
        if (AppConfig.getProperty("task.taskBeforeTurn.enableValidation") != null)
            taskBeforeTurnValidation = AppConfig.getProperty("task.taskBeforeTurn.enableValidation");
        String hideCheckBox = AppConfig.getProperty("hide.send.msg.checkbox");
        if (StringUtils.equals(hideCheckBox, "true"))
            hideCheckBox = "none";
        else
            hideCheckBox = "block";
        model.addAttribute("hideCheckBox", hideCheckBox);
        model.addAttribute("taskid", taskid);
        model.addAttribute("userId", userId);
        model.addAttribute("proid", proid);
        model.addAttribute("bdcdjUrl", AppConfig.getProperty("bdcdj.url"));
        model.addAttribute("version", version);
        model.addAttribute("turnXml", turnXml);
        model.addAttribute("opinions", opinions);
        model.addAttribute("confirmTurnInfo", confirmTurnInfo);
        model.addAttribute("resetTurnXml", resetTurnXml);
        model.addAttribute("taskBeforeTurnValidation", taskBeforeTurnValidation);
        model.addAttribute("backzj", backzj);
        //System.out.println(backzj);
        return "turn-workFlow";
    }

    @RequestMapping("/batch")
    public String batchTurnWorkFlow(Model model, @RequestParam(value = "taskIds") String taskIds) throws Exception {
        if (StringUtils.isBlank(taskIds))
            throw new NullPointerException();
        String[] taskIdArray = taskIds.split(",");
        String taskId = taskIdArray[0];
        model.addAttribute("batchTurnTaskIds", StringUtils.join(taskIdArray, ","));
        return turnWorkFlow(model, taskId, "0");
    }

    /**
     * <Activitys RelType="or">
     * <Activity Name="转发活动一" Id="a1" MutiSelect="true" DefaultSelected="true">
     * <User Name="××部门" Id="1">
     * <UserInfo Name="u1" Id="u1" DefaultSelected="true"/>
     * <UserInfo Name="u11" Id="u11"/>
     * </User>
     * <User Name="××部门" Id="2">
     * <UserInfo Name="au2" Id="u2"/>
     * <UserInfo Name="au21" Id="u21"/>
     * </User>
     * <User Name="××角色" Id="3">
     * <UserInfo Name="au3" Id="u3" DefaultSelected="true"/>
     * <UserInfo Name="au31" Id="u31"/>
     * <UserInfo  Name="au32" Id="u32"/>
     * </User>
     * </Activity>
     * <Activity Name="转发活动二" Id="a2" MutiSelect="false">
     * <User Name="××部门" Id="11">
     * <UserInfo Name="u1" Id="u1"/>
     * <UserInfo Name="u11" Id="u11"/>
     * </User>
     * </Activitys>
     */

    private String turnInfo(WorkFlowInfo info) throws Exception {
        boolean ignore = false;
        String[] sqlx = AppConfig.getProperty("autoTurnAllTask.sqlx.ignore").split(",");
        //获取当前流程的申请类型
        String wiid = info.getWorkFlowIntanceVo().getWorkflowIntanceId();
        List<BdcXm> bdcXmList = bdcXmService.getBdcXmList(wiid);

        if (CollectionUtils.isNotEmpty(bdcXmList) && sqlx.length > 0) {
            for (int i = 0; i < bdcXmList.size(); i++) {
                for (int j = 0; j < sqlx.length; j++) {
                    if (bdcXmList.get(i).getSqlx().equals(sqlx[j])) {
                        ignore = true;
                    }
                }

            }
        }
        boolean isTaskBack = info.getSourceTask() != null ? info.getSourceTask().isBackState() : false;
        List<PfActivityVo> activityList = sysTaskService.getWorkFlowInstanceAllActivityList(info.getWorkFlowIntanceVo().getWorkflowIntanceId());
        //获取创建人id
        String createUser = info.getWorkFlowIntanceVo().getCreateUser();
        //根据创建人id获取所属角色id
        List<PfRoleVo> roleList = sysUserService.getRoleListByUser(createUser);
        if (CollectionUtils.isNotEmpty(activityList)) {
            for (int i = activityList.size() - 1; i > -1; i--) {
                PfActivityVo pfActivityVo = activityList.get(i);
                if (pfActivityVo.isBackState()) {
                    isTaskBack = true;
                    break;
                }
            }
        }
        // 获取工作流实例模型
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
        // 获取当前活动定义
        ActivityModel activityModel = xmlDao.getActivity(info.getSourceActivity().getActivityDefinitionId());

        String autoTurnTaskEnable = AppConfig.getProperty("autoTurnTask.enble");
        String autoTurnAllTaskEnable = AppConfig.getProperty("autoTurnAllTask.enble");
        //全局自动派件
        List<BdcZdpjjlAll> bdcZdpjjlAllList = autoTurnTaskService.queryBdcZdpjjlAllList("1");


        //判断当前用户的角色是否包含在配置的角色内
        String configRoles = AppConfig.getProperty("autoTurnTask.unEnble.roles");
        String arrRoles[] = configRoles.split(",");
        for (int i = 0; i < roleList.size(); i++) {
            for (int j = 0; j < arrRoles.length; j++) {
                if (roleList.get(i).getRoleId().equals(arrRoles[j])) {
                    autoTurnAllTaskEnable = "false";
                    break;
                }
            }
        }
        String filterType = null;
        List<String> filterStr = null;
        if (StringUtils.isNotBlank(activityModel.getFilterInfo())) {
            //过滤信息对象
            Document fileDoc = DocumentHelper.parseText(activityModel.getFilterInfo());
            //过滤类型：User,Organ,Role
            String user = fileDoc.getRootElement().valueOf("@type");
            org.dom4j.Node corNode = fileDoc.selectSingleNode("//Filter/" + user + "[@Id='" + SessionUtil.getCurrentUserId() + "']/Correspondence");
            if (corNode != null) {
                filterType = corNode.valueOf("@type");
                List<DefaultText> organList = corNode.selectNodes(filterType + "/text()");
                if (organList != null && !organList.isEmpty()) {
                    filterStr = new ArrayList<String>();
                    for (DefaultText text : organList) {
                        filterStr.add(text.getText());
                    }
                }
            }
        }

        WorkFlowTransInfo transInfo = info.getTransInfo();
        Document doc = org.dom4j.DocumentHelper.createDocument();
        Element root = doc.addElement("Activitys");
        if (transInfo.getTransType().equalsIgnoreCase("and"))
            root.addAttribute("RelType", "and");
        else
            root.addAttribute("RelType", "or");

        if (activityModel.getIsRequiredOpinion().equalsIgnoreCase("true")) {
            root.addAttribute("ReqOpinion", "true");
        } else {
            root.addAttribute("ReqOpinion", "false");
        }
        if (activityModel.getIsSendSMS().equalsIgnoreCase("true")) {
            root.addAttribute("SendSMS", "true");
        } else {
            root.addAttribute("SendSMS", "false");
        }
        if (StringUtils.isNotBlank(activityModel.getCooperRootId())) {
            root.addAttribute("cooperRootId", activityModel.getCooperRootId());
        }

        List<ActivityModel> lstTrans = transInfo.getTranActivitys();
        if (lstTrans.size() < 2)
            root.addAttribute("RelType", "or");
        for (ActivityModel aModel : lstTrans) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", aModel.getActivityDefineName());
            ActivityEle.addAttribute("Id", aModel.getDefineId());
            if (aModel.isMutiSelect())
                ActivityEle.addAttribute("MutiSelect", "true");

            if (!aModel.isSelectAll())
                ActivityEle.addAttribute("SelectAll", "false");
            else
                ActivityEle.addAttribute("SelectAll", "true");

            if (aModel.getActivityDefineName().equalsIgnoreCase(activityModel.getDefaultSelectName()))
                ActivityEle.addAttribute("DefaultSelected", "true");
            else
                ActivityEle.addAttribute("DefaultSelected", "false");
            String userName = null;
            //任务转发的参与人是否自动默认为当前用户
            if (AppConfig.getProperty("task.turnPerformer.useCurrentUser") != null && StringUtils.equals(AppConfig.getProperty("task.turnPerformer.useCurrentUser").toString(), "true")) {
                PfUserVo pfUserVo = sysUserService.getUserVo(info.getUserId());
                if (pfUserVo != null)
                    userName = pfUserVo.getUserName();
            }
            if (StringUtils.isNotBlank(aModel.getExtendedAttribute("DefaultSelectedUser"))) {
                userName = aModel.getExtendedAttribute("DefaultSelectedUser");
            }

            String performerStrategy = aModel.getExtendedAttribute("FilterTransferPerformerStrategy");
            for (PerformerTaskModel userModel : aModel.getPerformerModelList()) {
                if (filterStr != null && userModel.getType().equals(filterType)) {
                    if (!filterStr.contains(userModel.getId())) {
                        continue;
                    }
                }
                Element User = ActivityEle.addElement("User");
                User.addAttribute("Name", userModel.getName());
                User.addAttribute("Id", userModel.getId());
                List<PfUserVo> performerUsers = new ArrayList<PfUserVo>();
                if (StringUtils.equals(autoTurnTaskEnable, "true")) {
                    //   获取自动派件
                    List<PfUserVo> turnTaskList = taskPerformerFilterService.getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
                    if (CollectionUtils.isNotEmpty(turnTaskList))
                        userName = turnTaskList.get(0).getUserName();
                }
                if (isTaskBack && AppConfig.getBooleanProperty("task.turnPerformer.useTurnBack", false)) {
                    //流程转发人是否默认任务的退回人
                    //查出来所有的可转发人员，根据gzlid、jdid，kqzt（没请假的），对比退回人员，如果退回人员在可转发人员中存在，那么走正常逻辑
                    List<PfUserVo> turnBackList = taskPerformerFilterServiceContext.getTaskPerformerFilterServiceByName(TaskPerformerFilterServiceContext.USE_TURN_BACK_PERFORMER)
                            .getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());

                    if (StringUtils.equals(autoTurnAllTaskEnable, "true") && !ignore) {
                        List<BdcZdpjjlAll> bdcZdpjjlList = autoTurnAllTaskService.queryBdcZdpjjlList("", "1");
                        if (CollectionUtils.isNotEmpty(turnBackList) && CollectionUtils.isNotEmpty(bdcZdpjjlList)) {
                            for (int i = 0; i < turnBackList.size(); i++) {
                                for (int j = 0; j < bdcZdpjjlList.size(); j++) {
                                    if (turnBackList.get(i).getUserId().equals(bdcZdpjjlList.get(j).getYhid())) {
                                        performerUsers = taskPerformerFilterServiceContext.getTaskPerformerFilterServiceByName(TaskPerformerFilterServiceContext.USE_TURN_BACK_PERFORMER)
                                                .getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
                                    }
                                }
                            }
                        }
                    } else if (StringUtils.equals(autoTurnTaskEnable, "true")) {
                        List<BdcZdpjjl> bdcZdpjjlList = autoTurnTaskService.queryBdcZdpjjlList(info.getWorkFlowDefineVo().getWorkflowDefinitionId(), aModel.getDefineId(), "1");
                        if (CollectionUtils.isNotEmpty(turnBackList) && CollectionUtils.isNotEmpty(bdcZdpjjlList)) {
                            for (int i = 0; i < turnBackList.size(); i++) {
                                for (int j = 0; j < bdcZdpjjlList.size(); j++) {
                                    if (turnBackList.get(i).getUserId().equals(bdcZdpjjlList.get(j).getYhid())) {
                                        performerUsers = taskPerformerFilterServiceContext.getTaskPerformerFilterServiceByName(TaskPerformerFilterServiceContext.USE_TURN_BACK_PERFORMER)
                                                .getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
                                    }
                                }
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty(performerUsers)) {
                        performerUsers = taskPerformerFilterServiceContext.getTaskPerformerFilterServiceByName(TaskPerformerFilterServiceContext.USE_TURN_BACK_PERFORMER)
                                .getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
                    }
                    if (CollectionUtils.isNotEmpty(performerUsers)) {
                        ActivityEle.addAttribute("SelectAll", "false");
                    }
                } else if (StringUtils.isNotBlank(performerStrategy)) {
                    performerUsers = taskPerformerFilterServiceContext.getTaskPerformerFilterServiceByName(performerStrategy)
                            .getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
                    if (CollectionUtils.isNotEmpty(performerUsers))
                        ActivityEle.addAttribute("SelectAll", "false");
                } else {
                    performerUsers = userModel.getUserList();
                }
                if (CollectionUtils.isEmpty(performerUsers)) {
                    performerUsers = userModel.getUserList();
                }
                List<BdcZdpjjlAll> bdcZdpjjlAllList1 = new ArrayList<BdcZdpjjlAll>();
                //筛选出bdcZdpjjlAllList在performerUsers存在的人
                for (int i = 0; i < bdcZdpjjlAllList.size(); i++) {
                    for (int j = 0; j < performerUsers.size(); j++) {
                        if (bdcZdpjjlAllList.get(i).getYhid().equals(performerUsers.get(j).getUserId())) {
                            bdcZdpjjlAllList1.add(bdcZdpjjlAllList.get(i));
                        }
                    }
                }
                for (PfUserVo vo : performerUsers) {
                    Element UserInfo = User.addElement("UserInfo");
                    UserInfo.addAttribute("Name", vo.getUserName());
                    UserInfo.addAttribute("Id", vo.getUserId());
                    if (StringUtils.equals(autoTurnAllTaskEnable, "true") && CollectionUtils.isNotEmpty(bdcZdpjjlAllList1) && !ignore) {
                        String userid = bdcZdpjjlAllList1.get(0).getYhid();
                        if (userid.equals(vo.getUserId())) {
                            User.addAttribute("DefaultSelected", "true");
                            UserInfo.addAttribute("DefaultSelected", "true");
                        }
                    } else {
                        if (StringUtils.isNotBlank(userName) && vo.getUserName().equalsIgnoreCase(userName)) {
                            User.addAttribute("DefaultSelected", "true");
                            UserInfo.addAttribute("DefaultSelected", "true");
                        }
                    }
                }
            }
        }
        // 加入是否可以办结
        if (transInfo.isCanFinish()) {
            Element ActivityEle = root.addElement("Activity");
            ActivityEle.addAttribute("Name", "任务办结");
            ActivityEle.addAttribute("Id", "-1");
        }

        doc = httpFilterXml(doc, activityModel, info);

        return doc.getRootElement().asXML();
    }

    /**
     * 通过TurnInfo处理url
     *
     * @param doc
     * @return
     */
    private Document httpFilterXml(Document doc, ActivityModel actModel, WorkFlowInfo info) {
        if (StringUtils.isNotBlank(actModel.getTurnInfoUrl())) {
            String url = actModel.getTurnInfoUrl();
            if (!url.startsWith("http")) {
                url = AppConfig.getPlaceholderValue(url);
            }
            HttpClient httpClient = new org.apache.commons.httpclient.HttpClient();
            PostMethod postMethod = new Utf8PostMethod(url);
            NameValuePair[] data = {
                    new NameValuePair("turnInfo", doc.asXML()),
                    new NameValuePair("userId", info.getUserId()),
                    new NameValuePair("proId", (info.getWorkFlowIntanceVo() == null) ? "" : info.getWorkFlowIntanceVo().getProId())
            };

            postMethod.setRequestBody(data);
            int status = 0;
            try {
                status = httpClient.executeMethod(postMethod);
            } catch (IOException e) {
                log.error("TurnInfo filter url request failer{}", e);
            }
            if (status == HttpStatus.SC_OK) {
                try {
                    String xml = postMethod.getResponseBodyAsString();
                    if (StringUtils.isNotBlank(xml)) {
                        doc = DocumentHelper.parseText(xml);
                    }
                } catch (Exception e) {
                    log.error("TurnInfo filter url request success,prase failure{}", e);
                }
            } else {
                log.error("TurnInfo filter url request failer");
            }
        }
        return doc;
    }

    @ResponseBody
    @RequestMapping(value = "/getTurnWorkFlowInfo", method = RequestMethod.GET)
    public String getTurnWorkFlowInfo(Model model, @RequestParam(value = "taskid", required = false) String taskid) throws Exception {
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(SessionUtil.getCurrentUserId(), taskid);
        String proid = "";
        if (info != null && info.getWorkFlowIntanceVo() != null && StringUtils.isNotBlank(info.getWorkFlowIntanceVo().getProId()))
            proid = info.getWorkFlowIntanceVo().getProId();
        return proid;
    }

    @ResponseBody
    @RequestMapping(value = "/checkWorkFlowTask", method = RequestMethod.POST)
    public Object checkWorkFlowTask(@RequestParam(value = "taskid") String taskId) throws Exception {
        String userId = SessionUtil.getCurrentUserId();
        if (StringUtils.isNotBlank(taskId)) {
            String[] taskIds = StringUtils.split(taskId, ",");
            if (taskBeforeTurnValidationServiceContext != null && CollectionUtils.isNotEmpty(taskBeforeTurnValidationServiceContext.getTaskBeforeTurnValidationServices())) {
                for (String value : taskIds) {
                    for (TaskBeforeTurnValidationService taskBeforeTurnValidationService : taskBeforeTurnValidationServiceContext.getTaskBeforeTurnValidationServices()) {
                        if (!taskBeforeTurnValidationService.validateTask(value, userId))
                            throw new PortalException(ExceptionCode.TASK_BEFORE_TURN_VALIDATION_ERROR);
                    }

                }
            }
            return handlerSuccessJson();
        }
        throw new RuntimeException("请选择要转发的待办任务！");
    }

//    /**
//     * 自动转发，不需要弹出窗体再选择转发
//     *
//     * @param taskid
//     * @return
//     * @throws Exception
//     */
//    @ResponseBody
//    @RequestMapping(value = "/autoTurnTask", method = RequestMethod.GET)
//    public Object turnTask(@RequestParam(value = "taskid") String taskid) throws Exception {
//        String msg = "true";
//        String userId = SessionUtil.getCurrentUserId();
//        try {
//            WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userId, taskid);
//            // 处理活动
//            List<ActivityModel> lstActivityModel = info.getTransInfo().getTranActivitys();
//
//            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
//            ActivityModel activityModel = workXml.getActivity(info.getSourceActivity().getActivityDefinitionId());
//            //下一个默认活动的处理
//            String defaultSelectNextActivityName = activityModel.getDefaultSelectName();
//            if (StringUtils.isNotBlank(defaultSelectNextActivityName)) {
//                for (Iterator<ActivityModel> itModel = lstActivityModel.iterator(); itModel.hasNext(); ) {
//                    ActivityModel model = itModel.next();
//                    if (!defaultSelectNextActivityName.equalsIgnoreCase(model.getActivityDefineName()))
//                        itModel.remove();
//                }
//            }
//            //根据模型过滤用户
//
//            boolean isTaskBack = info.getSourceTask() != null ? info.getSourceTask().isBackState() : false;
//            String autoTurnTaskEnable = AppConfig.getProperty("autoTurnTask.enble");
//            for (ActivityModel aModel : lstActivityModel) {
//                List<PfUserVo> performerUsers;
//                String performerStrategy = aModel.getExtendedAttribute("FilterTransferPerformerStrategy");
//                List<PfTaskVo> targetTaskVoList = info.getTargetTasks();
//                for (PerformerTaskModel userModel : aModel.getPerformerModelList()) {
//                    if (isTaskBack && AppConfig.getBooleanProperty("task.turnPerformer.useTurnBack", false)) {
//                        performerUsers = taskPerformerFilterServiceContext.getTaskPerformerFilterServiceByName(TaskPerformerFilterServiceContext.USE_TURN_BACK_PERFORMER)
//                                .getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
//
//                    } else if (StringUtils.isNotBlank(performerStrategy)) {
//                        performerUsers = taskPerformerFilterServiceContext.getTaskPerformerFilterServiceByName(performerStrategy)
//                                .getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
//
//                    } else if (StringUtils.equals(autoTurnTaskEnable, "true")) {
//                        performerUsers = taskPerformerFilterService.getTaskPerformers(info.getWorkFlowIntanceVo().getWorkflowIntanceId(), aModel.getDefineId(), info.getSourceTask(), userModel.getUserList(), info.getWorkFlowDefineVo().getWorkflowDefinitionId());
//
//
//                    } else {
//                        performerUsers = userModel.getUserList();
//                    }
//                    userModel.setUserList(performerUsers);
//                }
//            }
//
//            /**
//             * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
//             * @description  代办任务转发流程，触发登记工作流事件
//             */
//            if (workFlowEventServiceContext != null && CollectionUtils.isNotEmpty(workFlowEventServiceContext.getWorkFlowEventServiceList())) {
//                for (WorkFlowEventService workFlowEventService : workFlowEventServiceContext.getWorkFlowEventServiceList()) {
//                    if (StringUtils.isNotBlank(taskid)) {
//                        String[] taskids = taskid.split(",");
//                        for (String id : taskids) {
//                            //WorkFlowInfo info = workFlowCoreService.getWorkFlowTurnInfo(userid, id);
//                            workFlowEventService.doWork(info, "WorkFlow_BeforeTurn");
//                            workFlowEventService.doWork(info, "WorkFlow_Turn");
//                        }
//                    }
//                }
//            }
//
//
//            //开始转发
//            workFlowService.postWorkFlow(userId, taskid, info);
//
//
//            /**
//             * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
//             * @description  代办任务转发需要考虑是否是办结
//             */
//
//            if (workFlowEventServiceContext != null && CollectionUtils.isNotEmpty(workFlowEventServiceContext.getWorkFlowEventServiceList())) {
//                for (WorkFlowEventService workFlowEventService : workFlowEventServiceContext.getWorkFlowEventServiceList()) {
//                    if (StringUtils.isNotBlank(taskid)) {
//                        String[] taskids = taskid.split(",");
//                        for (String id : taskids) {
//                            //转发检查是否办结，代办任务使用
//                            String activityDefineId = info.getSourceActivity().getActivityDefinitionId();
//                            // 判断是否任务办结，两种情况（1为最后一个活动，2为中间活动的）
//                            if (info.getTransInfo().getTranActivitys().size() == 0) {
//                                ActivityModel aModel = workXml.getActivity(activityDefineId);
//                                ///////排除WaitAllUsers情况，如果其他人还在办理///////////
//                                PfActivityVo sourceActivityVo = info.getSourceActivity();
//                                List<PfTaskVo> lstTasks= taskService.getTaskListByActivity(sourceActivityVo.getActivityId());
////                                List<PfTaskVo> lstTasks = this.getTaskService().getTaskListByActivity(sourceActivityVo.getActivityId());
//                                if (lstTasks.size() > 0) {
//                                    return true;
//                                }
//
//                                //////////////////////////////////////////////////////////
//                                String endActivityDefine = workXml.getEndActivityDefine();
//                                if (StringUtils.isBlank(endActivityDefine)) {
//                                    ///没有结束节点
//                                    endActivityDefine = "";
//                                }
//                                if (endActivityDefine.equals(activityDefineId) || aModel.isCanFinish()) {
//                                    workFlowEventService.doWork(info, "WorkFlow_End");
//                                } else if (workXml.getActivitiesCount() == 1) {
//                                    ////只有一个节点，over
//                                    workFlowEventService.doWork(info, "WorkFlow_End");
//                                }
//                            }
//                        }
//                    }
//                }
//            }
//
//        } catch (Exception e) {
//            if (e.getMessage() != null)
//                msg = URLEncoder.encode(e.getMessage());
//            else
//                msg = "";
//        }
//        return msg;
//    }

    @ResponseBody
    @RequestMapping(value = "/sendMsg")
    public String sendMsg(Model model, @RequestParam(value = "taskid", required = false) String taskid
            , @RequestParam(value = "roleIds", required = false) String roleIds
            , @RequestParam(value = "userIds", required = false) String userIds, HttpServletRequest request) {
        String msg = "";
        String url = AppConfig.getProperty("send.msg.url");
        try {
            if (StringUtils.isNotBlank(url)) {
                String userIdStrs = "";
                if (StringUtils.isNotBlank(roleIds)) {
                    String[] roleIdStrs = roleIds.split(",");
                    for (String roleId : roleIdStrs) {
                        List<PfUserVo> pfUserVoList = sysUserService.getUserListByRole(roleId);
                        if (CollectionUtils.isNotEmpty(pfUserVoList)) {
                            for (PfUserVo pfUserVo : pfUserVoList) {
                                if (StringUtils.isBlank(userIdStrs))
                                    userIdStrs = pfUserVo.getUserId();
                                else
                                    userIdStrs = userIdStrs + "," + pfUserVo.getUserId();
                            }
                        }
                    }
                }
                if (StringUtils.isNotBlank(userIds)) {
                    String[] userids = roleIds.split(",");
                    for (String userid : userids) {
                        if (StringUtils.isBlank(userIdStrs))
                            userIdStrs = userid;
                        else
                            userIdStrs = userIdStrs + "," + userid;
                    }

                }
                PfTaskVo pfTaskVo = sysTaskService.getHistoryTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId())) {
                        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                        if (pfWorkFlowInstanceVo != null && StringUtils.isNotBlank(pfWorkFlowInstanceVo.getProId())) {
                            HttpHeaders headers = new HttpHeaders();
                            MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
                            headers.setContentType(type);
                            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
                            HttpEntity<String> formEntity = new HttpEntity<String>("", headers);
                            restTemplate.postForObject(url + "?proid={proid}&userIds={userIds}&taskid={taskid}", formEntity, String.class, pfWorkFlowInstanceVo.getProId(), userIdStrs, taskid);
                        }
                    }

                }

            }
        } catch (Exception e) {
        }
        return msg;
    }

    /**
     * @param taskid :
     * @param userid :
     * @param wiid   :
     * @return : int
     * @author : <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @date : 2019/5/21 16:16
     * @Description : 判断当前活动下一步有几个活动节点
     */
    @RequestMapping("/nextActivityCounts")
    @ResponseBody
    public int nextActivityCounts(String taskid, String userid, String wiid) throws Exception {
        if (StringUtils.isBlank(userid)) {
            userid = SessionUtil.getCurrentUserId();
        }
        WorkFlowInfo info = workFlowService.getWorkFlowTurnInfo(userid, taskid);
        String taskTurnInfo = sysTaskTurnService.getTurnInfoFromGlobalVal(taskid, wiid);
        String turnXml;
        if (StringUtils.isNotBlank(taskTurnInfo))
            turnXml = taskTurnInfo;
        else
            turnXml = turnInfo(info);
        if (StringUtils.isNotBlank(turnXml)) {
            int count = 0;
            Document document = DocumentHelper.parseText(turnXml);
            Element root = document.getRootElement();
            for (Iterator iter = root.elementIterator(); iter.hasNext(); ) {
                Element vals = (Element) iter.next();
                if ("Activity".equals(vals.getName())) {
                    count++;
                }
            }
            return count;
        } else {
            return 1;
        }
    }
}
