package com.gtis.portal.web;

import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.portal.entity.BDCGG;
import com.gtis.portal.entity.BdcXmSd;
import com.gtis.portal.service.TaskActionService;
import com.gtis.portal.util.Constants;
import com.gtis.portal.util.HttpClientUtil;
import com.gtis.portal.util.WorkFlowXml;
import com.gtis.portal.util.WorkFlowXmlUtil;
import com.gtis.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 任务所有动作管理
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/taskAction")
public class TaskActionController extends BaseController {
    @Autowired
    TaskActionService taskActionService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    SysTaskService sysTaskService;
    @Autowired
    SysActivityService sysActivityService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysUserService sysUserService;

    @RequestMapping("delTask")
    @ResponseBody
    public Object delTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid,
                          @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "reason", required = false) String reason, @RequestParam(value = "userid", required = false) String userid) throws Exception {
        if (StringUtils.isNotBlank(reason)) {
            reason = URLDecoder.decode(reason, "UTF-8");
        }
        //调用 paltfrom 执行平台工作流事件
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
        if (StringUtils.isNotBlank(wiid))
            pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
        else if (StringUtils.isNotBlank(taskid)) {
            PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
            if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                    pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
            }
        }
        String msg = "";
        PfTaskVo taskVo = sysTaskService.getTask(taskid);
        try {
            switch (taskActionService.permitDel(taskVo, userid)) {
                //管理员权限
                case 0: {
                    msg = taskActionService.delTask(pfWorkFlowInstanceVo.getWorkflowIntanceId(), taskid, userid, reason, pfWorkFlowInstanceVo.getProId(), pfWorkFlowInstanceVo, request);
                    break;
                }
                case 3: {
                    msg = "3";
                    throw new RuntimeException(msg);
                }
                default: {
                    msg = "2";
                    throw new RuntimeException(msg);
                }
            }
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }
        return handlerSuccessJson(msg);
    }

    //取回
    @RequestMapping("retrieveTask")
    @ResponseBody
    public Object retrieveTask(HttpServletRequest request, @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "userid", required = false) String userid) {
        try {
            String wiid = "";
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getHistoryTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            taskActionService.retrieveTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request);

        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }


    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 转发
     */
    @RequestMapping("turnTask")
    @ResponseBody
    public Object turnTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid,
                           @RequestParam(value = "turnXml", required = false) String turnXml, @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
//            String userid=SessionUtil.getCurrentUserId();
            String xml = turnXml;
            if (StringUtils.isBlank(turnXml))
                xml = inputStream2String(request.getInputStream());
            if (StringUtils.isNotBlank(taskid)) {
                //转发检查是否办结，代办任务使用
                WorkFlowInfo info = workFlowCoreService.getWorkFlowTurnInfo(userid, taskid);
                WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
                String activityDefineId = info.getSourceActivity().getActivityDefinitionId();
                // 判断是否任务办结，两种情况（1为最后一个活动，2为中间活动的）
                if (info.getTransInfo().getTranActivitys() != null && info.getTransInfo().getTranActivitys().size() == 0) {
                    ActivityModel aModel = workXml.getActivity(activityDefineId);
                    ///////排除WaitAllUsers情况，如果其他人还在办理///////////
                    PfActivityVo sourceActivityVo = info.getSourceActivity();
                    //办结
                    //////////////////////////////////////////////////////////
                    String endActivityDefine = workXml.getEndActivityDefine();
                    if (StringUtils.isBlank(endActivityDefine)) {
                        ///没有结束节点
                        endActivityDefine = "";
                    }
                    if (endActivityDefine.equals(activityDefineId) || aModel.isCanFinish()) {
                        taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, xml, null);
                    } else if (workXml.getActivitiesCount() == 1) {
                        ////只有一个节点，over
                        taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, xml, null);
                    } else {
                        taskActionService.turnTaskByXml(wiid, taskid, userid, pfWorkFlowInstanceVo, request, xml);
                    }
                } else {
                    if (StringUtils.indexOf(xml, "<Activity Id=\"-1\">") > -1)
                        //办结
                        taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, xml, null);
                    else
                        //转发
                        taskActionService.turnTaskByXml(wiid, taskid, userid, pfWorkFlowInstanceVo, request, xml);
                }
            }

        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 退回流程 turnBackTask
     */
    @RequestMapping("turnBackTask")
    @ResponseBody
    public Object turnBackTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid
            , @RequestParam(value = "adids", required = false) String adids, @RequestParam(value = "remark", required = false) String remark, @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            taskActionService.turnBackTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, adids, remark);
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }
        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 办结流程 endTask
     */
    @RequestMapping("endTask")
    @ResponseBody
    public Object endTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "", null);
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();

    }

    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 挂起流程 stopTask
     */
    @RequestMapping("stopTask")
    @ResponseBody
    public Object stopTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getHistoryTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            taskActionService.stopTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 创建流程 beginTask
     */
    @RequestMapping("beginTask")
    @ResponseBody
    public Object beginTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getHistoryTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            taskActionService.createTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 批量转发
     */
    @RequestMapping("batchTurnTask")
    @ResponseBody
    public Object batchTurnTask(HttpServletRequest request, @RequestParam(value = "taskids", required = false) String taskids, @RequestParam(value = "userid", required = false) String userid) {
        try {
            String xml = inputStream2String(request.getInputStream());
            if (StringUtils.isNotBlank(taskids)) {
                String[] taskIds = taskids.split(",");
                for (String value : taskIds) {
                    turnTask(request, "", value, xml, userid);
                }
            }
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 代办任务以WorkFlowInfo转发
     */
    @RequestMapping("turnTaskByWorkFlowInfo")
    @ResponseBody
    public Object turnTaskByWorkFlowInfo(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            //转发检查是否办结，代办任务使用
//            String userid=SessionUtil.getCurrentUserId();
            WorkFlowInfo info = workFlowCoreService.getWorkFlowTurnInfo(userid, taskid);
            // 处理活动
            List<ActivityModel> lstActivityModel = info.getTransInfo().getTranActivitys();

            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
            String activityDefineId = info.getSourceActivity().getActivityDefinitionId();
            // 判断是否任务办结，两种情况（1为最后一个活动，2为中间活动的）
            if (info.getTransInfo().getTranActivitys() != null && info.getTransInfo().getTranActivitys().size() == 0) {
                ActivityModel aModel = workXml.getActivity(activityDefineId);

                //办结
                //////////////////////////////////////////////////////////
                String endActivityDefine = workXml.getEndActivityDefine();
                if (StringUtils.isBlank(endActivityDefine)) {
                    ///没有结束节点
                    endActivityDefine = "";
                }
                if (endActivityDefine.equals(activityDefineId) || aModel.isCanFinish()) {
                    taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "", info);
                } else if (workXml.getActivitiesCount() == 1) {
                    ////只有一个节点，over
                    taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "", info);
                }
            } else {
                //转发
                taskActionService.turnTaskByWorkFlowInfo(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "");
            }

        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 挂起
     */
    @RequestMapping("postTask")
    @ResponseBody
    public Object postTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid
            , @RequestParam(value = "remark", required = false) String remark, @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            } else if (StringUtils.isNotBlank(wiid)) {
                pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
                //根据wiid求taskid
                List<PfActivityVo> activityList = sysTaskService.getWorkFlowInstanceAllActivityList(wiid);
                if (CollectionUtils.isNotEmpty(activityList)) {
                    for (int i = 0; i < activityList.size(); i++) {
                        if (StringUtils.isBlank(taskid)) {
                            String activityId = activityList.get(i).getActivityId();
                            if (StringUtils.isNotBlank(activityId)) {
                                List<PfTaskVo> taskList = sysTaskService.getTaskListByActivity(activityId);
                                if (CollectionUtils.isNotEmpty(taskList)) {
                                    taskid = taskList.get(0).getTaskId();
                                }
                            }
                        }
                    }

                }

            }
            //System.out.println("wiid" + wiid + "---taskid" + taskid);
            taskActionService.postTask(wiid, taskid, userid, remark, pfWorkFlowInstanceVo, request);
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 解挂
     */
    @RequestMapping("unPostTask")
    @ResponseBody
    public Object unPostTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid
            , @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            } else if (StringUtils.isNotBlank(wiid)) {
                pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
                //根据wiid求taskid
                List<PfActivityVo> activityList = sysTaskService.getWorkFlowInstanceAllActivityList(wiid);
                if (CollectionUtils.isNotEmpty(activityList)) {
                    for (int i = 0; i < activityList.size(); i++) {
                        if (StringUtils.isBlank(taskid)) {
                            String activityId = activityList.get(i).getActivityId();
                            if (StringUtils.isNotBlank(activityId)) {
                                List<PfTaskVo> taskList = sysTaskService.getTaskListByActivity(activityId);
                                if (CollectionUtils.isNotEmpty(taskList)) {
                                    taskid = taskList.get(0).getTaskId();
                                }
                            }
                        }
                    }

                }
            }
            //System.out.println("wiid" + wiid + "---taskid" + taskid);
            taskActionService.upPostTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 调整优先级
     */
    @RequestMapping("priorityTask")
    @ResponseBody
    public Object priorityTask(HttpServletRequest request, @RequestParam(value = "wiids", required = false) String wiids, @RequestParam(value = "priority", required = false) String priority
            , @RequestParam(value = "userid", required = false) String userid) {
        try {

            if (StringUtils.isNotBlank(wiids)) {
                for (String wiid : wiids.split(",")) {
                    PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(wiid);
                    taskActionService.priorityTask(wiid, "", userid, priority, pfWorkFlowInstanceVo, request);
                }
            }
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 自动派件
     */
    @RequestMapping("autoTurnTask")
    @ResponseBody
    public Object autoTurnTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }


            //转发检查是否办结，代办任务使用
            WorkFlowInfo info = workFlowCoreService.getWorkFlowTurnInfo(userid, taskid);
            // 处理活动
            List<ActivityModel> lstActivityModel = info.getTransInfo().getTranActivitys();

            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
            String activityDefineId = info.getSourceActivity().getActivityDefinitionId();
            // 判断是否任务办结，两种情况（1为最后一个活动，2为中间活动的）
            if (info.getTransInfo().getTranActivitys() != null && info.getTransInfo().getTranActivitys().size() == 0) {
                ActivityModel aModel = workXml.getActivity(activityDefineId);

                //办结
                //////////////////////////////////////////////////////////
                String endActivityDefine = workXml.getEndActivityDefine();
                if (StringUtils.isBlank(endActivityDefine)) {
                    ///没有结束节点
                    endActivityDefine = "";
                }
                if (endActivityDefine.equals(activityDefineId) || aModel.isCanFinish()) {
                    taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "", info);
                } else if (workXml.getActivitiesCount() == 1) {
                    ////只有一个节点，over
                    taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "", info);
                }else {
                    taskActionService.autoTurnTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "");

                }
            } else {
                //转发
                taskActionService.autoTurnTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request, "");
            }

        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    private String inputStream2String(InputStream is) throws IOException {
        String result = "";
        try {
            result = IOUtils.toString(is, "UTF-8");
            result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + result;
        } catch (Exception e) {
        } finally {
            is.close();
        }
        return result;
    }

    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 占用任务
     */
    @RequestMapping("usedTask")
    @ResponseBody
    public Object usedTask(HttpServletRequest request, @RequestParam(value = "taskIds", required = false) String taskIds
            , @RequestParam(value = "userid", required = false) String userid) {
        try {
//            String userid=SessionUtil.getCurrentUserId();
            if (StringUtils.isNotBlank(taskIds)) {
                String[] taskIdArray = taskIds.split(",");
                for (String taskid : taskIdArray) {
                    if (StringUtils.isNotBlank(taskid))
                        taskActionService.usedTask(taskid, userid);
                }

            }
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 取消占用任务
     */
    @RequestMapping("noUsedTask")
    @ResponseBody
    public Object noUsedTask(HttpServletRequest request, @RequestParam(value = "taskIds", required = false) String taskIds
            , @RequestParam(value = "userid", required = false) String userid) {
        try {
//            String userid=SessionUtil.getCurrentUserId();
            if (StringUtils.isNotBlank(taskIds)) {
                String[] taskIdArray = taskIds.split(",");
                for (String taskid : taskIdArray) {
                    if (StringUtils.isNotBlank(taskid))
                        taskActionService.noUsedTask(taskid, userid);
                }
            }
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }


    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 提供其他系统调用的办结接口 endTask
     */
    @RequestMapping("endTaskRestFul")
    @ResponseBody
    public Object endTaskRestFul(@RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid, @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            String turnXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Activitys><ReMark><text/></ReMark></Activitys>";
            taskActionService.endTask(wiid, taskid, userid, pfWorkFlowInstanceVo, null, turnXml, null);
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();

    }

    /**
     * @author <a href="mailto:dingweiwei@gtmap.cn">dingweiwei</a>
     * @description 一键完税
     */
    @RequestMapping("dutyPaidTask")
    @ResponseBody
    public Object dutyPaidTask(@RequestParam(value = "taskid", required = false) String taskid) {
        PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
        String slbh = null;
        Map<String, Object> map = new HashMap<String, Object>();
        String url = AppConfig.getProperty("server.url") + "/" + AppConfig.getProperty("bdcdj.version") + "/ysl/checkWsInfo";
        try {
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId())) {
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    }
                    if (pfWorkFlowInstanceVo != null) {
                        String remark = pfWorkFlowInstanceVo.getRemark();
                        if (StringUtils.isNotBlank(remark)) {
                            slbh = remark.split("\\$")[0];
                        }
                    }
                }
                map.put("slbh", slbh);
                map.put("taskid", taskid);
                String result = HttpClientUtil.doGet(url, map);
                if (StringUtils.isNotBlank(result)) {
                    JSONObject jsonObject = JSONObject.parseObject(result);
                    String msg = (String) jsonObject.get("msg");
                    return handlerSuccessJson(msg);
                }
            }
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }


    /**
     * @return java.lang.Object
     * @Param [request, wiid, taskid, begindate, enddate, userid]
     * @Author <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @Date 9:09 2019/5/21
     * @Description 公告
     */
    @RequestMapping("publicTask")
    @ResponseBody
    public Object publicTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid
            , @RequestParam(value = "begindate", required = false) String begindate, @RequestParam(value = "enddate", required = false) String enddate, @RequestParam(value = "userid", required = false) String userid) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            //流程公告操作逻辑,把公告结束时间存到数据库bdc_gg,同时把该件公告
            Date kssj = sdf.parse(begindate);
            Date jssj = sdf.parse(enddate);
            BDCGG bdcgg = new BDCGG();
            bdcgg.setGgid(UUIDGenerator.generate());
            bdcgg.setWiid(wiid);
            bdcgg.setProid(wiid);
            bdcgg.setKssj(kssj);
            bdcgg.setJssj(jssj);
            bdcgg.setSffb("1");
            taskActionService.saveBdcgg(bdcgg);
            //挂起操作
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            taskActionService.postTask(wiid, taskid, userid, "", pfWorkFlowInstanceVo, request);
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }
        return handlerSuccessJson();
    }

    /**
     * @return java.lang.Object
     * @Param [request, wiid, taskid, begindate, enddate, userid]
     * @Author <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @Date 9:09 2019/5/21
     * @Description 公告数量
     */
    @RequestMapping("getPublicList")
    @ResponseBody
    public List<BDCGG> getPublicList(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid) {
        List<BDCGG> listgg = new ArrayList<BDCGG>();
        try {
            listgg = taskActionService.getbdcggListByCondition(wiid, "1");
        } catch (Exception e) {
        }
        return listgg;
    }

    /**
     * @author <a href="mailto:shenfei@gtmap.cn">sf</a>
     * @description 解除公告
     */
    @RequestMapping("unPublicTask")
    @ResponseBody
    public Object unPublicTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid
            , @RequestParam(value = "userid", required = false) String userid) {
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            taskActionService.upPostTask(wiid, taskid, userid, pfWorkFlowInstanceVo, request);
            //将bdc_gg数据逻辑删除
            List<BDCGG> listgg = taskActionService.getbdcggListByCondition(wiid, "1");
            if (listgg.size() > 0) {
                BDCGG bdcgg = new BDCGG();
                bdcgg.setWiid(listgg.get(0).getWiid());
                bdcgg.setProid(listgg.get(0).getProid());
                bdcgg.setGgid(listgg.get(0).getGgid());
                bdcgg.setSffb("0");
                bdcgg.setKssj(listgg.get(0).getKssj());
                bdcgg.setJssj(listgg.get(0).getJssj());
                taskActionService.update(bdcgg);
            }
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * 获取项目锁定列表
     * @param request HttpServletRequest
     * @param wiid 工作流实例id
     * @return List<BdcXmSd>
     */
    @RequestMapping("/getXmLockList")
    @ResponseBody
    public List<BdcXmSd> getxmLockList(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid) {
        List<BdcXmSd> listsd = new ArrayList<BdcXmSd>();
        List<BdcXmSd> list;
        String xmtddm="4";// "4"是锁定特点码
        try {
            list = taskActionService.getBdcxmsdListByCondition(wiid);
            if (xmtddm.equals(list.get(0).getXmtddm())){
                    listsd=list;
            }


        } catch (Exception e) {
        }
        return listsd;
    }


    /**
     * @return java.lang.Object
     * @Param [request, wiid, taskid, begindate, enddate, userid]
     * @Author <a href="mailto:liangxichang@gtmap.cn">sf</a>
     * @Date 9:09 2019/7/21
     * @Description 锁定
     */
    @RequestMapping("/xmLockTask")
    @ResponseBody
    public Object xmLockTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid
            , @RequestParam(value = "remark", required = false) String remark, @RequestParam(value = "userid", required = false) String userid) {
        String xmtddm="4";//锁定代码
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }
            if(StringUtils.isNotBlank(userid)){
                String userName = sysUserService.getUserVo(userid).getUserName();
                String curTime = SessionUtil.getCurTime().substring(0,11);
                remark = remark + Constants.SPLIT_STR + userName + Constants.SPLIT_STR + curTime;
            }


            List<BdcXmSd> bdcxmsdList = taskActionService.getBdcxmsdListByCondition(wiid);
            BdcXmSd bdcXmSd=new BdcXmSd();
            if(bdcxmsdList.size() > 0){
                bdcXmSd.setXmtdid(bdcxmsdList.get(0).getXmtddm());
                bdcXmSd.setXmid(bdcxmsdList.get(0).getXmid());
                bdcXmSd.setXmtdly(remark);
                bdcXmSd.setXmtddm(xmtddm);
                taskActionService.update(bdcXmSd);
            } else {
                bdcXmSd.setXmtddm(xmtddm);
                bdcXmSd.setXmtdly(remark);
                bdcXmSd.setXmid(wiid);
                taskActionService.saveXmSdTask(bdcXmSd);
            }



        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }

    /**
     * @author <a href="mailto:liangxichang@gtmap.cn">sf</a>
     * @description 解除锁定
     */
    @RequestMapping("/unXmLockTask")
    @ResponseBody
    public Object unXmLockTask(HttpServletRequest request, @RequestParam(value = "wiid", required = false) String wiid, @RequestParam(value = "taskid", required = false) String taskid
            , @RequestParam(value = "userid", required = false) String userid) {
        String xmtddm="4";//锁定代码
        try {
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = null;
            if (StringUtils.isNotBlank(taskid)) {
                PfTaskVo pfTaskVo = sysTaskService.getTask(taskid);
                if (pfTaskVo != null && StringUtils.isNotBlank(pfTaskVo.getActivityId())) {
                    PfActivityVo pfActivityVo = sysActivityService.getActivityById(pfTaskVo.getActivityId());
                    if (pfActivityVo != null && StringUtils.isNotBlank(pfActivityVo.getWorkflowInstanceId()))
                        pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstance(pfActivityVo.getWorkflowInstanceId());
                    if (pfWorkFlowInstanceVo != null)
                        wiid = pfWorkFlowInstanceVo.getWorkflowIntanceId();
                }
            }


            List<BdcXmSd> list = taskActionService.getBdcxmsdListByCondition(wiid);
            List<BdcXmSd> listsd=new ArrayList<BdcXmSd>();
            if(xmtddm.equals(list.get(0).getXmtddm())){
                listsd=list;
            }
            if (listsd.size() > 0) {
                for (BdcXmSd bdcXmSd : listsd) {
                    taskActionService.remove(bdcXmSd.getXmtdid());
                }

            }
        } catch (Exception e) {
            try {
                return handlerJSONException(e);
            } catch (Exception e1) {
            }
        }

        return handlerSuccessJson();
    }


}
