package com.gtis.portal.util;

import cn.gtmap.estateplat.utils.CalendarUtil;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.FileService;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.spring.Container;
import org.apache.commons.lang.StringUtils;

import java.io.*;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: deery
 * Date: 13-9-26
 * Time: 上午11:04
 * To change this template use File | Settings | File Templates.
 */
public class FileUtil {

    /**
     * 删除目录（文件夹）以及目录下的文件
     *
     * @param sPath 被删除目录的文件路径
     * @return 目录删除成功返回true，否则返回false
     */
    public static boolean deleteDirectory(String sPath) throws Exception{
        //如果sPath不以文件分隔符结尾，自动添加文件分隔符
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        File dirFile = new File(sPath);
        //如果dir对应的文件不存在，或者不是一个目录，则退出
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = false;
        //删除文件夹下的所有文件(包括子目录)
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; i++) {
            //删除子文件
            if (files[i].isFile()) {
                flag = deleteFile(files[i].getAbsolutePath());
                if (!flag) break;
            } //删除子目录
            else {
                flag = deleteDirectory(files[i].getAbsolutePath());
                if (!flag) break;
            }
        }
        if (!flag) return false;
        //删除当前目录
        flag = false;
        if (dirFile.delete()) {
            flag = true;
        }

        return flag;
    }

    /**
     * 删除单个文件
     *
     * @param sPath 被删除文件的文件名
     * @return 单个文件删除成功返回true，否则返回false
     */
    public static boolean deleteFile(String sPath) throws Exception{
        boolean flag = false;
        File file = new File(sPath);
        // 路径为文件且不为空则进行删除
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }
    /**
	 * 复制单个文件
	 * 
	 * @param oldPath
	 *            String 原文件路径 如：c:/fqf.txt
	 * @param newPath
	 *            String 复制后路径 如：f:/fqf.txt
	 * @return boolean
	 */
	public static boolean copyFile(String oldPath, String newPath) throws IOException {
		boolean isok = false;
		InputStream inStream = null;
		FileOutputStream fs = null;
		try {
			File file = new File(newPath);
			if (!file.exists()) {// 如果目标路径不存在
				createFiles(newPath);
			}
			int byteread = 0;
			File oldfile = new File(oldPath);
			if (oldfile.exists()) { // 文件存在时
				inStream = new FileInputStream(oldfile); // 读入原文件
				 fs = new FileOutputStream(file);
				byte[] buffer = new byte[1444];
				while ((byteread = inStream.read(buffer)) != -1) {
					fs.write(buffer, 0, byteread);
				}
				inStream.close();
				isok = true;
			}
		} catch (Exception e) {
			System.out.println("复制单个文件操作出错");
			e.printStackTrace();
		}finally {
			if(inStream!=null)
				inStream.close();

			if(fs!=null)
				fs.close();

		}
		return isok;
	}

	/**
	 * 非根路径中创建文件，即多层文件夹是 前提是: path必须一个正确的路径 拷贝单个文件
	 * 
	 * @param path 文件
	 */
	public static Boolean createFiles(String path) {
		Boolean flag = false;
		File file = null;
		if (!path.equals("") || path != null) {
			file = new File(path);
			if (!file.exists()) {
				if (file.isDirectory()) {
					file.mkdirs();
				}else {
					// 创建目录
					File fileDir = new File(file.getParent());
					fileDir.mkdirs();
					System.out.println("上层文件夹： " + fileDir);
					try {
						flag = file.createNewFile();// 在已有文件路径上直接创建文件
						System.out.println("文件名称：" + file);
					} catch (IOException e) {
						System.out.println("创建文件失败：" + e.getLocalizedMessage());
						e.printStackTrace();
					}
				}
			} else {
				System.out.println("【" + path + "】：" + "该文件已经存在");
			}
		}
		return flag;
	}
	/**
	 * 根据路径删除指定的目录或文件，无论存在与否
	 * 
	 * @param sPath
	 *            要删除的目录或文件
	 * @return 删除成功返回 true，否则返回 false。
	 */
	public static boolean DeleteFolder(String sPath)throws Exception{
		boolean flag = false;
		File file = new File(sPath);
		// 判断目录或文件是否存在
		if (!file.exists()) { // 不存在返回 false
			return flag;
		} else {
			// 判断是否为文件
			if (file.isFile()) { // 为文件时调用删除文件方法
				return deleteFile(sPath);
			} else { // 为目录时调用删除目录方法
				return deleteDirectory(sPath);
			}
		}
	}
	/**
	 * 非根路径中创建文件夹是
	 * @param dirPath 文件夹路径
	 * @param isreplace 是否覆盖
	 * @return
	 */
	public static Boolean createDirectory(String dirPath,boolean isreplace)throws Exception {
		Boolean flag = false;
		if (StringUtils.isNotBlank(dirPath)) {
			File file = new File(dirPath);
			if (file.exists()) {
				if (isreplace) {
					FileUtil.DeleteFolder(dirPath);
					file.mkdirs();
				}
			} else {
				file.mkdirs();
			}
		}
		return flag;
	}
	/**
	 * 遍历文件夹，找出对应名字的文件全路径地址
	 * @param fileName
	 * @return
	 */
	public static String findFileByName(String dirName,String fileName){
		//传入的文件夹是否存在
		File file = new File(dirName);
		return findFileByName(file,fileName);
	}
	/**
	 * 遍历文件夹，找出对应名字的文件全路径地址
	 * @param fileName
	 * @return
	 */
	public static String findFileByName(File dir,String fileName){
		String filePath = "";
		//传入的文件夹是否存在
		if (dir != null && dir.exists() && dir.isDirectory()) {
			//通过File类的listFiles方法获取文件夹中所有文件的全路径
			File[] files = dir.listFiles();
			if (files != null && files.length > 0) {
				for (int i = 0; i < files.length; i++) {
					if (files[i].isDirectory()) {
						filePath = findFileByName(files[i],fileName);
					}else {
						if (files[i].getName().equalsIgnoreCase(fileName)) {
							//输出全路径
							filePath = files[i].getAbsolutePath();
						}
					}
					if (StringUtils.isNotBlank(filePath)) {
						break;
					}
				}
			}
		}
		return filePath;
	}
	public static void createFileCenterNodeByFolder(String proID,String dirName,String spacecode){
		if (StringUtils.isNotBlank(dirName)) {
			File dirFile = new File(dirName);
			if (dirFile != null && dirFile.exists()) {
				if (dirFile.isDirectory()) {
					NodeService nodeService = (NodeService)Container.getBean("NodeService");
					FileService fileService = (FileService)Container.getBean("FileService");
					//首先创建该proid下的一个文件夹节点
					Space space = nodeService.getWorkSpace(spacecode, true);
					Node node = nodeService.getNode(space.getId(), proID, true);
					Integer nodeId=node.getId();
					String token=nodeService.getToken(node);
					//如果已经存在该电子包数据，则删除
					Node nodeChild = nodeService.getNode(nodeId, dirFile.getName(), false);
					if (nodeChild != null) {
						nodeService.remove(nodeChild.getId());
					}
//					Node dirNode = getOrCreateNode(nodeId,dirFile.getName(),nodeService);
					//开始遍历文件夹结构，逐层创建文件中心节点
					createFileCenterNodeByFile(dirFile,node,nodeService,fileService);
				}
			}
		}
	}
	/**
	 * 遍历文件夹，找出对应名字的文件全路径地址
	 * @param file
	 * @return
	 */
	public static void createFileCenterNodeByFile(File file,Node node,NodeService nodeService,FileService fileService){
		//传入的文件夹是否存在
		if (file != null && file.exists()) {
			try {
				//创建文件夹/文件节点
				Node fileNode = getOrCreateNode(node.getId(),file.getName(),nodeService);
				System.out.println(fileNode.getName());
				if (file.isDirectory()) {
					//通过File类的listFiles方法获取文件夹中所有文件的全路径
					File[] files = file.listFiles();
					if (files != null && files.length > 0) {
						for (int i = 0; i < files.length; i++) {
							if (files[i].isDirectory()) {
								createFileCenterNodeByFile(files[i],fileNode,nodeService,fileService);
							}else if (files[i].isFile()) {
								//上传附件
								fileService.uploadFile(files[i], fileNode.getId(),null,null,true,false);
							}
						}
					}
				}else if (file.isFile()) {
					//上传附件
					fileService.uploadFile(file, fileNode.getId(),null,null,true,false);
				}
			} catch (Exception e) {
				System.out.println(e.getMessage());
			}
		}
	}
	/**
	 * 根据父节点nodeid生成名称为fName的子文件节点
	 * @param nid
	 * @param fName
	 * @return
	 */
	public static Node getOrCreateNode(Integer nid,String fName,NodeService nodeService){
		Node nodeChild = null;
		try {
			nodeChild = nodeService.getNode(nid, fName, true);//getChildNode(nid, fName);
		} catch (Exception e) {
			nodeChild = nodeService.createNode(nid,fName);
			nodeChild.setViewName(fName);
			nodeChild.setName(fName);
			nodeChild.setDescription(fName);
			nodeService.save(nodeChild);
		}
		if (nodeChild == null) {
			nodeChild = nodeService.getNode(nid,fName, true);
			nodeChild.setViewName(fName);
			nodeChild.setName(fName);
			nodeChild.setDescription(fName);
			nodeService.save(nodeChild);
		}
		return nodeChild;
	}
	
	/**
	 * 获取路径中某种格式的文件列表
	 * 或者获取制定名字的文件
	 * @param dirPath
	 * @param type
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public static List<String> getFileName(String dirPath,String type,String name)throws Exception{
		List<String> strList = new ArrayList<String>();
		File dirFile = new File(dirPath);
		// 如果dir对应的文件不存在，或者不是一个目录，则退出
		if (!dirFile.exists() || !dirFile.isDirectory()) {
			return null;
		}
		type = type.toLowerCase();
		File[] files = dirFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				//System.out.println("--------------" + files[i].getName() + "--------------");
				String filename = files[i].getAbsolutePath();
				int point = filename.lastIndexOf(".") + 1;
				String filetype = filename.substring(point,filename.length());
				filetype = filetype.toLowerCase();
				//System.out.println("--------------" + filetype + "--------------");
				if (filetype != null && StringUtils.indexOf(type, filetype) > -1) {
					//System.out.println("--------------" + shpFileName + "--------------");
					if (StringUtils.isNotBlank(name)) {
						if (filename.indexOf(name) > -1) {
							strList = new ArrayList<String>();
							strList.add(filename);
							break;
						}
					}
					strList.add(filename);
				}
			}else if (files[i].isDirectory()) {
				continue;
			}
		}
		return strList;
	}
	/**
	 * 获取路径中某种格式的文件列表
	 * 或者获取制定名字的文件
	 * @param dirPath
	 * @param type
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public static List<HashMap<String, String>> getFileMapList(String dirPath,String type,String name)throws Exception{
		List<HashMap<String, String>> strList = new ArrayList<HashMap<String, String>>();
		File dirFile = new File(dirPath);
		// 如果dir对应的文件不存在，或者不是一个目录，则退出
		if (!dirFile.exists() || !dirFile.isDirectory()) {
			return null;
		}
		type = type.toLowerCase();
		File[] files = dirFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				HashMap<String, String> fileMap = new HashMap<String, String>();
				//System.out.println("--------------" + files[i].getName() + "--------------");
				String filename = files[i].getName();//.getAbsolutePath();
				String filepath = files[i].getAbsolutePath();//.getAbsolutePath();
				int point = filename.lastIndexOf(".") + 1;
				String filetype = filename.substring(point,filename.length());
				filename = filename.substring(0,point-1);
				filetype = filetype.toLowerCase();
				//System.out.println("--------------" + filetype + "--------------");
				if (filetype != null && StringUtils.indexOf(type, filetype) > -1) {
					//System.out.println("--------------" + shpFileName + "--------------");
					fileMap.put("filename", filename);
					fileMap.put("filetype", filetype);
					fileMap.put("filepath", filepath);
					if (StringUtils.isNotBlank(name)) {
						if (filename.indexOf(name) > -1) {
							strList = new ArrayList<HashMap<String, String>>();
							strList.add(fileMap);
							break;
						}
					}
					strList.add(fileMap);
				}
			}else if (files[i].isDirectory()) {
				continue;
			}
		}
		return strList;
	}
	/**
	 * 创建文件中心节点
	 * @return 返回nodeId和token
	 * @throws Exception
	 */
	public static Integer createFileCenterFolder(String proID,String foldName) throws Exception{
		Space space = null;
		Integer nodeId = null;
		try {
			NodeService nodeService = (NodeService)Container.getBean("NodeService");
			space = nodeService.getWorkSpace(Constants.WORK_FLOW_STUFF, true);
			Node prjNode = nodeService.getNode(space.getId(), proID, true);
			Integer proNodeid=prjNode.getId();
//			token=nodeService.getToken(prjNode);
			Node cityNode = FileUtil.getOrCreateNode(proNodeid,foldName,nodeService);
			nodeId = cityNode.getId();
		} catch (Exception e) {
			System.out.println("文件中心异常："+e.getMessage());
		}
		return nodeId;
	}
	
	/**
	 * 获取增量包XML文件
	 * @return
	 */
	public static String getXmlFileName(String dir,String fileName){
		String filename = "";
		File dirFile = new File(dir);
		// 如果dir对应的文件不存在，或者不是一个目录，则退出
		if (!dirFile.exists() || !dirFile.isDirectory()) {
			return null;
		}
		boolean flag = false;
		File[] files = dirFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				//System.out.println("--------------" + files[i].getName() + "--------------");
				filename = files[i].getName();
				if (StringUtils.equals(fileName, filename)) {
					flag = true;
					break;
				}
			}
		}
		if (!flag) {
			filename = "";
		}
		return filename;
	}
	/**
	 * 获取增量包XML文件
	 * @return
	 */
	public static String getXmlFileName(String dir){
		String filename = "";
		File dirFile = new File(dir);
		// 如果dir对应的文件不存在，或者不是一个目录，则退出
		if (!dirFile.exists() || !dirFile.isDirectory()) {
			return null;
		}
		boolean flag = false;
		File[] files = dirFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				//System.out.println("--------------" + files[i].getName() + "--------------");
				filename = files[i].getAbsolutePath();
				int point = filename.lastIndexOf(".") + 1;
				String filetype = filename.substring(point,filename.length());
				//System.out.println("--------------" + filetype + "--------------");
				if (filetype != null && filetype.equalsIgnoreCase("xml") ) {
					//System.out.println("--------------" + shpFileName + "--------------");
					flag = true;
					break;
				}
			}
		}
		if (!flag) {
			filename = "";
		}
		return filename;
	}
	
	public static String getEgovHomePath(String path){
		String dirPath = "";
		try {
			dirPath = AppConfig.getConfHome()+"/"+path+"/";
			if (dirPath.startsWith("zip")) { // 当class文件在war中时，返回"zip:D:/ ..."样的路径
				dirPath =dirPath.substring(4);
			} else if (dirPath.startsWith("file")) { // 当class文件在class文件中时，返回"file:/F:/ ..."样的路径 
				dirPath = dirPath.substring(6);
			}else if(dirPath.startsWith("jar")){ // 当class文件在jar文件中时，返回"jar:file:/F:/ ..."样的路径
				dirPath = dirPath.substring(10);
			}
		} catch (Exception e) {
			// TODO: handle exception
		}
		return dirPath;
	}

	public static String getTempPath(String type) {
		String path = System.getProperty("user.dir").replace("\\bin", "\\webapps") + "\\approval\\";
		path = path.replace("\\webapps\\approval\\", "\\temp\\");
		//系统临时路径
		path = path + type + "\\";
		GregorianCalendar today = new GregorianCalendar();
		path = path + CalendarUtil.sdf_time.format(today.getTime()) + "\\";
		return path;
	}
	/**
	 * file 转换成byte数组
	 * @param f
	 * @return
	 */
	public static byte[] getBytesFromFile(File f) throws IOException {
		if (f == null) {
			return null;
		}
		FileInputStream stream =null;
		ByteArrayOutputStream out =null;
		try {
			 stream = new FileInputStream(f);
			 out = new ByteArrayOutputStream(1000);
			byte[] b = new byte[1000];
			int n;
			while ((n = stream.read(b)) != -1)
				out.write(b, 0, n);
			stream.close();
			out.close();
			return out.toByteArray();
		} catch (IOException e) {
		}finally {
			if(stream!=null)
				stream.close();

			if(out!=null)
				out.close();
		}
		return null;
	}
	/**
	 * 获取文件扩展名
	 * @param filename
	 * @param defExt
	 * @return
	 */
	public static String getExtension(String filename, String defExt) {
        if ((filename != null) && (filename.length() > 0)) {
            int i = filename.lastIndexOf('.');
            if ((i > -1) && (i < (filename.length() - 1))) {
                return filename.substring(i + 1);
            }
        }
        return defExt;
    }
}
