package com.gtis.portal.util;

import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfStuffConfig;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfStuffConfigService;
import com.gtis.portal.service.PfUserService;
import com.gtis.web.SessionUtil;
import freemarker.cache.StringTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

import java.io.*;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @文件说明
 * @作者 deery
 * @创建日期 上午 9:58
 * @版本号 V 1.0
 */
public class CommonUtils {
    //首页综合事务中，各模块的配置数据
    public static Map urlMap;

    //首页的待办事项提醒及其菜单项配置
    public static Map indexRightTopMenuMap;

    //工作流新建时，默认工作流名称的初始化信息
    public static Map defaultWINameMap;

    public static Object readJsonFile(String path) throws Exception {
        if (StringUtils.isNotBlank(path)) {
            File file = new File(path);

            if (path.startsWith("zip") || path.startsWith("file") || path.startsWith("jar")) { // 当class文件在war中时，返回"zip:D:/ ..."样的路径
                Resource resource = new UrlResource(path);
                file = resource.getFile();
            } else {
                file = new File(path);
            }
            if (file.exists()) {
                BufferedReader bufferedReader = null;
                StringBuffer config = new StringBuffer();
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
                    String tmp = null;
                    while ((tmp = bufferedReader.readLine()) != null) {
                        config.append(tmp);
                    }
                } finally {
                    if (bufferedReader != null)
                        bufferedReader.close();
                }
                if (StringUtils.isNotBlank(config.toString())) {
                    return JSON.parse(config.toString());
                }
            } else {
                System.out.println("文件不存在：" + path);
            }
        }
        return null;
    }

    public static String getEgovhomeConfigFilePath(String project) throws Exception {
        String egovHomePath = AppConfig.getProperty("config.reload." + project + ".path");
        egovHomePath = RequestUtils.initOptProperties(egovHomePath);
        if (StringUtils.isNotBlank(egovHomePath)) {
            return egovHomePath + "/" + project + "/application.properties";
        } else {
            String path = AppConfig.getProperty("egov.conf");
            path = java.net.URLDecoder.decode(path, "UTF-8");
            path = path.replace("file:/", "");
            String filePath = path;
            if (StringUtils.equalsIgnoreCase("egov", project)) {
                filePath += "egov.properties";
            } else if (StringUtils.equalsIgnoreCase("gis", project)) {
                filePath += "gis.properties";
            } else {
                filePath += project + "/application.properties";
            }
            filePath = RequestUtils.initOptProperties(filePath);
            return filePath;
        }
    }

    public static File getEgovhomeConfigFile(String project) throws Exception {
        String filePath = getEgovhomeConfigFilePath(project);
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    /**
     * 获取egovhome下所有的系统配置文件夹及根目录下的配置文件，只处理properties配置文件
     *
     * @return
     * @throws Exception
     */
    public static List<String> getEgovhomeConfigFileList() throws Exception {
        List<String> fileList = new ArrayList<String>();
        String path = AppConfig.getProperty("egov.conf");
        path = java.net.URLDecoder.decode(path, "UTF-8");
        path = path.replace("file:/", "");
        File dir = new File(path);
        if (dir.exists()) {
            dir.listFiles();
            //如果是目录，则：
            if (dir.isDirectory()) {
                //打印当前目录的路径
                //获取该目录下的所有文件和目录组成的File数组
                File[] files = dir.listFiles();
                //递归遍历每一个子文件
                for (File file : files) {
                    String fileName = file.getName();
                    if (file.isDirectory()) {
                        if (fileName.matches("^[A-Za-z]+$")) {
                            fileList.add(fileName);
                        }
                    } else {
                        String prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
                        if (StringUtils.equalsIgnoreCase(prefix, "properties")) {
                            fileName = StringUtils.split(fileName, ".")[0];
                            if (fileName.matches("^[A-Za-z]+$")) {
                                fileList.add(0, fileName);
                            }
                        }
                    }
                }
            }
        }
        int egovIndex = fileList.indexOf("egov");
        fileList.remove(egovIndex);
        fileList.add(0, "egov");
        return fileList;
    }

    /**
     * 获得工作流定义中的附件类型(初始化文件中心附件文件夹)
     *
     * @param nodeService
     * @param stuffConfigService
     * @param workflowDefinitionId
     * @param fileCenterNodeId
     */
    public static void initWorkflowFileCenter(NodeService nodeService, PfStuffConfigService stuffConfigService, String workflowDefinitionId, int fileCenterNodeId) {
        List<Node> nodeChiles = nodeService.getChildNodes(fileCenterNodeId);
        if (nodeChiles == null || nodeChiles.size() <= 0) {
            //获得工作流定义中的附件类型，用于待办任务打开时，初始化待办任务的附件管理页面
            List<PfStuffConfig> configList = stuffConfigService.getListByWfdId(workflowDefinitionId);
            if (configList != null && configList.size() > 0) {
                LinkedHashMap<String, Ztree> stuffTreeMap = new LinkedHashMap<String, Ztree>();
                for (int i = 0; i < configList.size(); i++) {
                    PfStuffConfig configTmp = configList.get(i);

                    PfStuffConfig stuff = new PfStuffConfig();
                    stuff.setStuffId(configTmp.getStuffId());
                    stuff.setProId(configTmp.getProId());
                    stuff.setStuffName(configTmp.getStuffName());

                    Ztree tree = toZtree(stuff);
                    stuffTreeMap.put(tree.getId(), tree);
                }
                Ztree root = new Ztree();
                root.setId("treeroot");
                root.setName("根节点");
                root.setKz3(fileCenterNodeId);
                for (Ztree tree : stuffTreeMap.values()) {
                    if (tree.getPid() != null) {
                        Ztree ztree = stuffTreeMap.get(tree.getPid());
                        if (ztree != null) {
                            ztree.addChild(tree);
                        } else {
                            tree.setPid("treeroot");
                            root.addChild(tree);
                        }
                    } else {
                        tree.setPid("treeroot");
                        root.addChild(tree);
                    }
                }

                if (root.getChildren() != null && root.getChildren().size() > 0) {
                    for (int i = 0; i < root.getChildren().size(); i++) {
                        createFileTree(root, nodeService);
                    }
                }
            }
        }
    }

    private static Ztree toZtree(PfStuffConfig stuff) {
        Ztree tree = new Ztree();
        tree.setId(stuff.getStuffId());
        tree.setName(stuff.getStuffName());
        if (stuff.getProId() == null) {
            tree.setPid("treeroot");
        } else {
            tree.setPid(StringUtils.trimToNull(stuff.getProId()));
        }
        return tree;
    }

    public static void createFileTree(Ztree parent, NodeService nodeService) {
        if (parent.getChildren() != null && parent.getChildren().size() > 0) {
            for (int i = 0; i < parent.getChildren().size(); i++) {
                Ztree tree = parent.getChildren().get(i);
                Node stuffNode = nodeService.getNode(parent.getKz3(), tree.getName(), true);
                //用xh字段临时代替文件中心节点id，用于下面获取父节点id的调用
                tree.setKz3(stuffNode.getId());
                createFileTree(tree, nodeService);
                parent.getChildren().set(i, tree);
            }
        }
    }

    /**
     * 检查是否有对应的独立版本的首页文件夹
     *
     * @param version
     * @return
     */
    public static boolean checkHasIndexVersion(String version) {
        if (StringUtils.isNotBlank(version)) {
            /*String path = System.getProperty("user.dir");
            path = path.replace("\\bin", "\\webapps") + "\\portal";
            File file = new File(path+"\\WEB-INF\\views\\index\\zhsw\\"+version);*/
            String path = CommonUtils.class.getResource("/").getPath();
            path = path.replace("classes", "views");
            File file = new File(path + "\\index\\zhsw\\" + version);
            if (file.exists()) {
                return true;
            }
        }
        return false;
    }

    /**
     * 检查是否有对应的独立版本的任务中心页面
     *
     * @param version
     * @return
     */
    public static boolean checkHasTaskVersion(String version) {
        if (StringUtils.isNotBlank(version)) {
            String path = System.getProperty("user.dir");
            path = path.replace("\\bin", "\\webapps") + "\\portal";
            File file = new File(path + "\\WEB-INF\\views\\" + version + "\\task\\");
            if (file.exists()) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkHasTaskCenterVersion(String version) {
        if (StringUtils.isNotBlank(version)) {
            //获取用户当前工作目录java-home
            String path = System.getProperty("user.dir");
            path = path.replace("\\bin", "\\webapps") + "\\portal";
            File file = new File(path + "\\WEB-INF\\views\\task\\" + version);
            if (file.exists()) {
                return true;
            }
        }
        return false;
    }

    public static String freemarkerProcess(Map input, String templateStr) {
        if (StringUtils.isNotBlank(templateStr) && StringUtils.contains(templateStr, "$")) {
            StringTemplateLoader stringLoader = new StringTemplateLoader();
            String template = "content";
            stringLoader.putTemplate(template, templateStr);
            Configuration cfg = new Configuration();
            cfg.setTemplateLoader(stringLoader);
            try {
                Template templateCon = cfg.getTemplate(template);
                StringWriter writer = new StringWriter();
                templateCon.process(input, writer);
                return writer.toString();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (TemplateException e) {
                e.printStackTrace();
            }
        }
        return templateStr;
    }

    /**
     * 解析url参数，将参数转为map对象，之后通过freemarker方式，将url中的变量转换为对应的值
     *
     * @param urlParamStr
     * @param url
     * @return
     */
    public static String initUrlParam(String urlParamStr, String url) {
        //解析url参数，将参数转为map对象，之后通过freemarker方式，将url中的变量转换为对应的值
        String params = urlParamStr;
        if (StringUtils.contains(params, "?")) {
            params = StringUtils.substringAfter(urlParamStr, "?");
        }
        Map<String, String> paramMap = new HashMap<String, String>();
        String[] param = params.split("&");
        for (String keyvalue : param) {
            String[] pair = keyvalue.split("=");
            if (pair.length == 2 && !StringUtils.contains(pair[1], "$")) {
                paramMap.put(pair[0], pair[1]);
            }
        }
        return freemarkerProcess(paramMap, url);
    }

    public static String initCurUserUrlParam() {
        String curUserParam = "";
        try {
            if (AppConfig.getBooleanProperty("portal.resource.url.addUsername", false)) {
                String username = "";
                if (SessionUtil.getCurrentUser() != null) {
                    username = SessionUtil.getCurrentUser().getUsername();
                }
                curUserParam += "&username=" + username;
            }
            if (AppConfig.getBooleanProperty("portal.resource.url.addRole", false)) {
                String roleId = "";
                if (SessionUtil.getCurrentUser().getLstRole() != null && !SessionUtil.getCurrentUser().getLstRole().isEmpty()) {
                    roleId = SessionUtil.getCurrentUser().getLstRole().get(0).getRoleId();
                }
                curUserParam += "&role=" + roleId;
                curUserParam += "&roles=" + SessionUtil.getCurrentUser().getRoleIds();
            }
            if (AppConfig.getBooleanProperty("portal.resource.url.addXzqdm", false)) {
                String xzqdm = "";
                if (SessionUtil.getCurrentUser().getLstOragn() != null && !SessionUtil.getCurrentUser().getLstOragn().isEmpty()) {
                    xzqdm = SessionUtil.getCurrentUser().getLstOragn().get(0).getRegionCode();
                }
                curUserParam += "&xzqdm=" + xzqdm;
            }
        } catch (Exception ex) {

        }
        return curUserParam;
    }

    public static HashMap initCurUserUrlMap(PfUserService pfUserService) {
        HashMap curUserParam = new HashMap();
        try {
            if (SessionUtil.getCurrentUser() != null) {
                UserInfo userInfo = SessionUtil.getCurrentUser();
                PfUser pfUser = pfUserService.findById(userInfo.getId());
                curUserParam.put("userid", pfUser.getUserId());
                curUserParam.put("username", pfUser.getUserName());
                curUserParam.put("loginname", pfUser.getLoginName());
                curUserParam.put("GT_USER_ID", pfUser.getUserId());
                curUserParam.put("GT_USER_NAME", pfUser.getUserName());
                curUserParam.put("GT_LOGIN_NAME", pfUser.getLoginName());
                if (userInfo.getLstRole() != null && !userInfo.getLstRole().isEmpty()) {
                    curUserParam.put("role", userInfo.getLstRole().get(0).getRoleId());
                    curUserParam.put("roles", userInfo.getRoleIds());
                }

                if (userInfo.getLstOragn() != null && !userInfo.getLstOragn().isEmpty()) {
                    curUserParam.put("organ", userInfo.getLstOragn().get(0).getOrganId());
                    curUserParam.put("xzqdm", userInfo.getLstOragn().get(0).getRegionCode());
                }
            }
        } catch (Exception ex) {
        }
        return curUserParam;
    }

    /**
     * 获取当前人员的固定参数，作为url的解析，url中可以配置${username}来获取用户名
     *
     * @param activityRoleList
     * @return
     */
    public static HashMap initCurUserUrlMap(List<String> activityRoleList, PfUserService pfUserService) {
        HashMap curUserParam = new HashMap();
        try {
            if (SessionUtil.getCurrentUser() != null) {
                UserInfo userInfo = SessionUtil.getCurrentUser();
                PfUser pfUser = pfUserService.findById(userInfo.getId());
                curUserParam.put("userid", pfUser.getUserId());
                curUserParam.put("username", pfUser.getUserName());
                curUserParam.put("loginname", pfUser.getLoginName());
                curUserParam.put("GT_USER_ID", pfUser.getUserId());
                curUserParam.put("GT_USER_NAME", pfUser.getUserName());
                curUserParam.put("GT_LOGIN_NAME", pfUser.getLoginName());
                if (userInfo.getLstRole() != null && !userInfo.getLstRole().isEmpty()) {
                    List<PfRoleVo> roles = SessionUtil.getCurrentUser().getLstRole();
                    String roleId = roles.get(0).getRoleId();
                    if (activityRoleList != null && activityRoleList.size() > 0) {
                        for (PfRoleVo pfRoleVo : roles) {
                            if (activityRoleList.contains(pfRoleVo.getRoleId())) {
                                roleId = pfRoleVo.getRoleId();
                                break;
                            }
                        }
                    }

                    curUserParam.put("role", roleId);
                    curUserParam.put("roles", userInfo.getRoleIds());
                }

                if (userInfo.getLstOragn() != null && !userInfo.getLstOragn().isEmpty()) {
                    curUserParam.put("organ", userInfo.getLstOragn().get(0).getOrganId());
                    curUserParam.put("xzqdm", userInfo.getLstOragn().get(0).getRegionCode());
                }
            }
        } catch (Exception ex) {
        }
        return curUserParam;
    }

    /**
     * 去除字符串中的换行符、占位符
     *
     * @param str
     * @return
     */
    public static String removeBlankLine(String str) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(str);
        return m.replaceAll("");
    }

    /**
     * 获取字符串中的整数部分
     *
     * @param str
     * @return
     */
    public static String getIntegerStr(String str) {
        String numberRegEx = "[^0-9]";
        Pattern pattern = Pattern.compile(numberRegEx);
        Matcher matcher = pattern.matcher(str);
        String result = matcher.replaceAll("");
        return result;
    }

    /**
     * 获取字符串中的数字部分
     *
     * @param str
     * @return
     */
    public static String getNumberStr(String str) {
        String numberRegEx = "([^(\\d|\\.)])";
        Pattern pattern = Pattern.compile(numberRegEx);
        Matcher matcher = pattern.matcher(str);
        String result = matcher.replaceAll("");
        return result;
    }
    //得到客户端MAC地址
    public static String getMACAddress(String ip) throws SocketException, UnknownHostException {
        String macAddress = "";
        macAddress = getMacInWindows(ip).trim();
        if(macAddress==null||"".equals(macAddress)){
            macAddress = getMacInLinux(ip).trim();
        }
        return macAddress;
    }
    /**
     *
     * @param ip 目标ip
     * @return  Mac Address
     *
     */
    public static String getMacInWindows(final String ip){
        String result = "";
        String[] cmd = {
                "cmd",
                "/c",
                "ping " + ip
        };
        String[] another = {
                "cmd",
                "/c",
                "arp -a"
        };

        String cmdResult = callCmd(cmd,another);
        result = filterMacAddress(ip,cmdResult,"-");

        return result;
    }
    /**
     * @param ip 目标ip
     * @return  Mac Address
     *
     */
    public static String getMacInLinux(final String ip){
        String result = "";
        String[] cmd = {
                "/bin/sh",
                "-c",
                "ping " + ip + " -c 2 && arp -a"
        };
        String cmdResult = callCmd(cmd);
        result = filterMacAddress(ip,cmdResult,":");

        return result;
    }
    public static String callCmd(String[] cmd) {
        String result = "";
        String line = "";
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            InputStreamReader is = new InputStreamReader(proc.getInputStream());
            BufferedReader br = new BufferedReader (is);
            while ((line = br.readLine ()) != null) {
                result += line;
            }
        }
        catch(Exception e) {
            e.printStackTrace();
        }
        return result;
    }
    /**
     *
     * @param cmd 第一个命令
     * @param another 第二个命令
     * @return  第二个命令的执行结果
     */
    public static String callCmd(String[] cmd,String[] another) {
        String result = "";
        String line = "";
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            proc.waitFor(); //已经执行完第一个命令，准备执行第二个命令
            proc = rt.exec(another);
            InputStreamReader is = new InputStreamReader(proc.getInputStream());
            BufferedReader br = new BufferedReader (is);
            while ((line = br.readLine ()) != null) {
                result += line;
            }
        }
        catch(Exception e) {
            e.printStackTrace();
        }
        return result;
    }
    /**
     *
     * @param ip 目标ip,一般在局域网内
     * @param sourceString 命令处理的结果字符串
     * @param macSeparator mac分隔符号
     * @return mac地址，用上面的分隔符号表示
     */
    public static String filterMacAddress(final String ip, final String sourceString,final String macSeparator) {
        String result = "";
        String regExp = "((([0-9,A-F,a-f]{1,2}" + macSeparator + "){1,5})[0-9,A-F,a-f]{1,2})";
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(sourceString);
        while(matcher.find()){
            result = matcher.group(1);
            if(sourceString.indexOf(ip) <= sourceString.lastIndexOf(matcher.group(1))) {
                break; //如果有多个IP,只匹配本IP对应的Mac.
            }
        }
        return result;
    }
}
