package com.gtis.portal.service.server.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.dao.server.WorkFlowTimeLimitDao;
import com.gtis.portal.entity.BdcGzlsx;
import com.gtis.portal.service.server.WorkFlowTimeLimitService;
import com.gtis.portal.util.QueryCondition;
import com.gtis.portal.util.WorkFlowXml;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

import static com.gtis.portal.entity.QBdcGzlsx.bdcGzlsx;

@Service
public class WorkFlowTimeLimitServiceImpl implements WorkFlowTimeLimitService {
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;
    @Autowired
    WorkFlowTimeLimitDao workFlowTimeLimitDao;
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    SysWorkFlowInstanceService sysWorkFlowInstanceService;

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public BdcGzlsx getBdcGzlsxjl(String workflow_time_id) {
        return baseDao.getById(BdcGzlsx.class, workflow_time_id);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void delBdcGzlsxjl(String id) {
        baseDao.delete(BdcGzlsx.class, id);
    }

    @Override
    public List<BdcGzlsx> queryGzlsxList(String wdid, String jdmc) {
        List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        if (StringUtils.isNotBlank(wdid)) {
            QueryCondition queryCondition = new QueryCondition("workflow_id", QueryCondition.LK, "%" + wdid + "%");
            queryConditions.add(queryCondition);
        }
        if (StringUtils.isNotBlank(jdmc)) {
            QueryCondition queryCondition1 = new QueryCondition("activity_name", QueryCondition.LK, "%" + jdmc + "%");
            queryConditions.add(queryCondition1);
        }

        return baseDao.get(BdcGzlsx.class, queryConditions);
    }

    @Override
    public BdcGzlsx getBdcGzlsxByWdidAndJdidAndDwdm(String workflow_id, String activity_id, String dwdm) {
        List<QueryCondition> queryConditions=new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("workflow_id", QueryCondition.EQ, workflow_id);
        QueryCondition queryCondition1 = new QueryCondition("activity_id", QueryCondition.EQ, activity_id);
        QueryCondition queryCondition2 = new QueryCondition("dwdm", QueryCondition.EQ, dwdm);

        queryConditions.add(queryCondition);
        queryConditions.add(queryCondition1);
        queryConditions.add(queryCondition2);

        List<BdcGzlsx> bdcGzlsxes = baseDao.get(BdcGzlsx.class, queryConditions);
        if (CollectionUtils.isNotEmpty(bdcGzlsxes))
            return bdcGzlsxes.get(0);
        return null;
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void updateBdcGzlsxjl(BdcGzlsx bdcGzlsx) {
        baseDao.update(bdcGzlsx);
    }

    public void addBdcGzlsxjl(BdcGzlsx bdcGzlsx) {
        baseDao.save(bdcGzlsx);
    }


    @Override
    public Page<BdcGzlsx> queryGzlsxList(String wdid, String jdmc, Pageable page) {
        BooleanExpression expression = null;
        if (StringUtils.isNotBlank(wdid))
            expression = bdcGzlsx.workflow_id.eq(wdid);

        if (StringUtils.isNotBlank(jdmc)) {
            if (expression == null)
                expression = bdcGzlsx.activity_name.eq(jdmc);
            else
                expression = expression.and(bdcGzlsx.activity_name.eq(jdmc));
        }

        return workFlowTimeLimitDao.findAll(expression, page);
    }

    @Override
    public BdcGzlsx getBdcGzlsxByWdidAndJdid(String wdid, String jdid,Integer gzlsx,Integer jdsx) {
        List<QueryCondition> queryConditions=new ArrayList<QueryCondition>();
        QueryCondition queryCondition = new QueryCondition("workflow_id", QueryCondition.EQ, wdid);
        QueryCondition queryCondition1 = new QueryCondition("activity_id", QueryCondition.EQ, jdid);
        QueryCondition queryCondition2 = new QueryCondition("activity_time_limit", QueryCondition.EQ, jdsx);
        QueryCondition queryCondition3 = new QueryCondition("workflow_time_limit", QueryCondition.EQ, gzlsx);

        queryConditions.add(queryCondition);
        queryConditions.add(queryCondition1);
        queryConditions.add(queryCondition2);
        queryConditions.add(queryCondition3);

        List<BdcGzlsx> bdcGzlsxes = baseDao.get(BdcGzlsx.class, queryConditions);
        if (CollectionUtils.isNotEmpty(bdcGzlsxes))
            return bdcGzlsxes.get(0);
        return null;
    }

    @Override
    public void save(BdcGzlsx bdcGzlsx) {
        if (StringUtils.isBlank(bdcGzlsx.getWorkflow_time_id())){
            bdcGzlsx.setWorkflow_time_id(UUIDGenerator.generate());
        }
        BdcGzlsx getBdcGzlsx=getBdcGzlsxjl(bdcGzlsx.getWorkflow_time_id());
        if(StringUtils.isNotBlank(bdcGzlsx.getWorkflow_id())){
            bdcGzlsx.setWorkflow_name(sysWorkFlowDefineService.getWorkFlowDefine(bdcGzlsx.getWorkflow_id()).getWorkflowName());
        }
        if(StringUtils.isNotBlank(bdcGzlsx.getActivity_id())){
            List<ActivityModel> activityModelList = null;
            if (StringUtils.isNotBlank(bdcGzlsx.getWorkflow_id())) {

                String xml = sysWorkFlowDefineService.getWorkFlowDefineXml(bdcGzlsx.getWorkflow_id());
                if (StringUtils.isNotBlank(xml)) {
                    WorkFlowXml modelXml = new WorkFlowXml(xml);
                    activityModelList = modelXml.getActivityList();
                }
            }
            if (CollectionUtils.isNotEmpty(activityModelList)) {
                for (ActivityModel activityModel : activityModelList) {
                    if (activityModel != null && StringUtils.equals(activityModel.getDefineId(), bdcGzlsx.getActivity_id())) {
                        bdcGzlsx.setActivity_name(activityModel.getActivityDefineName());
                    }
                }
            }
            if (getBdcGzlsx != null) {

                updateBdcGzlsxjl(bdcGzlsx);
            } else {
                addBdcGzlsxjl(bdcGzlsx);
            }
        }

    }


}
