package com.gtis.portal.service.server.impl;

import com.google.common.collect.Lists;
import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.DbBdcXm;
import com.gtis.portal.entity.DbBdcXmZsRel;
import com.gtis.portal.entity.DbBdcZs;
import com.gtis.portal.service.server.BdcXmService;
import com.gtis.portal.service.server.BdcZsService;
import com.gtis.portal.util.QueryCondition;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 不动产证书接口实现
 */
@Service
public class BdcZsServiceImpl implements BdcZsService {
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;
    @Autowired
    BdcXmService bdcXmService;

    @Override
    public String getLzztByWiid(List<DbBdcXm> dbBdcXmList) {
        String lzzt = "";
        List<DbBdcZs> dbBdcZsList = getDbBdcZsList(dbBdcXmList);
        if (CollectionUtils.isNotEmpty(dbBdcZsList)) {
            for (DbBdcZs bdcZs : dbBdcZsList) {
                if (StringUtils.isNotBlank(bdcZs.getFzstate()) && (StringUtils.equals(bdcZs.getFzstate(), "1")
                        || StringUtils.equals(bdcZs.getFzstate(), "2")))
                    lzzt = "已发证";
                else
                    lzzt = "未发证";
            }
        }
        return lzzt;
    }

    @Override
    public List<DbBdcZs> getDbBdcZsList(List<DbBdcXm> dbBdcXmList) {
        List<DbBdcZs> bdcZsList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(dbBdcXmList)) {
            for (DbBdcXm dbBdcXm : dbBdcXmList) {
                List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
                QueryCondition queryCondition = new QueryCondition("proid", QueryCondition.EQ, dbBdcXm.getProid());
                queryConditions.add(queryCondition);
                List<DbBdcXmZsRel> bdcXmZsRelList = baseDao.get(DbBdcXmZsRel.class, queryConditions);
                if (CollectionUtils.isNotEmpty(bdcXmZsRelList)) {
                    for (DbBdcXmZsRel bdcXmZsRel : bdcXmZsRelList) {
                        DbBdcZs dbBdcZs = getDbBdcZs(bdcXmZsRel.getZsid());
                        if (dbBdcZs != null)
                            bdcZsList.add(dbBdcZs);
                    }

                }
            }
        }

        return bdcZsList;
    }

    @Override
    public DbBdcZs getDbBdcZs(String zsid) {
        return baseDao.getById(DbBdcZs.class, zsid);
    }
}
