package com.gtis.portal.service.server.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.BdcXtLog;
import com.gtis.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2016/3/15
 * @description 不动产登记审计日志服务
 */
@Service
public class AuditLogServiceImpl {
    @Resource(name = "serverBaseDaoImpl")
    BaseDao baseDao;

    /**
     * @param bdcXtLog 审计日志对象
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 保存不动产审计日志
     */
    @Transactional
    public void saveAuditLog(BdcXtLog bdcXtLog) {
        if (StringUtils.isBlank(bdcXtLog.getLogid()))
            bdcXtLog.setLogid(UUIDGenerator.generate());
        baseDao.save(bdcXtLog);
    }
}
