package com.gtis.portal.web;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.PfSubsystem;
import com.gtis.portal.entity.PfUser;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.UserException;
import com.gtis.portal.service.IndexService;
import com.gtis.portal.service.PfSubsystemService;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.util.RequestUtils;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Map;
import java.util.List;


@Controller
public class IndexController extends BaseController{
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysDistrictService sysDistrictService;
    @Autowired
    IndexService indexService;
    @Autowired
    PfSubsystemService subsystemService;
    @Autowired
    PfUserService pfUserService;

    @RequestMapping("index")
    public String index(Model model,String systemId,HttpServletResponse response) throws Exception{
        initIndex(model);
        PfSubsystem sub = subsystemService.findInitUrlById(systemId);
        if (sub == null){
            sub = subsystemService.getSubsystemByName(systemId);
        }
        if (sub == null || StringUtils.isBlank(systemId)){
            List<PfSubsystem> subList = subsystemService.getAllSubsystemList(true);
            if (subList != null && subList.size() > 0){
                sub = subList.get(0);
                systemId = sub.getSubsystemId();
            }
        }
        if (sub == null){
            sub = new PfSubsystem();
        }
        model.addAttribute("sub",sub);

        //如果主题菜单没有配置类型，说明是老版本的升级，需要自动跳转到主题菜单配置界面
        if (sub.getSubType() != null){
            String returnPage = sub.getSubsystemName();
            switch (sub.getSubType()){
                case 1:
                    if (sub.getSubMenuType() != null){
                        //左两级菜单样式//左三级菜单样式
                        returnPage = sub.getSubMenuType();
                    }
                    break;
                case 2:
                    Map urlMap = indexService.getConfigIndexZhswUrl();
                    model.addAttribute("urlMap",urlMap);
                    model.addAttribute("urlMapJson",JSON.toJSONString(urlMap));
                    break;
                case 3:
                    returnPage = "iframe";
                    break;
            }
            return "index/"+returnPage+"/index";
        }
        response.sendRedirect("config/sub");
        return null;
    }

    @RequestMapping("indexFrame")
    public String indexFrame(Model model,String subUrl)throws Exception{
        if (StringUtils.isNotBlank(subUrl)){
            subUrl = java.net.URLDecoder.decode(subUrl,"utf-8");
        }
        initIndex(model);
        PfSubsystem sub = new PfSubsystem();
        sub.setSubUrl(RequestUtils.initOptProperties(subUrl));
        model.addAttribute("sub",sub);
        return "index/iframe/index";
    }

    public void initIndex(Model model) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        PfUser pfUser = pfUserService.findById(userInfo.getId());
        model.addAttribute("userName",SessionUtil.getCurrentUser().getUsername());
        model.addAttribute("userId",pfUser.getUserId());
        model.addAttribute("loginName",pfUser.getLoginName());
        List<PfOrganVo> organList = userInfo.getLstOragn();
        String organ = "";
        if(organList!=null&&organList.size()>0)
            organ = organList.get(0).getOrganName();
        model.addAttribute("organName",organ);
        model.addAttribute("organList",organList);

        String defaultDistrictCode = AppConfig.getProperty("district.code");
        List districtList = Lists.newArrayList();
        if(StringUtils.isNotBlank(defaultDistrictCode))
            districtList = sysDistrictService.querySubDistrictByCode(AppConfig.getProperty("district.code"));
        else
            districtList = sysDistrictService.queryAllDistrict();
        model.addAttribute("districtList",districtList);
    }
    @RequestMapping("password")
    @ResponseBody
    public Object password(Model model,String oldPassword,String newPassword,String confirmNewPassword) throws Exception{
        if(!newPassword.equals(confirmNewPassword))
            throw new UserException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        else{
            String userId = SessionUtil.getCurrentUserId();
            PfUserVo userObj=sysUserService.getUserVo(userId);
            if (userObj==null){
                throw new UserException(ExceptionCode.USER_NOT_FOUND);
            }else{
                String checkpass=oldPassword;
                String md5= Md5Util.Build(checkpass);
                if (md5.equals(userObj.getLoginPassWord())){
                    if (sysUserService.savePassWord(userId, newPassword)){
                       return handlerSuccessJson();
                    }
                    else
                       throw new UserException(ExceptionCode.USER_MODIFY_ERROR);
                }else
                    throw new UserException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
            }
        }
    }

    @RequestMapping("signPassword")
    @ResponseBody
    public Object signPassword(Model model,String oldSignPassword,String newSignPassword,String confirmNewSignPassword) throws Exception{
        if(!newSignPassword.equals(confirmNewSignPassword))
            throw new UserException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        else{
            String userId = SessionUtil.getCurrentUserId();
            PfUserVo userObj=sysUserService.getUserVo(userId);
            if (userObj==null){
                throw new UserException(ExceptionCode.USER_NOT_FOUND);
            }else{
                String checkpass=oldSignPassword;
                String md5= Md5Util.Build(checkpass);
                if (md5.equals(userObj.getSignPassword())){
                    if (sysUserService.saveSignPassword(userId, newSignPassword)){
                        return handlerSuccessJson();
                    }
                    else
                        throw new UserException(ExceptionCode.USER_MODIFY_ERROR);
                }else
                    throw new UserException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
            }
        }
    }
}