package com.gtis.portal.service;


import com.gtis.portal.entity.PfResourceGroup;
import com.gtis.portal.entity.PfSubsystem;
import com.gtis.portal.entity.PfSubsystemMenuRel;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.model.ZtreeChanged;

import java.util.List;

public interface PfSubsystemService extends BaseService<PfSubsystem, String> {
    public PfSubsystem findInitUrlById(String systemId);
    public List<PfSubsystem> getAllSubsystemList(boolean enable);
    public List<Ztree> getSubsystemTree();
    public PfSubsystem getSubsystemByName(String name);
    public Integer getMaxSubsystemId();
    public PfSubsystemMenuRel getSubMenuRel(String menuId,String subId);
    public List<PfSubsystemMenuRel> getSubMenuRelList(String menuId,String subId);
    public void deleteSubMenuRel(String menuId,String subId);
    public void insertMenuRel(String menuId,String subId);
    public void updateSubMenuRel(List<ZtreeChanged> changeList,String subId);
}
