package com.gtis.portal.service.impl;


import com.gtis.portal.entity.PfUser;
import com.gtis.portal.model.Ztree;
import com.gtis.portal.service.PfUserService;
import com.gtis.portal.util.CalendarUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.List;


@Service
public class PfUserServiceImpl extends BaseServiceImpl<PfUser, String> implements PfUserService {


    @Transactional
    public void deleteById(String userId){
        if (StringUtils.isNotBlank(userId)){
            String jpql = "delete from PfUserRoleRel t where t.userId=?0";
            baseDao.executeJpql(jpql,userId);
            jpql = "delete from PfUserOrganRel t where t.userId=?0";
            baseDao.executeJpql(jpql,userId);
            super.deleteById(userId);
        }
    }

    public List<PfUser> getListByRoleId(String roleId){
        String jqpl = "select t from PfUser t,PfUserRoleRel t1 where t.userId=t1.userId and t1.roleId=?0";
        return baseDao.getByJpql(jqpl,roleId);
    }

    public List<Ztree> getTreeByRoleId(String roleId){
        List<PfUser> userList = getListByRoleId(roleId);
        return initZtreeUser(userList);
    }

    public List<PfUser> getListByOrganId(String organId){
        String jqpl = "select t from PfUser t,PfUserOrganRel t1 where t.userId=t1.userId and t1.organId=?0";
        return baseDao.getByJpql(jqpl,organId);
    }

    public List<Ztree> getTreeByOrganId(String organId){
        List<PfUser> userList = getListByOrganId(organId);
        return initZtreeUser(userList);
    }

    private List<Ztree> initZtreeUser(List<PfUser> userList){
        List<Ztree> treeList = new ArrayList<Ztree>();
        if (userList != null && userList.size() > 0){
            for (int i = 0; i < userList.size(); i++) {
                treeList.add(toZtreeByUserId(userList.get(i)));
            }
        }
        return treeList;
    }

    private Ztree toZtreeByUserId(PfUser user){
        Ztree tree = new Ztree();
        tree.setId(user.getUserId());
        tree.setName(user.getUserName());
        tree.setPid("treeroot");
        return tree;
    }

    @Override
    @Transactional
    public void updateUserBlob(PfUser user,int mark) throws  Exception{
        long in = 0;
        byte[] b = null;
        if(mark==0){
            String jpql = "update PfUser t set  t.userPhoto=?0 where t.userId=?1";
            baseDao.executeJpql(jpql,user.getUserPhoto(),user.getUserId());
        }else if(mark==1){
            String jpql = "update PfUser t set  t.userSign=?0 where t.userId=?1";
            baseDao.executeJpql(jpql,user.getUserSign(),user.getUserId());
        }
    }

    @Override
    @Transactional
    public void updateUserLogin(PfUser user) {
        String jpql = "update PfUser t set  t.loginName=?0  ,t.loginPassword=?1  where t.userId=?2";
        baseDao.executeJpql(jpql,user.getLoginName(),user.getLoginPassword(),user.getUserId());
    }

    @Override
    @Transactional
    public void updateUserinfo(PfUser user) {
        if (user != null){
            PfUser usertmp = findById(user.getUserId());
            if (usertmp != null){
                String jpql = "update PfUser t set t.userNo=?0 ,t.userName=?1,t.userRank=?2,t.userPost=?3," +
                        " t.email=?4,t.mobilePhone=?5,t.officePhone=?6,t.homePhone=?7,t.birthdate=?8," +
                        " t.userDegree=?9,t.userSex=?10,t.address=?11,t.remark=?12,t.isValid=?13 " +
                        " where t.userId=?14";
                System.out.println(jpql);
                baseDao.executeJpql(jpql,user.getUserNo(),user.getUserName(),user.getUserRank(),user.getUserPost(),
                        user.getEmail(),user.getMobilePhone(),user.getOfficePhone(),user.getHomePhone(),user.getBirthdate(),
                        user.getUserDegree(),user.getUserSex(),user.getAddress(),user.getRemark(),user.getIsValid(),
                        user.getUserId());
            }
        }
    }
}
