package com.gtis.portal.service.impl;

import com.alibaba.fastjson.JSON;
import com.gtis.portal.entity.PfSjd;
import com.gtis.portal.entity.PfStuffConfig;
import com.gtis.portal.entity.QPfSjd;
import com.gtis.portal.entity.QPfUserOrganRel;
import com.gtis.portal.service.PfSjdService;
import com.mysema.query.jpa.impl.JPADeleteClause;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 收件单表
 */
@Component
public class PfSjdServiceImpl extends BaseServiceImpl<PfSjd, String> implements PfSjdService {
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = Exception.class)
    public void deleteByProId(String proid) {
        QPfSjd pfSjd = QPfSjd.pfSjd;
        new JPADeleteClause(em,pfSjd).where(pfSjd.proid.eq(proid)).execute();
    }
}