package com.gtis.portal.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.Date;

/**
 * 收件单表
 */
@Entity
@Table(name = "PF_SJD")
@Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PfSjd implements Serializable {
    @Id
    @Column
    private String sjdid;//收件单ID
    @Column
    private String proid;//项目ID
    @Column
    private String sjdBh;//收件单编号
    @Column
    private String sjdSqlx;//申请类型
    @Column
    private String sjdJjr;//接件人
    @Column
    private String sjdLxdh;//申请类型代码
    @Column
    private Integer sjdCnqx;//承诺期限
    @Column
    private String sjdSjr;//收件人
    @Column
    private Date sjdSjDate;//收件日期
    @Column
    private String sjdBz;//备注
    @Column
    private Integer sjdBhYear;//收件单编号_年
    @Column
    private Integer sjdBhXh;//收件单编号_序号
    @Column
    private String address;//通讯地址
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @JSONField(serialize = false)
    @Column(name="FLOWCHART", columnDefinition="BLOB", nullable=true)
    private java.sql.Blob sjdCl;//收件单材料

    public String getSjdid() {
        return sjdid;
    }

    public void setSjdid(String sjdid) {
        this.sjdid = sjdid;
    }

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getSjdBh() {
        return sjdBh;
    }

    public void setSjdBh(String sjdBh) {
        this.sjdBh = sjdBh;
    }

    public String getSjdSqlx() {
        return sjdSqlx;
    }

    public void setSjdSqlx(String sjdSqlx) {
        this.sjdSqlx = sjdSqlx;
    }

    public String getSjdJjr() {
        return sjdJjr;
    }

    public void setSjdJjr(String sjdJjr) {
        this.sjdJjr = sjdJjr;
    }

    public String getSjdLxdh() {
        return sjdLxdh;
    }

    public void setSjdLxdh(String sjdLxdh) {
        this.sjdLxdh = sjdLxdh;
    }

    public Integer getSjdCnqx() {
        return sjdCnqx;
    }

    public void setSjdCnqx(Integer sjdCnqx) {
        this.sjdCnqx = sjdCnqx;
    }

    public String getSjdSjr() {
        return sjdSjr;
    }

    public void setSjdSjr(String sjdSjr) {
        this.sjdSjr = sjdSjr;
    }

    public Date getSjdSjDate() {
        return sjdSjDate;
    }

    public void setSjdSjDate(Date sjdSjDate) {
        this.sjdSjDate = sjdSjDate;
    }

    public String getSjdBz() {
        return sjdBz;
    }

    public void setSjdBz(String sjdBz) {
        this.sjdBz = sjdBz;
    }

    public Integer getSjdBhYear() {
        return sjdBhYear;
    }

    public void setSjdBhYear(Integer sjdBhYear) {
        this.sjdBhYear = sjdBhYear;
    }

    public Integer getSjdBhXh() {
        return sjdBhXh;
    }

    public void setSjdBhXh(Integer sjdBhXh) {
        this.sjdBhXh = sjdBhXh;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Blob getSjdCl() {
        return sjdCl;
    }

    public void setSjdCl(Blob sjdCl) {
        this.sjdCl = sjdCl;
    }
}