/*
 * Project:  onemap
 * Module:   server
 * File:     IndexConfigController.java
 * Modifier: xyang
 * Modified: 2013-05-23 08:48:17
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */
package com.gtis.portal.web.editor;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.model.EnumObjectHelper;
import com.gtis.portal.service.PfMenuService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;


@Controller
public class MenuEditorController {
    @Autowired
    PfMenuService menuService;

    @RequestMapping("/editor/menu")
    public String enter(Model model) {

        return "/editor/menu";
    }

    @RequestMapping("/editor/menu-prop")
    public String editor( Model model){
        //PfMenu menu=menuService.getMenu(menuId);
        //model.addAttribute("menu", menu);
        model.addAttribute("menuModelTypes",EnumObjectHelper.MenuOpenModel);
        return "/editor/menu-prop";
    }

    @ModelAttribute("menu")
    public PfMenu getMemu(@RequestParam(value = "menuId", required = false) String menuId) {
        return menuId == null ? new PfMenu() : menuService.getMenu(menuId);
    }

    @RequestMapping("/editor/menu/save")
    @ResponseBody
    public String save(HttpServletRequest req,@ModelAttribute("menu") PfMenu menu, Model model){
        if (menu!=null){
            menu.setMenuExpanded(StringUtils.isBlank(req.getParameter("menuExpanded")));
            menuService.updateMenu(menu);
        }
        //model.addAttribute("menu", menu);
        return null;
    }

    @RequestMapping("/editor/menu/add")
    @ResponseBody
    public String add(HttpServletRequest req,@ModelAttribute("menu") PfMenu menu, Model model){
        if (menu!=null){
            menu.setMenuExpanded(StringUtils.isBlank(req.getParameter("menuExpanded")));
            menu.setMenuParentId(menu.getMenuId());
            menu.setMenuId(UUIDGenerator.generate());
            menu.setResourceId(null);
            menu.setMenuExpanded(false);
            menuService.addMenu(menu);
        }
        //model.addAttribute("menu", menu);
        return null;
    }

    @RequestMapping("/editor/menu/del")
    @ResponseBody
    public String del(@ModelAttribute("menu") PfMenu menu){
        if (menu!=null){
            menuService.delMenu(menu);
            return null;
        }
        return null;
    }
}