package com.gtis.portal.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.common.util.ByteObjectAccess;
import com.gtis.common.util.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysAuthorService;
import com.gtis.plat.service.SysMenuService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.*;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.portal.entity.PfMenu;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.*;

/**
 * 任务中心
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/1/8
 */
@Controller
@RequestMapping("/taskCenter")
public class TaskCenterController {
    @Autowired
    SysWorkFlowDefineService sysWorkFlowDefineService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysAuthorService sysAuthorService;
    @Autowired
    SysMenuService sysMenuService;

    @RequestMapping("index")
    public String taskCenter(Model model,@RequestParam String rid) throws Exception {
        model.addAttribute("rid",rid);
        if (rid.startsWith("r:")){
            rid = rid.replace("r:","");
        }
        UserInfo userInfo = SessionUtil.getCurrentUser();

        List<PfWorkFlowDefineVo> lstWorkFlowDefine = Lists.newArrayList();

        if (userInfo.isAdmin())
            lstWorkFlowDefine = sysWorkFlowDefineService.getWorkFlowDefineList();
        else
            lstWorkFlowDefine = sysWorkFlowDefineService.getWorkFlowDefineListByRole(userInfo.getRoleIds(), rid, null);
        Map<String,List<PfWorkFlowDefineVo>> mapWorkFlowDefine = Maps.newLinkedHashMap();
        for(PfWorkFlowDefineVo wfd : lstWorkFlowDefine){
            String businessName = wfd.getBusinessVo().getBusinessName();
            String groupId = wfd.getGroupId();
            String categoryName =  businessName;
            String createUrl = wfd.getCreateUrl() == null ? "" : wfd.getCreateUrl();
            wfd.setCreateUrl(AppConfig.getPlaceholderValue(createUrl));
            if(StringUtils.isNotBlank(groupId))
                categoryName = wfd.getResourceGroupVo().getGroupName();
            if(mapWorkFlowDefine.get(categoryName) != null){
                mapWorkFlowDefine.get(categoryName).add(wfd);
            }else {
                List<PfWorkFlowDefineVo> wfdList = Lists.newArrayList();
                wfdList.add(wfd);
                mapWorkFlowDefine.put(categoryName, wfdList);
            }
        }
        model.addAttribute("workFlowDefineMap",mapWorkFlowDefine);


        SplitParamImpl splitParam1=new SplitParamImpl();
        splitParam1.setQueryString("getTaskList");
        HashMap mapParam=Maps.newHashMap();
        mapParam.put("userIds",SessionUtil.getCurrentUserId().equals("0") ? null:SessionUtil.getCurrentUserIds());
        splitParam1.setQueryParam(mapParam);
        model.addAttribute("taskList", ByteObjectAccess.objectToString(splitParam1));

        splitParam1.setQueryString("getTaskOverList");
        model.addAttribute("taskOverList",ByteObjectAccess.objectToString(splitParam1));

        splitParam1.setQueryString("getProjectList");
        model.addAttribute("projectList",ByteObjectAccess.objectToString(splitParam1));

        model.addAttribute("currentDate",CommonUtil.getCurrStrDate());
        List<PfBusinessVo> businessVoList= sysWorkFlowDefineService.getBusinessList();
        if (businessVoList != null && businessVoList.size() > 0) {
			for (int i = 0; i < businessVoList.size(); i++) {
				List tmpList = mapWorkFlowDefine.get(businessVoList.get(i).getBusinessName());
				if (tmpList == null || tmpList.size() < 1) {
					businessVoList.remove(i);
					i--;
				}
			}
		}
        model.addAttribute("businessList",businessVoList!=null?businessVoList:Lists.newArrayList());

        boolean hasDel=false;
        boolean hasRestart = false;
        if (SessionUtil.getCurrentUser().isAdmin()) {
            hasDel=true;
            hasRestart = true;
        }else{
            String roles = SessionUtil.getCurrentUser().getRoleIds();
            List<PfPartitionInfoVo> lstfPartitions=sysAuthorService.getSystemResrouceFunAuthorList(roles,rid);
            if (lstfPartitions!=null){
                for (PfPartitionInfoVo partitionInfoVo:lstfPartitions){
                    if (partitionInfoVo.getElementName().endsWith("删除")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("del")){
                        hasDel=true;
                        break;
                    }
                }
                for (PfPartitionInfoVo partitionInfoVo:lstfPartitions){
                    if (partitionInfoVo.getElementName().endsWith("重办")
                            || partitionInfoVo.getElementName().equalsIgnoreCase("restart")){
                        hasRestart=true;
                        break;
                    }
                }
            }

            List<String> listWdids=sysMenuService.getProjectWorkFlowDefineIds(roles);
            StringBuffer bufferWdids=new StringBuffer();
            if (listWdids!=null){
                for(int index = 0; index < listWdids.size(); index ++){
                    if(index>0)
                        bufferWdids.append(",");
                    bufferWdids.append("'" + listWdids.get(index) + "'");
                }
            }
            model.addAttribute("excludeWdids",bufferWdids.toString());
        }
        model.addAttribute("hasDel",hasDel);
        model.addAttribute("hasRestart",hasRestart);
        return "task-center";
    }

    /**
     * 获取所有工作流定义信息
     * @param wdid
     * @return
     */
    @RequestMapping("workflowDefinition")
    @ResponseBody
    public Object getWorkflowDefinition(@RequestParam String wdid){
        Map workflowDefinitionMap = Maps.newHashMap();
        PfWorkFlowDefineVo pfWorkFlowDefineVo = null;
        if(StringUtils.isNotBlank(wdid)){
            pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
        }
        workflowDefinitionMap.put("workflowDefine",pfWorkFlowDefineVo);
        workflowDefinitionMap.put("username",SessionUtil.getCurrentUser().getUsername());
        workflowDefinitionMap.put("createTime", CommonUtil.getCurrStrDate());
        return workflowDefinitionMap;
    }
    /**
     * 创建任务
     * @param pfWorkFlowInstanceVo
     * @return
     * @throws Exception
     */
    @RequestMapping("createDefaultTask")
    @ResponseBody
    public Object createTask(PfWorkFlowInstanceVo pfWorkFlowInstanceVo) throws Exception{
        Map result = Maps.newHashMap();
        result.put("success",false);
        String userId = SessionUtil.getCurrentUserId();
        String proId = UUIDGenerator.generate();
        pfWorkFlowInstanceVo.setWorkflowIntanceId(proId);
        pfWorkFlowInstanceVo.setProId(proId);
        WorkFlowInfo infoObj = workFlowCoreService.createWorkFlowInstance(
                pfWorkFlowInstanceVo, userId);
        String taskId=null;
        for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
            if (taskVo.getUserVo().getUserId().equals(userId)) {
                taskId = taskVo.getTaskId();
                break;
            }
        }
        if (StringUtils.isBlank(taskId)) {
            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                taskId = taskVo.getTaskId();
                break;
            }
        }
        result.put("success",true);
        result.put("taskId",taskId);
        return result;
    }
    /**
     * 创建任务
     * @param wdid
     * @return
     * @throws Exception
     */
    @RequestMapping("createTask")
    @ResponseBody
    public Object createTask(String wdid) throws Exception{
        Map result = Maps.newHashMap();
        result.put("success",false);
        if(StringUtils.isNotBlank(wdid)){
            PfWorkFlowDefineVo pfWorkFlowDefineVo = sysWorkFlowDefineService.getWorkFlowDefine(wdid);
            String userId = SessionUtil.getCurrentUserId();
            String proId = UUIDGenerator.generate();
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = new PfWorkFlowInstanceVo();
            StringBuilder workflowInstanceName = new StringBuilder("新建项目");
            workflowInstanceName.append(Calendar.getInstance().getTimeInMillis());
            pfWorkFlowInstanceVo.setWorkflowIntanceName(workflowInstanceName.toString());
            pfWorkFlowInstanceVo.setWorkflowDefinitionId(wdid);
            pfWorkFlowInstanceVo.setCreateTime(Calendar.getInstance().getTime());
            pfWorkFlowInstanceVo.setTimeLimit(pfWorkFlowDefineVo.getTimeLimit());
            pfWorkFlowInstanceVo.setPriority("1");
            pfWorkFlowInstanceVo.setCreateUser(SessionUtil.getCurrentUserId());
            pfWorkFlowInstanceVo.setWorkflowIntanceId(proId);
            pfWorkFlowInstanceVo.setProId(proId);
            WorkFlowInfo infoObj = workFlowCoreService.createWorkFlowInstance(
                    pfWorkFlowInstanceVo, userId);
            String taskId=null;
            for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                if (taskVo.getUserVo().getUserId().equals(userId)) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            if (StringUtils.isBlank(taskId)) {
                for (PfTaskVo taskVo : infoObj.getTargetTasks()) {
                    taskId = taskVo.getTaskId();
                    break;
                }
            }
            result.put("success",true);
            result.put("taskId",taskId);
        }

        return result;
    }
    @RequestMapping("getWorkflowDefinitions")
    @ResponseBody
    public Object getWorkflowDefinitions(String businessId){
        List<PfWorkFlowDefineVo> workFlowDefineVoList = null;
        if(StringUtils.isBlank(businessId))
            workFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineList();
        else
            workFlowDefineVoList = sysWorkFlowDefineService.getWorkFlowDefineByBusiness(businessId);
        return workFlowDefineVoList;
    }

    @RequestMapping("/index/zhjg")
    public String taskCenterZhjg(Model model,@RequestParam String rid) throws Exception {
        taskCenter(model,rid);
        return "/zhjg/task-center";
    }
}
