/*
 * Project:  onemap
 * Module:   server
 * File:     IndexConfigController.java
 * Modifier: xyang
 * Modified: 2013-05-23 08:48:17
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */
package com.gtis.portal.web;

import com.gtis.portal.entity.PfMessageAccept;
import com.gtis.portal.entity.PfMessageSend;
import com.gtis.portal.service.pfMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;


@Controller
public class MessageController {
    @Autowired
    pfMessageService messageService;

    private static int PAGE_SIZE=15;

    @RequestMapping("message")
     public String enter(String title,Date beginDate,Date endDate, Pageable page,Model model) {

        return "message";
    }

    @RequestMapping("message/sendlist")
    public String sendlist(String title,Date beginDate,Date endDate, Pageable page,Model model) {

        page = new PageRequest(page.getPageNumber(), page.getPageSize(), Sort.Direction.DESC, "messagesendDate");
        Page<PfMessageSend> messageSendPage= messageService.queryMessageSendList(null, title, beginDate, endDate, page);

        model.addAttribute("messageSendPage", messageSendPage);
        return "message-sendlist";
    }

    @RequestMapping("message/send")
    @ResponseBody
    public PfMessageSend send(@RequestParam(value = "messageId", required = true) String messageId,Model model) {
        return  messageService.getMessageSend(messageId);
    }

    @RequestMapping("message/accept")
    @ResponseBody
    public PfMessageAccept accept(@RequestParam(value = "messageId", required = true) String messageId,Model model) {
        return messageService.getMessageAccept(messageId);
    }

    @RequestMapping("message/acceptlist")
    public String acceptlist(String title,Date beginDate,Date endDate, Pageable page,Model model) {
        if (page==null)
            page = new PageRequest(1, PAGE_SIZE, null, null);
        Page<PfMessageAccept> messageAcceptPage= messageService.queryMessageAcceptList(null, title, beginDate, endDate, page);
        model.addAttribute("messageAcceptPage", messageAcceptPage);
        return "message-acceptlist";
    }
}