package com.gtis.portal.web;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.SysDistrictService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.ex.ExceptionCode;
import com.gtis.portal.ex.UserException;
import com.gtis.util.Md5Util;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;


@Controller
public class IndexController extends BaseController{
    @Autowired
    SysUserService sysUserService;
    @Autowired
    SysDistrictService sysDistrictService;

    @RequestMapping("index")
    public String index(Model model,String systemId) {
        UserInfo userInfo = SessionUtil.getCurrentUser();
        model.addAttribute("userName",SessionUtil.getCurrentUser().getUsername());
        List<PfOrganVo> organList = userInfo.getLstOragn();
        String organ = "";
        if(organList!=null&&organList.size()>0)
            organ = organList.get(0).getOrganName();
        model.addAttribute("organName",organ);

        String defaultDistrictCode = AppConfig.getProperty("district.code");
        List districtList = Lists.newArrayList();
        if(StringUtils.isNotBlank(defaultDistrictCode))
            districtList = sysDistrictService.querySubDistrictByCode(AppConfig.getProperty("district.code"));
        else
            districtList = sysDistrictService.queryAllDistrict();
        model.addAttribute("districtList",districtList);
        if(StringUtils.isBlank(systemId))
            systemId = AppConfig.getProperty("portal.system.default");
        model.addAttribute("subsystemId",systemId);
        return "index";
    }

    @RequestMapping("password")
    @ResponseBody
    public Object password(Model model,String oldPassword,String newPassword,String confirmNewPassword) throws Exception{
        if(!newPassword.equals(confirmNewPassword))
            throw new UserException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        else{
            String userId = SessionUtil.getCurrentUserId();
            PfUserVo userObj=sysUserService.getUserVo(userId);
            if (userObj==null){
                throw new UserException(ExceptionCode.USER_NOT_FOUND);
            }else{
                String checkpass=oldPassword;
                String md5= Md5Util.Build(checkpass);
                if (md5.equals(userObj.getLoginPassWord())){
                    if (sysUserService.savePassWord(userId, newPassword)){
                       return handlerSuccessJson();
                    }
                    else
                       throw new UserException(ExceptionCode.USER_MODIFY_ERROR);
                }else
                    throw new UserException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
            }
        }
    }

    @RequestMapping("signPassword")
    @ResponseBody
    public Object signPassword(Model model,String oldSignPassword,String newSignPassword,String confirmNewSignPassword) throws Exception{
        if(!newSignPassword.equals(confirmNewSignPassword))
            throw new UserException(ExceptionCode.NEW_PASSWORD_CONFIRM_PASSWORD_DIFF);
        else{
            String userId = SessionUtil.getCurrentUserId();
            PfUserVo userObj=sysUserService.getUserVo(userId);
            if (userObj==null){
                throw new UserException(ExceptionCode.USER_NOT_FOUND);
            }else{
                String checkpass=oldSignPassword;
                String md5= Md5Util.Build(checkpass);
                if (md5.equals(userObj.getSignPassword())){
                    if (sysUserService.saveSignPassword(userId, newSignPassword)){
                        return handlerSuccessJson();
                    }
                    else
                        throw new UserException(ExceptionCode.USER_MODIFY_ERROR);
                }else
                    throw new UserException(ExceptionCode.USER_OLD_PASSWORD_ERROR);
            }
        }
    }
    @RequestMapping("index/zhjg")
    public String indexZhjg(Model model,String systemId) {
        index(model,systemId);
        return "/zhjg/index";
    }

    @RequestMapping("index/zhsw")
    public String indexZhsw(Model model,String systemId) {
        index(model,systemId);
        return "/zhsw/index";
    }

    @RequestMapping("test")
    @ResponseBody
    public Object test(Model model) {
        return 2;
    }
}