package com.gtis.portal.service.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.PfResource;
import com.gtis.portal.model.Menu;
import com.gtis.portal.service.PfMenuService;
import com.gtis.portal.service.PfResourceService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

@Service
public class PfResourceServiceImpl implements PfResourceService {
    @Autowired
    BaseDao baseDao;

    public PfResource getResource(String resourceId){
        return baseDao.getById(PfResource.class,resourceId);
    }
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = Exception.class)
    public void updateResource(PfResource resource){
        baseDao.update(resource);
    }
    @Transactional(propagation = Propagation.REQUIRED,rollbackFor = Exception.class)
    public void insertResource(PfResource resource){
        baseDao.save(resource);
    }
}
