package com.gtis.portal.service.impl;

import com.gtis.portal.dao.BaseDao;
import com.gtis.portal.entity.PfMenu;
import com.gtis.portal.entity.QPfAuthorize;
import com.gtis.portal.entity.QPfMenu;
import com.gtis.portal.model.Menu;
import com.gtis.portal.service.PfMenuService;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;

import com.mysema.query.jpa.impl.JPAUpdateClause;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

@Service
public class PfMenuServiceImpl implements PfMenuService {
    @Autowired
    BaseDao baseDao;

    @PersistenceContext
    EntityManager em;


    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public PfMenu getMenu(String menuId) {
        return baseDao.getById(PfMenu.class, menuId);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void updateMenu(PfMenu menu) {
        baseDao.update(menu);
    }

    public void addMenu(PfMenu menu) {
        baseDao.save(menu);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void delMenu(PfMenu menu) {
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPQLQuery query = new JPAQuery(em);
        List<PfMenu> menuList = query.from(qPfMenu).where(qPfMenu.menuParentId.eq(menu.getMenuId())).list(qPfMenu);
        if (menuList == null || menuList.size() == 0) {
            new JPADeleteClause(em,qPfMenu).where(qPfMenu.menuId.eq(menu.getMenuId())).execute();
        } else {
            for (PfMenu menuVo : menuList) {
                this.delMenu(menuVo);
            }
        }

    }

    public Menu getMenusByRole(String roles) {
        List<PfMenu> menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPQLQuery query = new JPAQuery(em);
        if (StringUtils.isBlank(roles))
            menuList = query.from(qPfMenu).orderBy(qPfMenu.menuOrder.asc()).list(qPfMenu);
        else {
            QPfAuthorize qPfAuthorize = QPfAuthorize.pfAuthorize;
            roles = roles.replace("'", "");
            String[] roleList = roles.split(",");
            menuList = query.from(qPfMenu).where(qPfMenu.menuId.in(query.from(qPfAuthorize).where(qPfAuthorize.
                    authorizeObjType.eq("1"), qPfAuthorize.menuVisible.gt(0), qPfAuthorize.undertakerId.in(roleList)).
                    distinct().list(qPfAuthorize.authorizeObjId))).orderBy(qPfMenu.menuOrder.asc()).list(qPfMenu);
        }
        HashMap<String, Menu> menuMap = new LinkedHashMap<String, Menu>();
        Menu root = null;
        for (PfMenu menuVo : menuList) {
            Menu menu = toMenu(menuVo);
            menuMap.put(menu.getId(), menu);
        }
        for (Menu menu : menuMap.values()) {
            if (menu.getPid() != null) {
                Menu pMenu = menuMap.get(menu.getPid());
                if (pMenu != null) {
                    pMenu.addChild(menu);
                }
            } else {
                root = menu;
            }
        }
        return root;
    }

    @Override
    public Menu getMenusByRole(String roles, String subsystem) {
        List<PfMenu> menuList = null;
        QPfMenu qPfMenu = QPfMenu.pfMenu;
        JPQLQuery query = new JPAQuery(em);
        if (StringUtils.isBlank(roles))
            menuList = query.from(qPfMenu).where(qPfMenu.subsystems.any().subsystemName.eq(subsystem)).orderBy(qPfMenu.menuOrder.asc()).list(qPfMenu);
        else {
            QPfAuthorize qPfAuthorize = QPfAuthorize.pfAuthorize;
            roles = roles.replace("'", "");
            String[] roleList = roles.split(",");
            menuList = query.from(qPfMenu).where(qPfMenu.subsystems.any().subsystemName.eq(subsystem)).where(qPfMenu.menuId.in(query.from(qPfAuthorize).where(qPfAuthorize.
                    authorizeObjType.eq("1"), qPfAuthorize.menuVisible.gt(0), qPfAuthorize.undertakerId.in(roleList)).
                    distinct().list(qPfAuthorize.authorizeObjId))).orderBy(qPfMenu.menuOrder.asc()).list(qPfMenu);
        }
        HashMap<String, Menu> menuMap = new LinkedHashMap<String, Menu>();
        Menu root = null;
        for (PfMenu menuVo : menuList) {
            Menu menu = toMenu(menuVo);
            menuMap.put(menu.getId(), menu);
        }
        for (Menu menu : menuMap.values()) {
            if (menu.getPid() != null) {
                Menu pMenu = menuMap.get(menu.getPid());
                if (pMenu != null) {
                    pMenu.addChild(menu);
                }
            } else {
                root = menu;
            }
        }
        return root;
    }


    private static Menu toMenu(PfMenu menuVo) {
        Menu menu = new Menu();
        menu.setId(menuVo.getMenuId());
        menu.setIcon(menuVo.getMenuCode());
        menu.setText(menuVo.getMenuName());
        menu.setPid(StringUtils.trimToNull(menuVo.getMenuParentId()));
        menu.setCls(menuVo.getMenuCss());
        menu.setExpanded(menuVo.isMenuExpanded());
        String rid = menuVo.getResourceId();
        if (rid != null) {
            menu.setLink("r:" + rid);
        }
        menu.setModel(menuVo.getMenuModel());
        return menu;
    }
}
