package com.gtis.web.sign;

import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.config.AppConfig;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfOpinionVo;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletResponse;
import java.net.URLDecoder;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:jibo1024@gmail.com">boji</a>
 * @version V1.0, ${Date}
 */
public class SignAction implements Action{
    private static final Logger logger = LoggerFactory.getLogger(SignAction.class);
    /** 签名 */
    private PfSignVo signVo;
    /** 签名列表 */
    private List<PfSignVo> lstSign;
    /** 是否新建签名 */
    private boolean createNew = true;
    /** 是否可操作 */
    private boolean disabled = false;
    /** 意见类型 */
    private String opinionType;
    /** 是否填写意见 */
    private boolean isOpinion = true;
    /** 授权标识符 */
    private String warrantKey;
    /** 资源Id */
    private String rid;
    /** 签名服务 */
    private SysSignService signService;
    /** 授权服务 */
    private SysAuthorService authorService;
    /** 默认意见服务 */
    private SysOpinionService opinionService;
    /** 工作流定义服务 */
    private SysWorkFlowDefineService workFlowDefineService;
    /** 工作流服务 */
    private SysWorkFlowInstanceService workFlowInstanceService;
    /**工作流任务服务*/
    private SysTaskService sysTaskService;
    /** 签名点串 */
    private String signPoints;
//     是否用办理意见页面主要针对淮安设计
    private String useHandleOpinionPage;

    /** 是否按用户编号排序 */
    private boolean orderByUserNo = false;

    /** 显示意见的字体大小 */
    private String optinionSize="18";
    /** 图片地址   */
    private String imagesUrl;
    /**  图片宽度  */
    private String imageWidth="52";
    /** 图片高度  */
    private String imageHeight="24";

    private String taskid;

    private boolean showSignDate=true;
    /**是否进行签名前用户密码确认*/
    private boolean signUserCheck;

    public boolean isShowSignDate() {
        return showSignDate;
    }

    public void setShowSignDate(boolean showSignDate) {
        this.showSignDate = showSignDate;
    }

    public boolean isOrderByUserNo() {
        return orderByUserNo;
    }

    public void setOrderByUserNo(boolean orderByUserNo) {
        this.orderByUserNo = orderByUserNo;
    }
   
    public void setWorkFlowInstanceService(SysWorkFlowInstanceService workFlowInstanceService) {
        this.workFlowInstanceService = workFlowInstanceService;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public SysOpinionService getOpinionService() {
        return opinionService;
    }

    public void setOpinionService(SysOpinionService opinionService) {
        this.opinionService = opinionService;
    }

    public String getSignPoints() {
        return signPoints;
    }

    public void setSignPoints(String signPoints) {
        this.signPoints = signPoints;
    }

    public PfSignVo getSignVo() {
        return signVo;
    }

    public void setSignVo(PfSignVo signVo) {
        this.signVo = signVo;
    }

    public String getWarrantKey() {
        return warrantKey;
    }

    public void setWarrantKey(String warrantKey) {
        this.warrantKey = warrantKey;
    }

    public boolean isCreateNew() {
        return createNew;
    }

    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public void setCreateNew(boolean createNew) {
        this.createNew = createNew;
    }

    public boolean isDisabled() {
        return disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public List<PfSignVo> getLstSign() {
        return lstSign;
    }

    public void setLstSign(List<PfSignVo> lstSign) {
        this.lstSign = lstSign;
    }

    public SysSignService getSignService() {
        return signService;
    }

    public void setSignService(SysSignService signService) {
        this.signService = signService;
    }

    public String getOpinionType() {
        return opinionType;
    }

    public void setOpinionType(String opinionType) {
        this.opinionType = opinionType;
    }

    public boolean isOpinion() {
        return isOpinion;
    }

    public void setOpinion(boolean opinion) {
        isOpinion = opinion;
    }

    public String getOptinionSize() {
        return optinionSize;
    }

    public void setOptinionSize(String optinionSize) {
        this.optinionSize = optinionSize;
    }

    public String getImagesUrl() {
        return imagesUrl;
    }

    public void setImagesUrl(String imagesUrl) {
        this.imagesUrl = imagesUrl;
    }

    public String getImageWidth() {
        return imageWidth;
    }

    public void setImageWidth(String imageWidth) {
        this.imageWidth = imageWidth;
    }

    public String getImageHeight() {
        return imageHeight;
    }

    public void setImageHeight(String imageHeight) {
        this.imageHeight = imageHeight;
    }

    /**
     * 判断签名按钮是否有效,需要根据权限
     */
    private void btnDisable() {
        String disable = ServletActionContext.getRequest().getParameter("disable");
        if(!"true".equals(disable)){
            if (!disabled) {
                String from = ServletActionContext.getRequest().getParameter("from");
                String rid = ServletActionContext.getRequest().getParameter("rid");
                String wiid = ServletActionContext.getRequest().getParameter("wiid");
                if (StringUtils.isBlank(wiid)){
                    PfWorkFlowInstanceVo workFlowInstanceVo=workFlowInstanceService.getWorkflowInstanceByProId(signVo.getProId());
                    if(workFlowInstanceVo != null){
                        wiid=   workFlowInstanceVo.getWorkflowIntanceId();
                    }
                }
                if (!StringUtils.isBlank(from) && !StringUtils.isBlank(rid) && !StringUtils.isBlank(wiid)) {
                    if ("task".equalsIgnoreCase(from)){
                        String taskid= ServletActionContext.getRequest().getParameter("taskid");
                        disabled= authorService.queryTaskElement(wiid,taskid,rid,signVo.getSignKey());
                    }else if ("pro".equalsIgnoreCase(from)){
                        String roles = SessionUtil.getUserInfo(ServletActionContext.getRequest()).getRoleIds();
                        disabled=true;
                    }else{
                        logger.debug("from is null");
                    }
                }
            }
        }else{
            disabled = true;
        }
    }

    public String execute() throws Exception {
        if (signVo == null){
            lstSign = new ArrayList<PfSignVo>();
        }else if(StringUtils.isNotBlank(signVo.getSignId())){
            lstSign = new ArrayList<PfSignVo>();
            lstSign.add(signService.getSign(signVo.getSignId()));
        } else {
            HashMap map=new HashMap();
            map.put("signKey",signVo.getSignKey()) ;
            map.put("proId",signVo.getProId()) ;
            if(orderByUserNo)
                map.put("_orderfield_","t2.USER_NO");
            lstSign = signService.getSignListOrderfield(map);
        }
        signVo.setUserId(SessionUtil.getUserId(ServletActionContext.getRequest()));
        signVo.setSignName(SessionUtil.getUserName(ServletActionContext.getRequest()));
        if (disabled) {
            createNew = false;
        }else {
            for (PfSignVo sign : lstSign) {
                if (signVo.getUserId().equals(sign.getUserId())) {
                    createNew = false;
                    signVo = sign;
                    break;
                }
            }
        }
        signUserCheck = AppConfig.getBooleanProperty("signUserCheck.enable",false);
        btnDisable();
        if (isOpinion) {
            return Action.SUCCESS;
        }else
            return "sign_nooptinion";
    }

    /**
     * 签名图片
     * @return
     * @throws Exception
     */
    public String image() throws Exception {
        HttpServletResponse resp = ServletActionContext.getResponse();
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        resp.setDateHeader("Expires", -1);
        if (StringUtils.isNotBlank(signVo.getSignId())) {
            PfSignVo signBean = signService.getSign(signVo.getSignId());
            PfSignVo sign = signService.getSignImage(signVo.getSignId());
            if(sign == null){
                IOUtils.write("",resp.getOutputStream());
            }else{
                if (sign.getSignImage()!=null && sign.getSignImage().length>1000){
                    IOUtils.write(sign.getSignImage(),resp.getOutputStream());
                }else if (signBean!=null){
                    //如果签名图片不存在就生成一个
                    SignUitl.BuildSignImage(signBean.getSignName(),resp.getOutputStream());
                }
            }
        }
        return Action.NONE;
    }

    /**
     * 开始进入签名
     *
     * @return
     * @throws Exception
     */
    public String sign() throws Exception {
        signVo.setSignKey(URLDecoder.decode(signVo.getSignKey(),"UTF-8"));
        //获取签名意见类型
        if (StringUtils.isBlank(opinionType) && StringUtils.isNotBlank(signVo.getProId())) {
            PfWorkFlowInstanceVo workflowInstance = workFlowInstanceService.getWorkflowInstanceByProId(signVo.getProId());
            if (workflowInstance!=null){
                PfWorkFlowDefineVo workFlowDefineVo = workFlowDefineService.getWorkFlowDefine(workflowInstance.getWorkflowDefinitionId());
                opinionType = workFlowDefineVo.getWorkflowName();
            }
        }
        if (StringUtils.isNotBlank(signVo.getSignId())) {
            signVo = signService.getSign(signVo.getSignId());
        }
        if (signVo.getSignDate() == null) {
        	signVo.setSignDate(new Date(System.currentTimeMillis()));
		}

        return "sign";
    }

    /**
     * 获得默认意见
     * @return
     * @throws Exception
     */
    public String menu() throws Exception{
        String UserId = SessionUtil.getUserId(ServletActionContext.getRequest());
        String activityName="";
        if(StringUtils.isNotBlank(taskid)){
            activityName = sysTaskService.getActivity(sysTaskService.getTask(taskid).getActivityId()).getActivityName();
            String wiid = sysTaskService.getActivity(sysTaskService.getTask(taskid).getActivityId()).getWorkflowInstanceId();
            opinionType = workFlowDefineService.getWorkFlowDefine(workFlowInstanceService.getWorkflowInstance(wiid).getWorkflowDefinitionId()).getWorkflowName();
        }
        List<PfOpinionVo> lstOpinions= null;
        if(StringUtils.isNotBlank(activityName))
            lstOpinions=opinionService.getOpinionList(UserId,opinionType,activityName);
        else
            lstOpinions=opinionService.getOpinionList(UserId,opinionType);
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson(lstOpinions));
        return Action.NONE;
    }
    
    /**
     * 没有意见光是签名
     *
     * @return
     * @throws Exception
     */
    public String signno() throws Exception {
        sign();
        return "signno";
    }

    /**
     * 自动签名
     *
     * @return
     * @throws Exception
     */
    public String autosign() throws Exception {
        PfSignVo sign = signService.getSign(signVo.getSignId());
        if (sign != null) {
            sign.setSignOpinion(signVo.getSignOpinion());
            if (signVo.getSignDate() == null) {
            	signVo.setSignDate(Calendar.getInstance().getTime());
    		}
            sign.setSignDate(signVo.getSignDate());
            signService.updateAutoSign(sign);
            this.signVo = sign;
        } else {
            signService.insertAutoSign(this.signVo);
        }
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson(this.signVo));
        return Action.NONE;
    }

    /**
     * 签名保存
     *
     * @return
     * @throws Exception
     */
    public String savesign() throws Exception {
        PfSignVo sign = signService.getSign(signVo.getSignId());
        if (sign != null) {
            sign.setSignOpinion(signVo.getSignOpinion());
            if (signVo.getSignDate() == null) {
            	signVo.setSignDate(new Date(System.currentTimeMillis()));
    		}
            sign.setSignDate(signVo.getSignDate());
            sign.setSignType("0");
            signService.updateSign(sign);  //更新属性
            signService.UpdateCustomSignPic(signVo.getSignId(),signPoints);
            this.signVo = sign;
        } else {
            String signId=signService.AddCustomSign(SessionUtil.getCurrentUserId(),signVo.getProId(),signVo.getSignKey(),signPoints);
            signVo.setSignId(signId);
            signVo.setSignType("0");
            signService.updateSign(signVo);  //更新属性
        }
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson(signVo));
        return Action.NONE;
    }

    /**
     * 仅保存意见
     * @return
     * @throws Exception
     */
    public String saveSignOpinion() throws Exception {
        PfSignVo sign = signService.getSign(signVo.getSignId());
        if (sign == null) {
            signService.insertAutoSign(this.signVo);
        }
        sign.setSignOpinion(signVo.getSignOpinion());
        if (signVo.getSignDate() == null) {
        	signVo.setSignDate(Calendar.getInstance().getTime());
		}
        sign.setSignDate(signVo.getSignDate());
        signService.updateSign(this.signVo);
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson(signVo));
        return Action.NONE;
    }
    
    /**
     * 仅保存签名日期
     * @return
     * @throws Exception
     */
    public String saveSignDate() throws Exception {
        PfSignVo sign = signService.getSign(signVo.getSignId());
        if (sign == null) {
            signService.insertAutoSign(this.signVo);
        }
        if (signVo.getSignDate() == null) {
        	signVo.setSignDate(Calendar.getInstance().getTime());
		}
        sign.setSignDate(signVo.getSignDate());
        signService.updateSign(sign);
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson(signVo));
        return Action.NONE;
    }

    public String deleteSign() throws Exception {
        if (StringUtils.isNotBlank(signVo.getSignId())){
            signService.deleteSign(signVo.getSignId());
        }
        return Action.NONE;
    }
    


    public SysAuthorService getAuthorService() {
        return authorService;
    }

    public void setAuthorService(SysAuthorService authorService) {
        this.authorService = authorService;
    }

    public String getUseHandleOpinionPage() {
        return useHandleOpinionPage;
    }

    public void setUseHandleOpinionPage(String useHandleOpinionPage) {
        this.useHandleOpinionPage = useHandleOpinionPage;
    }

    public String getTaskid() {
        return taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public void setSysTaskService(SysTaskService sysTaskService) {
        this.sysTaskService = sysTaskService;
    }

    public boolean isSignUserCheck() {
        return signUserCheck;
    }

    public void setSignUserCheck(boolean signUserCheck) {
        this.signUserCheck = signUserCheck;
    }
}
