package com.gtis.web.old;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import javax.sql.DataSource;

import org.dom4j.Document;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.util.DataSourceManager;



public class FormFactory {
	private DataSource ds = null;

	public void setDs(DataSource ds) {
		this.ds = ds;
	}

	public DataSource getDs() {
		return this.ds;
	}
	
	/**
	 * 返回表单定义
	 * 
	 * @param dFId
	 * @param proId
	 * @return
	 */
	public  FormDefintion CreateFormDefintion(String dFId) {
		Connection con = null;
		ResultSet rs = null;
		Statement st = null;
		try {
			con = ds.getConnection();
			st = con.createStatement();
			String sql = "select FORM_DEFINITION_XLST xlst,FORM_DEFINITION_XML xml,FORM_DEFINITION_SHELL shell from PF_FORM_DEFINITION where FORM_DEFINITION_ID='" + dFId + "'";
			rs = st.executeQuery(sql);
			if (rs.next()) {
				Document xlstDoc =DbOperateUtil.getClobDocument(rs, "xlst"); 
				Document xmlDoc = DbOperateUtil.getClobDocument(rs, "xml");  
				Document xmlShell=DbOperateUtil.getClobDocument(rs, "shell");  
				FormDefintion formDefine = new FormDefintion(xlstDoc, xmlDoc,xmlShell,dFId);
				return formDefine;
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			DataSourceManager.attemptClose(rs);
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(con);
		}
		return null;
	}

	public FormDefintion CreateFormDefintionFromCode(String dFCode) {
		String sql = "select FORM_DEFINITION_ID dfid from PF_FORM_DEFINITION where FORM_DEFINITION_CODE='" + dFCode
				+ "'";
		String dFid=getDbStringValue(sql,"dfid");
		return CreateFormDefintion(dFid);
	}
	
	/**
	 * 根据表单定义和业务主键返回表单实例
	 * @param formDefine
	 * @param proId
	 * @return
	 */
	public FormInstance CreateFormInstance(FormDefintion formDefine, String proId) {
		FormInstance formInstace=null;
		Connection con = null;
		ResultSet rs = null;
		Statement st = null;
		Document doc=null;
		try {
			con = ds.getConnection();
			st = con.createStatement();
			rs = st
					.executeQuery("select EXTEND_ATTRIBUTE,EXTEND_DATASOURCE,EXTEND_TABLENAME,EXTEND_KEYFIELD,EXTEND_FORMFIELD from PF_FORM_DEFINITION t where FORM_DEFINITION_ID='"
							+ formDefine.getDfId() + "'");
			if (rs.next()) {
				String tblName,  tblkeyField,tblFieldForm,keyValue,dsName="";
				boolean isSave=false;
				if (rs.getString("EXTEND_ATTRIBUTE") != null && rs.getString("EXTEND_ATTRIBUTE").equals("1")) {
					if (rs.getString("EXTEND_DATASOURCE")!=null)
						dsName=rs.getString("EXTEND_DATASOURCE");
					tblName=rs.getString("EXTEND_TABLENAME");
					tblkeyField=rs.getString("EXTEND_KEYFIELD");
					tblFieldForm=rs.getString("EXTEND_FORMFIELD");
					keyValue=proId;
					if (tblFieldForm.equals("-1")){
						FormInstance4DataBase formDataBase=new FormInstance4DataBase(dsName, tblName, tblkeyField,keyValue);
						doc=formDataBase.getDocumentFromDataBase(formDefine);
						isSave=formDataBase.isSave();
					}else{
						String sql = "select t."+tblFieldForm+".getclobval() xml from "+tblName+" t where "+tblkeyField+"='" + keyValue + "'";
						doc = getDocument(sql, "xml");
						if (doc!=null) isSave=true;
					}
				} else {
					tblName="PF_FORM_INSTANCE";
					tblkeyField="FORM_INSTANCE_ID";
					tblFieldForm="FORM_INSTANCE_XML";
					String sql = "select FORM_INSTANCE_ID ifid from PF_FORM_INSTANCE where PRO_ID='" + proId + "' and FORM_DEFINITION_ID='" +formDefine.getDfId() + "'";
					keyValue=getDbStringValue(sql,"ifid");
					if (keyValue.equals("")) {
						keyValue=UUIDGenerator.generate();
						String innerSql = "insert into PF_FORM_INSTANCE(FORM_INSTANCE_ID,FORM_DEFINITION_ID,PRO_ID)";
						innerSql = innerSql + "values(?,?,?)";
						java.sql.PreparedStatement pstmt = con.prepareStatement(innerSql);
						pstmt.setString(1, keyValue);
						pstmt.setString(2, formDefine.getDfId());
						pstmt.setString(3, proId);
						pstmt.executeUpdate();
						DataSourceManager.attemptClose(pstmt);
					}
					sql = "select t."+tblFieldForm+".getclobval() xml from "+tblName+" t where "+tblkeyField+"='" + keyValue + "'";
					doc = getDocument(sql, "xml");
					if (doc!=null) isSave=true;
				}
				formInstace=new FormInstance(formDefine,tblName,tblkeyField,keyValue,tblFieldForm);
				formInstace.setDsName(dsName);
				formInstace.setSave(isSave);
				formInstace.setDocument(doc);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			DataSourceManager.attemptClose(rs);
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(con);
		}
		return formInstace;
	}
	/**
	 * 返回表单表实例
	 * 
	 * @param dFId
	 * @return
	 */
	public FormInstance CreateFormInstance(String dFId, String proId) {
		FormDefintion formDefine=CreateFormDefintion(dFId);
		return CreateFormInstance(formDefine,proId);
	
		
	}

	public FormInstance CreateFormInstanceFromCode(String dFCode, String proId) {
		FormDefintion formDefine=CreateFormDefintionFromCode(dFCode);
		return CreateFormInstance(formDefine,proId);
	}

	private Document getDocument(String sql, String fieldName) {
		Document doc = null;
		Connection con = null;
		ResultSet rs = null;
		Statement st = null;
		try {
			con = ds.getConnection();
			st = con.createStatement();
			rs = st.executeQuery(sql);
			if (rs.next()) {
				doc = DbOperateUtil.getClobDocument(rs, fieldName);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			DataSourceManager.attemptClose(rs);
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(con);
		}
		return doc;
	}
	
	private String getDbStringValue(String sql, String fieldName) {
		Connection con = null;
		ResultSet rs = null;
		Statement st = null;
		try {
			con = ds.getConnection();
			st = con.createStatement();
			rs = st.executeQuery(sql);
			if (rs.next()) {
				return rs.getString(fieldName);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			DataSourceManager.attemptClose(rs);
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(con);
		}
		return "";
	}
}
