package com.gtis.web.old;


import java.io.InputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;

import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import com.gtis.util.DataSourceManager;

import java.util.*;

import javax.sql.DataSource;

public class DbOperateUtil {

	private static final org.apache.commons.logging.Log log = LogFactory.getLog(DbOperateUtil.class);

	private DataSource ds = null;

	public void setDs(DataSource ds) {
		this.ds = ds;
	}

	public static String getString(ResultSet rs, String field) {
		try {
			if (rs.getString(field) != null) {
				return rs.getString(field);
			}
		} catch (Exception e) {
			log.error(e.getMessage());
		}
		return "";
	}

	public static String getCurDateString() {
		return getDateString(new Date());
	}

	public static String getDateString(ResultSet rs, String field) {
		try {
			if (rs.getDate(field) != null) {
				return getDateString(rs.getDate(field));
			}
		} catch (Exception e) {
			log.error(e.getMessage());
		}
		return "";
	}

	public static String getDateString(Date date) {
		java.util.Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		int month = cal.get(Calendar.MONTH) + 1;
		return cal.get(Calendar.YEAR) + "-" + month + "-" + cal.get(Calendar.DAY_OF_MONTH);
	}

	public static int getIntValue(ResultSet rs, String fieldName) {
		try {
			if (rs.getString(fieldName) != null)
				return rs.getInt(fieldName);
		} catch (Exception e) {

		}
		return 0;
	}

	public static Date getDateValue(ResultSet rs, String fieldName) {
		try {
			if (rs.getString(fieldName) != null) {
				SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
				java.util.Calendar cal = Calendar.getInstance();
				cal.setTime(df.parse(rs.getString(fieldName)));
				return cal.getTime();

				// return rs.getDate(fieldName);
			}
		} catch (Exception e) {

		}
		return null;
	}

	/**
	 * 返回resultset中clob的document对象（dom4j）
	 * 
	 * @param rs
	 *            resultset
	 * @param clobField
	 *            字段名
	 * @return Document（dom4j）
	 */
	public static Document getClobDocument(ResultSet rs, String clobField) throws Exception {
		Document doc = null;
//		InputStream in = null;
		try {
			SAXReader reader = new SAXReader();
			reader.setEncoding("utf-8");
			doc = reader.read(rs.getCharacterStream(clobField));
		} catch (Exception e) {
			// e.printStackTrace();
			// log.error("获取document错误！\n" + e.getMessage());
		}
		return doc;
	}

	public static Document getClobDocument(Clob clob) throws Exception {
		Document doc = null;
//		InputStream in = null;
		try {
			SAXReader reader = new SAXReader();
			reader.setEncoding("utf-8");
			doc = reader.read(clob.getCharacterStream());

		} catch (Exception e) {
			log.error("获取document错误！\n" + e.getMessage());
		}
		return doc;
	}

	public static String getEventString(String eventName, Clob clob) {
		String returnvalue = "";
		try {
			if (clob != null) {
				Document doc = DbOperateUtil.getClobDocument(clob);
				Node eventNode = doc.selectSingleNode("//Event[@name='" + eventName + "']");
				if (eventNode != null)
					returnvalue = eventNode.getText();
			} else {
				log.info("没有转发脚本可以执行！");
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		return returnvalue;

	}

	public HashMap getHashMap(String sql) {
		HashMap dataMap = new HashMap();
		Connection conn = null;
		ResultSet rs = null;
		Statement st = null;
		try {
			conn = ds.getConnection();
			st = conn.createStatement();
			rs = st.executeQuery(sql);
			if (rs.next()) {

				int colsize = rs.getMetaData().getColumnCount();
				for (int i = 1; i <= colsize; i++) {
					String colName = rs.getMetaData().getColumnName(i);
					colName = colName.toLowerCase();
					// int colType = rs.getMetaData().getColumnType(i);
					if (rs.getObject(i) != null) {
						Object value = rs.getObject(i);
						dataMap.put(colName, value);
					} else {
						dataMap.put(colName, "");
					}
				}

			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			DataSourceManager.attemptClose(rs);
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(conn);
		}
		return dataMap;
	}

	public List getHashMapList(String sql) {
		List lstData = new ArrayList();
		Connection conn = null;
		ResultSet rs = null;
		Statement st = null;
		try {
			conn = ds.getConnection();
			st = conn.createStatement();
			rs = st.executeQuery(sql);
			while (rs.next()) {
				HashMap dataMap = new HashMap();
				int colsize = rs.getMetaData().getColumnCount();
				for (int i = 1; i <= colsize; i++) {
					String colName = rs.getMetaData().getColumnName(i);
					colName = colName.toLowerCase();
					// int colType = rs.getMetaData().getColumnType(i);
					if (rs.getObject(i) != null) {
						Object value = rs.getObject(i);
						dataMap.put(colName, value);
					} else {
						dataMap.put(colName, "");
					}
				}
				lstData.add(dataMap);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			DataSourceManager.attemptClose(rs);
			DataSourceManager.attemptClose(st);
			DataSourceManager.attemptClose(conn);
		}
		return lstData;
	}
}
