package com.gtis.web.action.dzjc;

import com.gtis.plat.dao.SysDzjcDAO;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfSignVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.RiskModel;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 12-7-13
 * Time: 上午11:42
 * To change this template use File | Settings | File Templates.
 */
public class RiskAction extends AbstractPageAction {


    String aid;
    PfActivityVo activityVo;
    PfWorkFlowInstanceVo workFlowInstanceVo;
    private SysTaskService taskService;
    private SysActivityService activityService;
    private SysWorkFlowInstanceService workFlowIntanceService;
    private SysSignService signService;

    /** 风险点列表 */
    private List<RiskModel> riskList;

    SysDzjcDAO sysDzjcDAO;

    public void setSignService(SysSignService signService) {
        this.signService = signService;
    }

    public String getAid() {
        return aid;
    }

    public void setAid(String aid) {
        this.aid = aid;
    }

    public PfActivityVo getActivityVo() {
        return activityVo;
    }

    public PfWorkFlowInstanceVo getWorkFlowInstanceVo() {
        return workFlowInstanceVo;
    }

    public List<RiskModel> getRiskList() {
        return riskList;
    }

    public void setWorkFlowIntanceService(SysWorkFlowInstanceService workFlowIntanceService) {
        this.workFlowIntanceService = workFlowIntanceService;
    }

    public void setActivityService(SysActivityService activityService) {
        this.activityService = activityService;
    }

    public void setTaskService(SysTaskService taskService) {
        this.taskService = taskService;
    }

    public void setSysDzjcDAO(SysDzjcDAO sysDzjcDAO) {
        this.sysDzjcDAO = sysDzjcDAO;
    }



    public String execute() throws Exception {
        if (StringUtils.isNotBlank(aid)) {
            activityVo = taskService.getActivity(aid);
            workFlowInstanceVo = workFlowIntanceService.getWorkflowInstance(activityVo.getWorkflowInstanceId());
            WorkFlowXml xmlModel = WorkFlowXmlUtil.getInstanceModel(workFlowInstanceVo);
            ActivityModel aModel = xmlModel.getActivity(activityVo.getActivityDefinitionId());
            riskList = aModel.getRiskModelList();
        }
        return Action.SUCCESS;
    }

    /**
     * 判断该风险点是否确认
     * @return
     * @throws Exception
     */
    public String text() throws Exception {
        if (StringUtils.isNotBlank(aid)) {
            List<PfSignVo> signVoList= signService.getSignList(aid, null);
            if (signVoList!=null && signVoList.size()>0){
                ServletActionContext.getResponse().getWriter().println("已处理(" + signVoList.get(0).getSignName() + ")");
            }else{
                ServletActionContext.getResponse().getWriter().println("<font color=\"red\">未处理</font>");
            }
        }
        return Action.NONE;
    }


}
