package com.gtis.web.action.admin;

import com.gtis.plat.service.SysUserService;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;

/**
 * 用户管理
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/7
 */
public class UserAction {
    private SysUserService sysUserService;
    private SplitParam splitParam;

    public SysUserService getSysUserService() {
        return sysUserService;
    }

    public void setSysUserService(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    public String execute(){
        String regionCode = SessionUtil.getCurrentUser().getRegionCode();
        if(StringUtils.isBlank(regionCode))
            regionCode="-99";
        SplitParamImpl splitParam1 = new SplitParamImpl();

        HashMap params = new HashMap();
        params.put("REGION_CODE", regionCode);
        splitParam1.setQueryParam(params);

        splitParam1.setQueryString("getUserListByRegionCode");
        splitParam = splitParam1;
        return Action.SUCCESS;
    }

    public String deleteUser(){
        return Action.NONE;
    }

    public String saveUser(){
        return Action.NONE;
    }

    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }
}
