package com.gtis.web.action.admin;

import com.gtis.plat.service.SysOrganService;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/7
 */
public class OrganAction {
    private SysOrganService sysOrganService;
    private SplitParam splitParam;

    public SysOrganService getSysOrganService() {
        return sysOrganService;
    }

    public void setSysOrganService(SysOrganService sysOrganService) {
        this.sysOrganService = sysOrganService;
    }

    public String execute(){
        SplitParamImpl splitParam1 = new SplitParamImpl();
        if(SessionUtil.getCurrentUser().isAdmin())
            splitParam1.setQueryString("getOrganList");
        else{
            String regionCode = SessionUtil.getCurrentUser().getRegionCode();
            if(StringUtils.isBlank(regionCode))
                regionCode="-99";
            splitParam1.setQueryString("getOrganByRegionCode");
            HashMap params = new HashMap();
            params.put("REGION_CODE",regionCode);
            splitParam1.setQueryParam(params);
        }
        splitParam = splitParam1;
        return Action.SUCCESS;
    }

    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }
}
