package com.gtis.web.action;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

import javax.servlet.http.HttpServletResponse;

import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.impl.SysUserServiceImpl;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfTaskAgentVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;

public class TaskAgentListAction implements Action,ServletResponseAware{
	
	/**
	 * ajax-response
	 */
	private HttpServletResponse response;
	private SplitParam splitParam;
	/** 用户服务 */
	private SysUserServiceImpl userService;
	/**工作流服务*/
	private SysWorkFlowDefineService workFlowDefineService;
	/** 任务代理对象 */
	private PfTaskAgentVo pfTaskAgentVo;
	/**部门对象*/
	private PfOrganVo organVo;
	//采用request传递参数
	private String userId;
	private String workFlowDefinitionId;
	private String activityDefinitionId;
	private String beginTime;
	private String endTime;
	private String remark;
	private String taskAgentId;
    private int agentType;

	//节点id
	private String pfTaskAgentVo_activityId;
	//流程id
	private String pfTaskAgentVo_wokeflowDefineId;

	public String execute() throws Exception {
		UserInfo userInfo = SessionUtil.getUserInfo(ServletActionContext.getRequest());
		splitParam = new SplitParamImpl();
		splitParam.setQueryString("getAgentList");
		HashMap<String, String> mapParam = new HashMap<String, String>();
		if(!userInfo.isAdmin()){
			mapParam.put("agentUserId", userInfo.getId());
		}
		splitParam.setQueryParam(mapParam);
		return Action.SUCCESS;
	}
	
	/**
	 * 删除任务代理
	 * @throws Exception
	 * @return
	 */
	public String delete() throws Exception{
		if(StringUtils.isNotEmpty(pfTaskAgentVo.getTaskAgentId())){
			userService.deleteTaskAgent(pfTaskAgentVo.getTaskAgentId());
		}

		return null;
	}
	
	/**
	 * 终止代理
	 * taskAgentId
	 */
	public String stopAgent() throws Exception{
		HashMap<String, String> map=new HashMap<String, String>();
		String msg="终止代理失败！";
		if(StringUtils.isNotEmpty(pfTaskAgentVo.getTaskAgentId())){
			//userService.stopTaskAgent(pfTaskAgentVo.getTaskAgentId());
            userService.deleteTaskAgent(pfTaskAgentVo.getTaskAgentId());
			msg="终止代理成功！";
		}
		map.put("msg", msg);
    	ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(map));
		return null;
	}

	 /**
     * 获取部门选择框的数据
     * @return
     * @throws Exception
     */
    public String getOrganData() throws Exception{
    	List<PfOrganVo> organList=userService.getOrganList();

    	List<HashMap<String, String>> mapList=new ArrayList<HashMap<String,String>>();
    	for(PfOrganVo pfOrganVo:organList){
    		HashMap<String, String> map=new HashMap<String, String>();
    		map.put("value", pfOrganVo.getOrganId());
    		map.put("text", pfOrganVo.getOrganName());
    		mapList.add(map);
    	}

    	ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(mapList));

		return Action.NONE;
    }

    /**
     * 获取用户选择框的数据
     * @return
     * @throws Exception
     */
    public String getUserData() throws Exception{
    	List<PfUserVo> userList=userService.getUserListByOragn(organVo.getOrganId());

    	List<HashMap<String, String>> mapList=new ArrayList<HashMap<String,String>>();
    	for(PfUserVo pfUserVo:userList){
    		HashMap<String, String> map=new HashMap<String, String>();
    		map.put("value", pfUserVo.getUserId());
    		map.put("text", pfUserVo.getUserName());
    		mapList.add(map);
    	}

    	ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(mapList));

		return Action.NONE;
    }

    
    

    /**
     * 获取代理任务选择框的数据
     * @return
     * @throws Exception
     */
    public String getWorkflowDefinitionData() throws Exception{
    	List<PfWorkFlowDefineVo> workflowDefineList=workFlowDefineService.getWorkFlowDefineList();

    	List<HashMap<String, String>> mapList=new ArrayList<HashMap<String,String>>();
    	for(PfWorkFlowDefineVo pfWorkFlowDefineVo:workflowDefineList){
    		HashMap<String, String> map=new HashMap<String, String>();
    		map.put("value", pfWorkFlowDefineVo.getWorkflowDefinitionId());
    		map.put("text", pfWorkFlowDefineVo.getWorkflowName());
    		mapList.add(map);
    	}

    	ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(mapList));

		return Action.NONE;
    }

    /**
     * 获得工作流活动Id
     * @return
     * @throws Exception
     */
    public String getActivityData() throws Exception{
        PfWorkFlowDefineVo workFlowDefine = workFlowDefineService.getWorkFlowDefine(pfTaskAgentVo.getWorkFlowDefinitionId());
        WorkFlowXml workFlowXml = WorkFlowXmlUtil.getDefineModel(workFlowDefine);
        List<ActivityModel> activityList = workFlowXml.getActivityList();
        List<HashMap> mapList = new ArrayList<HashMap>();
        for(ActivityModel mode:activityList){
            HashMap map = new HashMap();
            map.put("activityId",mode.getDefineId());
            map.put("activityName",mode.getActivityDefineName());
            mapList.add(map);
        }

        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(mapList));
        
        return Action.NONE;
    }
    
	/**
	 * 保存任务代理
     * (info 0：信息不完全 1：添加成功 2：信息更新)
	 * @return
	 * @throws Exception
	 */
	public String save() throws Exception {
		HashMap<String,String> resultObj=new HashMap<String,String>();
        int info = 0;
        
        if(StringUtils.isBlank(this.taskAgentId)){
        	pfTaskAgentVo=new PfTaskAgentVo();
            if(StringUtils.isNotBlank(this.userId)
                    && (this.beginTime != null&&!(this.beginTime.equals("")))
                    &&(this.endTime != null&&!(this.beginTime.equals("")))){
            	if(this.workFlowDefinitionId!=null&&!(this.workFlowDefinitionId.equals(""))){
	            	String[] workFlowDefinitionIdArry=this.workFlowDefinitionId.split(",");
	            	for(String wokeflowDefinitionIdTemp:workFlowDefinitionIdArry){
	            		pfTaskAgentVo.setTaskAgentId(UUIDGenerator.generate());
	                    pfTaskAgentVo.setActivityDefinitionId(this.activityDefinitionId);
	                    pfTaskAgentVo.setAgentUserId(SessionUtil.getUserId(ServletActionContext.getRequest()));
	                    if(this.beginTime.length()>0){
	                    	pfTaskAgentVo.setBeginTime(DateFormat.getDateTimeInstance().parse(this.beginTime));
	                    }
	                    if(this.endTime.length()>0){
	                    	pfTaskAgentVo.setEndTime(DateFormat.getDateTimeInstance().parse(this.endTime));
	                    }
	                    pfTaskAgentVo.setRemark(this.remark);
	                    pfTaskAgentVo.setUserId(this.userId);
	                    pfTaskAgentVo.setWorkFlowDefinitionId(wokeflowDefinitionIdTemp);
                        pfTaskAgentVo.setAgentType(this.agentType);
	                    userService.insertTaskAgent(pfTaskAgentVo);
	            	} 
            	}else{
            		pfTaskAgentVo.setTaskAgentId(UUIDGenerator.generate());
                    pfTaskAgentVo.setActivityDefinitionId(this.activityDefinitionId);
                    pfTaskAgentVo.setAgentUserId(SessionUtil.getUserId(ServletActionContext.getRequest()));
                    if(this.beginTime.length()>0){
                    	pfTaskAgentVo.setBeginTime(DateFormat.getDateTimeInstance().parse(this.beginTime));
                    }
                    if(this.endTime.length()>0){
                    	pfTaskAgentVo.setEndTime(DateFormat.getDateTimeInstance().parse(this.endTime));
                    }
                    pfTaskAgentVo.setRemark(this.remark);
                    pfTaskAgentVo.setUserId(this.userId);
                    pfTaskAgentVo.setWorkFlowDefinitionId(this.workFlowDefinitionId);
                    pfTaskAgentVo.setAgentType(this.agentType);
                    userService.insertTaskAgent(pfTaskAgentVo);
            	}
                info = 1;
            }else {
                info = 0;
            }
        }else {
        	  if(StringUtils.isNotBlank(this.userId)
                      && (this.beginTime != null)
                      &&(this.endTime != null)){
                  pfTaskAgentVo=userService.getTaskAgent(this.taskAgentId);
                  pfTaskAgentVo.setActivityDefinitionId(this.activityDefinitionId);
                  pfTaskAgentVo.setAgentUserId(SessionUtil.getUserId(ServletActionContext.getRequest()));
                  if(this.beginTime.length()>0){
                  	pfTaskAgentVo.setBeginTime(DateFormat.getDateInstance().parse(this.beginTime));
                  }
                  if(this.endTime.length()>0){
                  	pfTaskAgentVo.setEndTime(DateFormat.getDateInstance().parse(this.endTime));
                  }
                  pfTaskAgentVo.setRemark(this.remark);
                  pfTaskAgentVo.setUserId(this.userId);
                  pfTaskAgentVo.setWorkFlowDefinitionId(this.workFlowDefinitionId);
                  pfTaskAgentVo.setAgentType(this.agentType);
                  userService.updateTaskAgent(pfTaskAgentVo);
                  info = 2;
              }else {
                  info = 0;
              }
        }
        response.setContentType("text/html;charset=utf-8");
		PrintWriter out = response.getWriter();
		resultObj.put("msg", info+"");
		out.println(JSONUtil.serialize(resultObj));
		out.flush();
		out.close();	
//        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
//		ServletActionContext.getResponse().getWriter().println(info);

		return  Action.NONE;
	}

	public String getTaskAgent() throws Exception, JSONException{
		List<PfTaskAgentVo> resultList = new Vector<PfTaskAgentVo>();
		PfTaskAgentVo pfTaskAgentVoTemp =userService.getTaskAgent(this.taskAgentId);
        pfTaskAgentVoTemp=(PfTaskAgentVo)BeanUtils.cloneBean(pfTaskAgentVoTemp);
		PfUserVo pfUserVo=userService.getUserVo(pfTaskAgentVoTemp.getUserId());
		pfTaskAgentVoTemp.setUserId(pfTaskAgentVoTemp.getUserId()+","+pfUserVo.getUserName());
		
//		List<PfOrganVo> organList=userService.getOrganList();
//    	for(PfOrganVo pfOrganVo:organList){
//    		List<PfUserVo> pfUserList=userService.getUserListByOragn(pfOrganVo.getOrganId());
//    		for(PfUserVo pfUser:pfUserList){
//    			if(pfUser.getUserId().equals(pfUserVo.getUserId())){
//    				organName=pfOrganVo.getOrganName();
//    				break;
//    			}
//    		}
//    	}
		
//		PfWorkFlowDefineVo workFlowDefine = workFlowDefineService.getWorkFlowDefine(pfTaskAgentVoTemp.getWorkFlowDefinitionId());
//        WorkFlowXml workFlowXml = WorkFlowXmlUtil.getDefineModel(workFlowDefine);
//        List<ActivityModel> activityList = workFlowXml.getActivityList();
//        for(ActivityModel mode:activityList){
//        	if(mode.getDefineId().equals(pfTaskAgentVoTemp.getActivityDefinitionId())){
//        		pfTaskAgentVoTemp.setActivityDefinitionId(pfTaskAgentVoTemp.getActivityDefinitionId()+","+mode.getActivityDefineName());
//        		break;
//        	}
//        }
        
		List<PfWorkFlowDefineVo> workflowDefineList=workFlowDefineService.getWorkFlowDefineList();
    	for(PfWorkFlowDefineVo pfWorkFlowDefineVo:workflowDefineList){
    		if(pfTaskAgentVoTemp.getWorkFlowDefinitionId()==null||pfTaskAgentVoTemp.getWorkFlowDefinitionId().equals("")){
    			pfTaskAgentVoTemp.setWorkFlowDefinitionId("11111111111111111111111111111111,全部流程");
    			break;
    		}
    		if(pfWorkFlowDefineVo.getWorkflowDefinitionId().equals(pfTaskAgentVoTemp.getWorkFlowDefinitionId())){
    			pfTaskAgentVoTemp.setWorkFlowDefinitionId(pfTaskAgentVoTemp.getWorkFlowDefinitionId()+","+pfWorkFlowDefineVo.getWorkflowName());
    			break;
    		}
    	}
		

		resultList.add(pfTaskAgentVoTemp);
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(
				JSONUtil.serialize(resultList));
		return Action.NONE;
	}
	
	/**
	 * 根据activityId获取节点名称
	 * pfTaskAgentVo_activityId
	 * @return
	 * @throws JSONException 
	 * @throws IOException 
	 */
	public String getActivityName() throws IOException, JSONException{
		PfWorkFlowDefineVo workFlowDefine = workFlowDefineService.getWorkFlowDefine(this.pfTaskAgentVo_wokeflowDefineId);
        WorkFlowXml workFlowXml = WorkFlowXmlUtil.getDefineModel(workFlowDefine);
        List<ActivityModel> activityList = workFlowXml.getActivityList();
        HashMap map = new HashMap();
        for(ActivityModel mode:activityList){
        	if(mode.getDefineId().equals(this.pfTaskAgentVo_activityId)){
        		map.put("msg", mode.getActivityDefineName());
        		break;
        	}
        }

        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(map));
        
        return Action.NONE;
	}
	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public SysUserServiceImpl getUserService() {
		return userService;
	}

	public void setUserService(SysUserServiceImpl userService) {
		this.userService = userService;
	}

	public PfTaskAgentVo getPfTaskAgentVo() {
		return pfTaskAgentVo;
	}

	public void setPfTaskAgentVo(PfTaskAgentVo pfTaskAgentVo) {
		this.pfTaskAgentVo = pfTaskAgentVo;
	}

	public PfOrganVo getOrganVo() {
		return organVo;
	}

	public void setOrganVo(PfOrganVo organVo) {
		this.organVo = organVo;
	}

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getWorkFlowDefinitionId() {
		return workFlowDefinitionId;
	}

	public void setWorkFlowDefinitionId(String workFlowDefinitionId) {
		this.workFlowDefinitionId = workFlowDefinitionId;
	}
	public String getActivityDefinitionId() {
		return activityDefinitionId;
	}

	public void setActivityDefinitionId(String activityDefinitionId) {
		this.activityDefinitionId = activityDefinitionId;
	}

	public String getBeginTime() {
		return beginTime;
	}

	public void setBeginTime(String beginTime) {
		this.beginTime = beginTime;
	}

	public String getEndTime() {
		return endTime;
	}

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getTaskAgentId() {
		return taskAgentId;
	}

	public void setTaskAgentId(String taskAgentId) {
		this.taskAgentId = taskAgentId;
	}



	public void setServletResponse(HttpServletResponse response) {
		// TODO Auto-generated method stub
		this.response=response;
	}



	public String getPfTaskAgentVo_activityId() {
		return pfTaskAgentVo_activityId;
	}



	public void setPfTaskAgentVo_activityId(String pfTaskAgentVo_activityId) {
		this.pfTaskAgentVo_activityId = pfTaskAgentVo_activityId;
	}



	public String getPfTaskAgentVo_wokeflowDefineId() {
		return pfTaskAgentVo_wokeflowDefineId;
	}

    public int getAgentType() {
        return agentType;
    }

    public void setAgentType(int agentType) {
        this.agentType = agentType;
    }

    public void setPfTaskAgentVo_wokeflowDefineId(
			String pfTaskAgentVo_wokeflowDefineId) {
		this.pfTaskAgentVo_wokeflowDefineId = pfTaskAgentVo_wokeflowDefineId;
	}

}