package com.gtis.web.action;

import com.gtis.common.util.ObjectJSONUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.service.SysOpinionService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.PfOpinionVo;
import com.gtis.plat.wf.WorkFlowXml;
import com.gtis.plat.wf.WorkFlowXmlUtil;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;

import java.util.*;


/**
 * 默认意见维护
 * @author nono
 *
 */
public class SysOpinionAction {
	private SysOpinionService opinionService;
    /** 工作流定义服务 */
	private SysWorkFlowDefineService workFlowDefineService;
    
	private SplitParam splitParam;
	
	private PfOpinionVo pfOpinionVo;

	private String opinIdlist;
    /** 工作流对象列表 */
    private List lstWorkFlowDefine;
    /** 是否可用 */
	private LinkedHashMap<String, String> isUseMap;

    private String wdid;

    private String opinType;
    
	protected Log log = LogFactory.getLog(getClass());

    public void setOpinType(String opinType) {
        this.opinType = opinType;
    }

    public String execute() throws Exception {
		
		String UserId = SessionUtil.getUserId(ServletActionContext.getRequest());
		
		SplitParamImpl splitParam1 = new SplitParamImpl();
		
		splitParam1.setQueryString("opinionlist");
		
		HashMap<String, String> omap = new HashMap<String, String>();
		
		omap.put("USER_ID", UserId);
		
		splitParam1.setQueryParam(omap);
		
		splitParam = splitParam1;
		
		return Action.SUCCESS;
	}

    public String menu() throws Exception{
        String UserId = SessionUtil.getUserId(ServletActionContext.getRequest());
        List<PfOpinionVo> lstOpinions=opinionService.getOpinionList(UserId,opinType);
        ServletActionContext.getResponse().getWriter().print(ObjectJSONUtil.ObjectToJson(lstOpinions));
        return Action.NONE;
    }
    
	public String loadpage(){
	    lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineList();

		isUseMap = new LinkedHashMap<String, String>();
		isUseMap.put("1", "可用");
		isUseMap.put("0", "不可用");
        
		return "newpage";
	}
	
	public String add() throws Exception{
        pfOpinionVo.setOpinType(workFlowDefineService.getWorkFlowDefine(pfOpinionVo.getOpinType()).getWorkflowName());
        if(StringUtils.isBlank(pfOpinionVo.getOpinId())){
            pfOpinionVo.setOpinId(UUIDGenerator.generate());
            pfOpinionVo.setOpinUserId(SessionUtil.getUserId(ServletActionContext.getRequest()));
		    opinionService.insertOpinion(pfOpinionVo);
        }else {
            opinionService.updateOpinion(pfOpinionVo);
        }

        return Action.NONE;
	}
	
	public String view() throws Exception{
		pfOpinionVo = opinionService.getOpinionByOpinId(pfOpinionVo.getOpinId());
        
		return loadpage();
	}
	
	public String updateIsUse() throws Exception{
		if(StringUtils.isNotBlank(opinIdlist)){
		    String[] arropinId = opinIdlist.split(";");
		    for(int i=0;i<arropinId.length;i++){
			    HashMap<String, String> map = new HashMap<String, String>();
			    map.put("OPIN_ID", arropinId[i]);
			    map.put("ISUSE", pfOpinionVo.getOpinIsUse());
			    opinionService.updateIsUseByOpinId(map);
		    }
		}
	    return  Action.NONE;
	}


	public String getOpinionList() throws Exception{
		String UserId = SessionUtil.getUserId(ServletActionContext.getRequest());
		List<PfOpinionVo> opinList = new ArrayList<PfOpinionVo>();
		opinList = opinionService.getOpinionList(UserId);
		List<String> list = new ArrayList<String>();
		for (Iterator<PfOpinionVo> it = opinList.iterator();it.hasNext();){
			PfOpinionVo vo=it.next();
			list.add(vo.getOpinContent());
		}
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(list));
		
		return Action.NONE;
	}

    /**
     * 删除默认意见
     * @return
     * @throws Exception
     */
	public String delete() throws Exception{
		if(StringUtils.isNotBlank(pfOpinionVo.getOpinId())){
		  opinionService.deleteOpinion(pfOpinionVo.getOpinId());
		}
		return Action.NONE;
	}

    public String getWorkflowActivities() throws Exception{
        WorkFlowXml xmlDao = WorkFlowXmlUtil.getDefineModel(workFlowDefineService.getWorkFlowDefine(wdid));
        List<ActivityModel> activityModels = xmlDao.getActivityList();
        Map<String,String> activitiesMap = new HashMap<String, String>();
        for(ActivityModel activityModel:activityModels){
            activitiesMap.put(activityModel.getDefineId(),activityModel.getActivityDefineName());
        }
        Struts2Utils.renderJson(activitiesMap);
        return Action.NONE;
    }

	public SysOpinionService getOpinionService() {
		return opinionService;
	}

	public void setOpinionService(SysOpinionService opinionService) {
		this.opinionService = opinionService;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public PfOpinionVo getPfOpinionVo() {
		return pfOpinionVo;
	}

	public void setPfOpinionVo(PfOpinionVo pfOpinionVo) {
		this.pfOpinionVo = pfOpinionVo;
	}
    
	public String getOpinIdlist() {
		return opinIdlist;
	}

	public void setOpinIdlist(String opinIdlist) {
		this.opinIdlist = opinIdlist;
	}

	public LinkedHashMap<String, String> getIsUseMap() {
		return isUseMap;
	}

	public void setIsUseMap(LinkedHashMap<String, String> isUseMap) {
		this.isUseMap = isUseMap;
	}

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public List getLstWorkFlowDefine() {
        return lstWorkFlowDefine;
    }

    public String getWdid() {
        return wdid;
    }

    public void setWdid(String wdid) {
        this.wdid = wdid;
    }


}
