package com.gtis.web.action;

import java.io.Reader;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import org.apache.struts2.json.JSONUtil;

import com.gtis.common.util.CommonUtil;
import com.gtis.plat.service.SysExceptionService;
import com.gtis.plat.service.SysSupervisorService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.vo.EcExceptionVo;
import com.gtis.plat.vo.EcSupervisorVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.opensymphony.xwork2.ActionSupport;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;

public class SuperviseExceptionAction extends ActionSupport {
	private static final long serialVersionUID = -1332406189603283039L;
	
	private SysExceptionService exceService;

	private SysSupervisorService supervisorService;
	
	private SysWorkFlowDefineService workFlowDefineService;
	
	private SplitParam splitParam;
	
	private EcExceptionVo exceptionVo;
	private EcSupervisorVo supervisorVo;
	
	List<PfWorkFlowDefineVo> lstWorkFlowDefine;
	
	private String currentUserId;
	
	public String execute() throws Exception {
		SplitParamImpl splitParamImpl = new SplitParamImpl();
		splitParamImpl.setQueryString("queryProjectList");
		splitParam = splitParamImpl;
		lstWorkFlowDefine = workFlowDefineService.getWorkFlowDefineList();

		if(lstWorkFlowDefine.size()>0&&StringUtils.isNotBlank(lstWorkFlowDefine.get(0).getWorkflowDefinitionId())) {
			PfWorkFlowDefineVo vo=new PfWorkFlowDefineVo();
			vo.setWorkflowName("----所有业务----");
			vo.setWorkflowDefinitionId("");
			lstWorkFlowDefine.add(0, vo);
		}
		currentUserId = SessionUtil.getUserId(ServletActionContext.getRequest());
		
		return Action.SUCCESS;
	}
	
	@SuppressWarnings("unchecked")
	public String updateExceptionStatus() throws Exception{
		HashMap paramMap = new HashMap();
		paramMap.put("CHECK_INFO", exceptionVo.getCheckInfo());
		paramMap.put("CHECK_TIME", new Date(System.currentTimeMillis()));
		paramMap.put("EXCEPTION_ID", exceptionVo.getExceptionId());
		paramMap.put("IS_SURE", exceptionVo.getIsSure());
		paramMap.put("CHECK_USER_ID",SessionUtil.getUserId(ServletActionContext.getRequest()));
		exceService.updateExceptionStatus(paramMap);
		
		return Action.NONE;
	}
	
	public String overProjectList() throws Exception {
		SplitParamImpl splitParamImpl = new SplitParamImpl();
		splitParamImpl.setQueryString("queryOverProjectList");
		splitParam = splitParamImpl;
		lstWorkFlowDefine = workFlowDefineService.getECWorkFlowDefineList();
		PfWorkFlowDefineVo vo=new PfWorkFlowDefineVo();
		vo.setWorkflowName("----所有业务----");
		vo.setWorkflowDefinitionId("");
		lstWorkFlowDefine.add(0, vo);
		
		currentUserId = SessionUtil.getUserId(ServletActionContext.getRequest());
		
		return "overProjectList";
	}
	
	public String exceptionDetail() throws Exception{
		List<HashMap> mapList = exceService.getActivityExceptionList(exceptionVo.getWorkflowInstanceId());
		HashMap<String,HashMap> activityInfo = new HashMap<String,HashMap>();
		HashMap<String,HashSet<String>> activityUsers = new HashMap<String,HashSet<String>>();
		List<HashMap<String,Object>> resultList = new ArrayList<HashMap<String,Object>>();
		for(HashMap map : mapList){
			String activityId = map.get("ACTIVITY_ID").toString();
			if(activityUsers.get(activityId) == null){
				HashSet<String> userNameSet = new HashSet<String>();
				userNameSet.add(map.get("USER_NAME").toString());
				activityUsers.put(activityId,userNameSet);
			}else {
				HashSet<String> userNameSet = activityUsers.get(activityId);
				userNameSet.add(map.get("USER_NAME").toString());
				activityUsers.put(activityId,userNameSet);
			}
			
			HashMap<String,Object> temp =  new HashMap<String,Object>();
			temp.put("WORKFLOW_INSTANCE_ID", map.get("WORKFLOW_INSTANCE_ID"));
			temp.put("ACTIVITY_ID", map.get("ACTIVITY_ID"));
			temp.put("ACTIVITY_NAME", map.get("ACTIVITY_NAME"));
			temp.put("EXC1", map.get("EXC1"));
			temp.put("EXC3", map.get("EXC3"));
			temp.put("EXC4", map.get("EXC4"));
			temp.put("EXC5", map.get("EXC5"));
			temp.put("BEGIN_TIME",map.get("BEGIN_TIME"));
			temp.put("FINISH_TIME",map.get("FINISH_TIME"));
			int timeUsered = Integer.parseInt(map.get("TIME_USERED").toString());
			int timeLimit = Integer.parseInt(map.get("TIME_LIMIT").toString());
			temp.put("TIME_USERED",map.get("TIME_USERED"));
			temp.put("TIME_LIMIT", map.get("TIME_LIMIT"));
			temp.put("ACTIVITY_RESIDUAL", timeLimit - timeUsered);
			activityInfo.put(activityId,temp);
		}
		
		Set<Map.Entry<String, HashSet<String>>> entrySet = activityUsers.entrySet();
		for(Map.Entry<String, HashSet<String>> mapEntry: entrySet){
			String activityId = mapEntry.getKey();
			HashSet<String> hashSet = mapEntry.getValue();
			
			StringBuffer sb = new StringBuffer();
			Iterator<String> iter = hashSet.iterator();
			for (int i = 0; iter.hasNext(); i++) {
				if (i != 0) {
					sb.append(",");
				}
				sb.append(iter.next());
			}
			String users = sb.toString();
			HashMap<String,Object> activityInfoHashMap = activityInfo.get(activityId);
			activityInfoHashMap.put("USER_NAME", users);
			resultList.add(activityInfoHashMap);
		}
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(resultList));
		
		return Action.NONE;
	}
	
	public String exceptionList() throws Exception{
		List<HashMap> mapList = null;
		if(exceptionVo != null){
			mapList = exceService.getEcExceptionList(exceptionVo.getWorkflowInstanceId(), exceptionVo.getActivityId(), exceptionVo.getExceptionType(), exceptionVo.getUserId());
		}
		
		SAXReader reader = new SAXReader();
		
		for(HashMap map : mapList){
			int exceptionType = Integer.parseInt((map.get("EXCEPTION_TYPE").toString()));
			String exceptionRecTime = CommonUtil.formateDate((Date)map.get("EXCEPTION_REC_TIME"));
			
			if(map.get("DESC_XML") != null){
				String userName = map.get("USER_NAME") == null ? "" : map.get("USER_NAME").toString();
				String activityName = map.get("ACTIVITY_NAME") == null ? "" : map.get("ACTIVITY_NAME").toString();
				
				Clob descXmlClob = (Clob) map.get("DESC_XML");
				Reader descXmlReader = descXmlClob.getCharacterStream();
				Document document = reader.read(descXmlReader);
				Element descDocument = document.getRootElement();// 得到根节点
				StringBuilder strBuilder = new StringBuilder();
				if(exceptionType == 1){
					String timeLimit = descDocument.attributeValue("time_limit");
					String beginTime = descDocument.attributeValue("begin_time");
					String over_time = descDocument.attributeValue("over_time");
					
					strBuilder.append(userName);
					strBuilder.append("于");
					strBuilder.append(beginTime);
					strBuilder.append("接收到“");
					strBuilder.append(activityName);
					strBuilder.append("”办理，活动限时");
					strBuilder.append(formatTimeLimit(timeLimit));
					strBuilder.append("，活动办理截止日期");
					strBuilder.append(over_time);
					strBuilder.append("，活动办理超期");
				}else if(exceptionType == 2){
					String beginTime = descDocument.attributeValue("begin_time");
					String timeLimit = descDocument.attributeValue("time_limit");
					String over_time = descDocument.attributeValue("over_time");
					
					strBuilder.append("本项目于");
					strBuilder.append(beginTime);
					strBuilder.append("开始办理，项目限时");
					strBuilder.append(formatTimeLimit(timeLimit));
					strBuilder.append("，项目办理截止日期");
					strBuilder.append(over_time);
					strBuilder.append("，项目办理超期");
				}else if(exceptionType == 3){
					String beginTime = descDocument.attributeValue("backtimes");
					strBuilder.append("本活动被打回");
					strBuilder.append(beginTime);
					strBuilder.append("次，超过了允许的范围。");
				}else if(exceptionType == 4){
					strBuilder.append("该活动出现了挂起异常。");
				}else if(exceptionType == 5){
					String needFee = descDocument.attributeValue("needfee");
					String getFree = descDocument.attributeValue("getfee");
					strBuilder.append("本项目应收费");
					strBuilder.append(needFee);
					strBuilder.append("，实收费");
					strBuilder.append(getFree);
					strBuilder.append("。");
				}else if(exceptionType == 6){
					strBuilder.append("该活动发生挂起异常。");
				}else if(exceptionType == 7){
					String id = descDocument.attributeValue("id");
					strBuilder.append(id);
				}else if(exceptionType == 8){
					strBuilder.append("无");
				}
				map.put("DESC_XML", strBuilder.toString());
			}
		}
		
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(mapList));
		return Action.NONE;
	}
	
	public String revertSuperviseExplain() throws Exception{
		boolean isUpdate = supervisorService.updateSuperviseExplain(supervisorVo);
		
		HashMap hashMap = new HashMap();
		hashMap.put("revertResult", isUpdate);
		
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(hashMap));
		
		return Action.NONE;
	}

	private String formatTimeLimit(String timeLimit){
		if(StringUtils.isBlank(timeLimit))
			return "";
		else{
			String formattedTimeLimit = timeLimit.indexOf("t")>-1?timeLimit.substring(0,timeLimit.indexOf("t")).concat("小时"):timeLimit.concat("天");
			return formattedTimeLimit;
		}
	}
	
	public SysSupervisorService getSupervisorService() {
		return supervisorService;
	}

	public void setSupervisorService(SysSupervisorService supervisorService) {
		this.supervisorService = supervisorService;
	}
	
	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

	public List<PfWorkFlowDefineVo> getLstWorkFlowDefine() {
		return lstWorkFlowDefine;
	}

	public void setLstWorkFlowDefine(List<PfWorkFlowDefineVo> lstWorkFlowDefine) {
		this.lstWorkFlowDefine = lstWorkFlowDefine;
	}

	public EcExceptionVo getExceptionVo() {
		return exceptionVo;
	}

	public void setExceptionVo(EcExceptionVo exceptionVo) {
		this.exceptionVo = exceptionVo;
	}

	public EcSupervisorVo getSupervisorVo() {
		return supervisorVo;
	}

	public void setSupervisorVo(EcSupervisorVo supervisorVo) {
		this.supervisorVo = supervisorVo;
	}

	public String getCurrentUserId() {
		return currentUserId;
	}

	public void setCurrentUserId(String currentUserId) {
		this.currentUserId = currentUserId;
	}

	public SysExceptionService getExceService() {
		return exceService;
	}

	public void setExceService(SysExceptionService exceService) {
		this.exceService = exceService;
	}
}
