package com.gtis.web.action;

import com.gtis.plat.dao.SysWorkFlowInstanceDao;
import com.gtis.plat.service.SysSmsService;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfSmsVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.web.SessionUtil;

import com.gtis.web.split.SplitParam;
import com.gtis.web.split.SplitParamImpl;
import com.opensymphony.xwork2.Action;
import com.opensymphony.xwork2.ActionSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.*;
import java.util.regex.Pattern;

/**
 * @(#)SysMsgServiceImpl.java 2010-4-6 1:03:52
 * Copy Right Information	: 南京国图
 * Project 					: 短信发送
 * JDK version used		    : jdk1.5.0_20
 * Comments					:
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class SmsManageAction extends ActionSupport implements ServletResponseAware,ServletRequestAware {

	private static final long serialVersionUID = 5021171822531621176L;
    /** 用户服务 */
	private SysUserService userService;
    /** 短信服务 */
    private SysSmsService smsService;
    /** 短息 */
    private PfSmsVo smsVo;
    /** 已有号码人员 */
    private String userIds;
    /** 零时号码 */
    private String newNos;
    /** 列表对象 */
    private SplitParam splitParam;
    /** 状态信息 */
    private String message;
    /** 部门列表 */
    private List<PfOrganVo> lstOrgan;
    /** 角色列表 */
    private List<PfRoleVo> lstRole;
    /** 部门id */
    private String organId;
    /** 角色id */
    private String roleId;
    /** 发送组别 */
    private String sendmode;
    /** 接收部门 */
    private String depts;
    /** 接收角色 */
    private String roles;
    /** 接收人 */
    private String peopleIds;
    /** 发送内容 */
    private String memo;
    
    private SysWorkFlowInstanceDao workFlowInstanceDao;
    /** 临时号码 */
    private List<String> nos;
    /** 自定义号码 */
    private String phones;
    
    private HttpServletResponse response;
    private HttpServletRequest request;
    /**
     * 发送界面
     * @return
     * @throws Exception
     */
	public String execute() throws Exception {
        lstOrgan=userService.getOrganList();
        lstRole = userService.getRoleList();

		return Action.SUCCESS;
	}

	/**
	 * 获取用户
	 */
	public String getuser() throws Exception{
		List<PfUserVo> lstUsers= userService.getUserListByOragn(organId);
        List<PfUserVo> uses = new ArrayList<PfUserVo>();
        for(PfUserVo user : lstUsers){
            if(StringUtils.isNotBlank(user.getMobilePhone())){
                uses.add(user);
            }
        }
		ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(JSONUtil.serialize(uses));
		return Action.NONE;
	}
	/**
	 * 消息发送
	 */
	public String sendMessage() throws Exception{
		this.nos=new ArrayList<String>();
		if("selectall".equals(sendmode)){
			List<PfUserVo> lstUsers=userService.getAllUsers();
			return sendMsg(lstUsers);
		}else if("selectdept".equals(sendmode)){
			if(depts.startsWith(";")){
				depts=depts.substring(1, depts.length());
			}
			if(depts.endsWith(";")){
				depts=depts.substring(0, depts.length()-1);
			}
			String[] deptList=depts.split(";");
			List<PfUserVo> lstUsers=new ArrayList<PfUserVo>();
			for(int i=0;i<deptList.length;i++){
				List<PfUserVo> lstUsersTemp= userService.getUserListByOragn(deptList[i]);
				for(PfUserVo user:lstUsersTemp){
					lstUsers.add(user);
				}
			}
			return sendMsg(lstUsers);
		}else if("selectpeople".equals(sendmode)){
			if(peopleIds.startsWith(";")){
				peopleIds=peopleIds.substring(1, peopleIds.length());
			}
			if(peopleIds.endsWith(";")){
				peopleIds=peopleIds.substring(0, peopleIds.length()-1);
			}
			String[] peopleList=peopleIds.split(";");
			
			List<PfUserVo> lstUsers=new ArrayList<PfUserVo>();
			for(int i=0;i<peopleList.length;i++){
				PfUserVo user = userService.getUserVo(peopleList[i]);
				lstUsers.add(user);
			}
	       return sendMsg(lstUsers);
		}else if("selectphone".equals(sendmode)){
			String[] phoneList=phones.trim().split(";");
			for(int i=0;i<phoneList.length;i++){
				if(!phoneList[i].toString().equals("")&&isNumeric(phoneList[i]))
					
					this.nos.add(phoneList[i]);
			}
	       return sendMsg(null);
		}else if("selectrole".equals(sendmode)){
            if(roles.startsWith(";")){
				roles=roles.substring(1, roles.length());
			}
			if(roles.endsWith(";")){
				roles=roles.substring(0, roles.length()-1);
			}
			String[] roleList=roles.split(";");
			List<PfUserVo> lstUsers=new ArrayList<PfUserVo>();
			for(int i=0;i<roleList.length;i++){
				List<PfUserVo> lstUsersTemp= userService.getUserListByRole(roleList[i]);
				for(PfUserVo user:lstUsersTemp){
					lstUsers.add(user);
				}
			}
			return sendMsg(lstUsers);
        }
		HashMap<String,String> resultObj = new HashMap<String,String>();
		response.setContentType("text/html;charset=utf-8");
		PrintWriter out = response.getWriter();
		resultObj.put("msg", "系统异常错误!");
        out.println(JSONUtil.serialize(resultObj));
		out.flush();
		out.close();
        return Action.NONE;
	}

    /**
     * 发送信息
     * @return
     * @throws java.io.IOException
     * @throws InterruptedException 
     * @throws org.apache.struts2.json.JSONException
     * @throws Exception
     */
    public String sendMsg(List<PfUserVo> lstUsers) throws IOException, InterruptedException, JSONException{
    	String Msg="";
    	List<PfSmsVo> smsList = new ArrayList<PfSmsVo>();
    	if(lstUsers!=null&&lstUsers.size()>0){
    		for(PfUserVo user : lstUsers){
                if(StringUtils.isNotBlank(user.getUserId()) && StringUtils.isNotBlank(user.getMobilePhone())) {
                    PfSmsVo sms = new PfSmsVo();
                    sms.setMobileNo(user.getMobilePhone());
                    sms.setSendDate(new Date(System.currentTimeMillis()));
                    sms.setContent(java.net.URLDecoder.decode(this.memo, "utf-8"));
                    sms.setReceive(user.getUserName());
                    sms.setSender(SessionUtil.getUserName(ServletActionContext.getRequest()));
                    smsList.add(sms);
                }
            }
    	}
		if(nos!=null&&nos.size()>0){
			for(String no : nos){
	            if(StringUtils.isNotBlank(no)) {
	                PfSmsVo sms = new PfSmsVo();
	                sms.setMobileNo(no);
	                sms.setSendDate(new Date(System.currentTimeMillis()));
	                sms.setContent(java.net.URLDecoder.decode(this.memo,"utf-8"));
	                sms.setReceive(no);
	                sms.setSender(SessionUtil.getUserName(ServletActionContext.getRequest()));
	                smsList.add(sms);
	            }
	        }
		}
        StringBuilder receive = new StringBuilder();
        for(int j=0;j < smsList.size() ; j++){
            if(j != 0){
                receive.append(",");
            }
            receive.append(smsList.get(j).getReceive());
            try {
                smsList.get(j).setSmsId(smsService.sendMsg(smsList.get(j)));
            } catch (Exception e) {
                e.printStackTrace();
                Msg="发送失败!";
            }
            Thread.sleep(100);
        }        
        //记录日志
        smsList.get(0).setReceive(receive.toString());
        Msg="发送成功!";
        response.setContentType("text/html;charset=utf-8");
		PrintWriter out = response.getWriter();
        out.println(Msg);
		out.flush();
		out.close();
        return Action.NONE;
    }
    
    /**
     * 发送代办任务信息，遍历全部人员，并向其发送手机短信
     * @return
     */
    public String sendTaskInfoMsg(){
    	HashMap<String,Integer> taskCountMap = (HashMap<String, Integer>) workFlowInstanceDao.statTaskCountMap(new HashMap());
        System.out.println("==============短信发送="+taskCountMap);
        if (taskCountMap != null &&taskCountMap.size()>0){
            List<PfSmsVo> smsList = new ArrayList<PfSmsVo>();
            Iterator<String> keyiter = taskCountMap.keySet().iterator();
            int sended = 0;
            while(keyiter.hasNext()){
                String userId =  keyiter.next();
                PfSmsVo sms = new PfSmsVo();
                PfUserVo user = userService.getUserVo(userId);
                Integer taskCountInt =  taskCountMap.get(userId);
                if (taskCountInt.intValue()==0  || user.getMobilePhone()==null ||user.getMobilePhone().trim().length()==0){
                    continue;
                }
                sended++;
                StringBuffer smscontent = new StringBuffer();
                smscontent.append("温馨提示：您好!您有");
                smscontent.append(taskCountInt.intValue());
                smscontent.append("条待办任务,请您登录到市局电子政务系统进行办理。国土资源局电子政务系统 ");
                java.text.SimpleDateFormat sdf=new java.text.SimpleDateFormat("yyyy年MM月dd日 HH:mm");
                smscontent.append(sdf.format(Calendar.getInstance().getTime()));

                sms.setMobileNo(user.getMobilePhone());
                sms.setSendDate(new Date(System.currentTimeMillis()));
                sms.setContent(smscontent.toString());
                sms.setReceive(user.getUserName());
                sms.setSender("电子政务系统");
                smsList.add(sms);
            }
             StringBuilder receive = new StringBuilder();
            for(int i=0;i < smsList.size() ; i++){
                if(i != 0){
                    receive.append(",");
                }
                receive.append(smsList.get(i).getReceive());
                try {
                    smsList.get(i).setSmsId(smsService.sendMsg(smsList.get(i)));
                } catch (Exception e) {
                    e.printStackTrace();
                    return Action.NONE;
                }
                try{
                    Thread.sleep(100);
                }catch(Exception ex){
                    ex.printStackTrace();
                }
            }
            System.out.println("=======================共发送了"+smsList.size()+"条短信");
            smsList.get(0).setReceive(receive.toString());
        }
        return Action.NONE;
    }
    
    /**
     * 短息列表
     * @return
     * @throws Exception
     */
    public String list() throws Exception{
        splitParam = new SplitParamImpl();
        splitParam.setQueryString("geSmsLogList");
        
        return "list";
    }

     /**
     * 获取接受信息列表
     * @return
     * @throws Exception
     */
    public String messageList() throws Exception {
        splitParam = new SplitParamImpl();
        splitParam.setQueryString("getMessageList");
        return "messageList";
    }

    /**
     * 获取队列信息列表
     * @return
     * @throws Exception
     */
    public String queryList() throws Exception {
        splitParam = new SplitParamImpl();
        splitParam.setQueryString("getQueryListList");
        return "queryList";
    }

    /**
     *  获取已发信息列表
     * @return
     * @throws Exception
     */
    public String historyList() throws Exception{
        splitParam = new SplitParamImpl();
        splitParam.setQueryString("getHistoryList");
        return "historyList";
    }

    /**
     * 状态查询
     * @return
     * @throws Exception
     */
    public String status() throws Exception{
        int status = smsService.msgState(smsVo.getSmsId());

        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(status);
        return Action.NONE;
    }
    
    public static boolean isNumeric(String str){
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();   
     } 
    
    public SysSmsService getSmsService() {
        return smsService;
    }
    public void setSmsService(SysSmsService smsService) {
        this.smsService = smsService;
    }
    public SysUserService getUserService() {
		return userService;
	}
	public void setUserService(SysUserService userService) {
		this.userService = userService;
	}
 
    public PfSmsVo getSmsVo() {
        return smsVo;
    }
    public void setSmsVo(PfSmsVo smsVo) {
        this.smsVo = smsVo;
    }
    public String getNewNos() {
        return newNos;
    }
    public void setNewNos(String newNos) {
        this.newNos = newNos;
    }
    public String getUserIds() {
        return userIds;
    }
    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }
    public SplitParam getSplitParam() {
        return splitParam;
    }
    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }
    public String getMessage() {
        return message;
    }
    public void setMessage(String message) {
        this.message = message;
    }

	public List<PfOrganVo> getLstOrgan() {
		return lstOrgan;
	}

	public void setLstOrgan(List<PfOrganVo> lstOrgan) {
		this.lstOrgan = lstOrgan;
	}

	public String getOrganId() {
		return organId;
	}

	public void setOrganId(String organId) {
		this.organId = organId;
	}

	public String getSendmode() {
		return sendmode;
	}

	public void setSendmode(String sendmode) {
		this.sendmode = sendmode;
	}

	public String getDepts() {
		return depts;
	}

	public void setDepts(String depts) {
		this.depts = depts;
	}

	public String getPeopleIds() {
		return peopleIds;
	}

	public void setPeopleIds(String peopleIds) {
		this.peopleIds = peopleIds;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public SysWorkFlowInstanceDao getWorkFlowInstanceDao() {
		return workFlowInstanceDao;
	}

	public void setWorkFlowInstanceDao(SysWorkFlowInstanceDao workFlowInstanceDao) {
		this.workFlowInstanceDao = workFlowInstanceDao;
	}

	public List<String> getNos() {
		return nos;
	}

	public void setNos(List<String> nos) {
		this.nos = nos;
	}

	public void setServletResponse(HttpServletResponse response) {
		this.response=response;
	}

	public void setServletRequest(HttpServletRequest request) {
		this.request=request;
	}

	public String getPhones() {
		return phones;
	}

	public void setPhones(String phones) {
		this.phones = phones;
	}

    public List<PfRoleVo> getLstRole() {
        return lstRole;
    }

    public void setLstRole(List<PfRoleVo> lstRole) {
        this.lstRole = lstRole;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getRoles() {
        return roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }
}
