package com.gtis.web.action;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.*;

import com.gtis.config.AppConfig;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import com.gtis.plat.service.SysTaskService;
import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.wf.WorkFlowCoreServiceImpl;
import com.opensymphony.xwork2.Action;

public class ShowFLowChartAction {

	SysWorkFlowInstanceService workFlowInstanceService;
	SysTaskService taskService;
	SysWorkFlowDefineService workFlowDefineService;
	String wdid;
	String wiid;
	String taskid;
	List<PfActivityVo> activityList;
	List<PfTaskVo> taskOverList;
	List<PfTaskVo> taskList;
	HashMap<String, String[]> activityMap;
    String enabledSq;
	Date currentDate;

	String overStartDate;
	String overEndDate;

	String overTimeDesc;
	
	boolean canClick = false;//节点是否可点击，主要用于点击节点，返回对应节点id和名称

	static Log log = LogFactory.getLog(ShowFLowChartAction.class);
	public SysTaskService getTaskService() {
		return taskService;
	}

	public void setTaskService(SysTaskService taskService) {
		this.taskService = taskService;
	}

	public List<PfActivityVo> getActivityList() {
		return activityList;
	}

	public void setActivityList(List<PfActivityVo> activityList) {
		this.activityList = activityList;
	}

	public List<PfTaskVo> getTaskOverList() {
		return taskOverList;
	}

	public void setTaskOverList(List<PfTaskVo> taskOverList) {
		this.taskOverList = taskOverList;
	}

	public List<PfTaskVo> getTaskList() {
		return taskList;
	}

	public void setTaskList(List<PfTaskVo> taskList) {
		this.taskList = taskList;
	}

	
	private void queryTaskStatusData(){
		if (taskid != null && !taskid.equals("")) {
			PfTaskVo taskVo = taskService.getTask(taskid);
			if (taskVo == null){
				taskVo = taskService.getHistoryTask(taskid);
			}
			PfActivityVo activityVo = taskService.getActivity(taskVo
					.getActivityId());
			wiid = activityVo.getWorkflowInstanceId();
			PfWorkFlowInstanceVo instanceVo = workFlowInstanceService
					.getWorkflowInstance(wiid);
			String wdid = instanceVo.getWorkflowDefinitionId();
			String activityXml = workFlowDefineService
					.getWorkFlowDefineLocation(wdid);
			if (activityXml != null && !activityXml.equals(""))
				parsdoc(activityXml);
		}else{
            PfWorkFlowInstanceVo instanceVo=workFlowInstanceService.getWorkflowInstance(wiid);
            String activityXml = workFlowDefineService
					.getWorkFlowDefineLocation(instanceVo.getWorkflowDefinitionId());
			if (activityXml != null && !activityXml.equals(""))
				parsdoc(activityXml);
        }
		activityList = taskService.getWorkFlowInstanceAllActivityList(wiid);
		taskList = taskService.getTaskListByInstance(wiid);
		taskOverList = taskService.getHistoryTaskListByInstance(wiid);
		handExistedUser(activityList, taskList);
		handExistedUser(activityList, taskOverList);

	}
	/**
	 * 如果存在重复的用户，则进行删除
	 * @param activityList
	 * @param inTaskVoList
	 */
	private void handExistedUser(List<PfActivityVo> activityList,List<PfTaskVo> inTaskVoList){
		List<String> taskIds=new ArrayList<String>();
		for (PfActivityVo activityVo:activityList) {
			String activityId=activityVo.getActivityId();
			List<String> userIds=new ArrayList<String>();
			for (PfTaskVo taskVo:inTaskVoList) {
				if (taskVo.getActivityId().equals(activityId)){
					if (userIds.contains(taskVo.getUserVo().getUserId())){
						taskIds.add(taskVo.getTaskId());
					}else{
						userIds.add(taskVo.getUserVo().getUserId());
					}
				}
			}
		}
		List<PfTaskVo>  tempVoList= new Vector<PfTaskVo>();
		for(String taskId:taskIds){
			for (PfTaskVo taskVo:inTaskVoList) {
				if (taskVo.getTaskId().equals(taskId)){
					tempVoList.add(taskVo);
				}
			}
		}
		for (int num=0;num<tempVoList.size();num++){
			inTaskVoList.remove(tempVoList.get(num));
		}
	}
	
	public String execute() throws Exception {
		currentDate = Calendar.getInstance().getTime();
        String sqConfig = AppConfig.getProperty("useSq.enable");
        if(StringUtils.isNotBlank(sqConfig)&&Boolean.parseBoolean(sqConfig)){
            enabledSq="true";
        }else
            enabledSq="false";
		queryTaskStatusData();
		return Action.SUCCESS;
	}

	public String overtime() throws Exception{
		if(StringUtils.isNotBlank(overStartDate)&&StringUtils.isNotBlank(overEndDate)){
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			long timeSpan = simpleDateFormat.parse(overEndDate).getTime()-simpleDateFormat.parse(overStartDate).getTime();
			int daySpan=(int)Math.floor(timeSpan/(24.0*60.0*60.0*1000.0));
			int hourSpan=(int)Math.ceil(timeSpan/(60.0*60.0*1000.0)-daySpan*24.0);
			if(daySpan==0)
				overTimeDesc = String.format("%d小时",hourSpan);
			else
				overTimeDesc = String.format("%d天%d小时",daySpan,hourSpan);
		}
		return "overtimeDesc";
	}


	
	public String flowChartTable(){

		queryTaskStatusData();
		return "flowcharttable";
	}

	public String getImageLocation() {

		return null;
	}

	public void parsdoc(String activityXml)  {
		
		try {
			activityMap = new HashMap<String, String[]>();
			Document doc = DocumentHelper.parseText(activityXml);
			List<Node> resultNodeList = doc.selectNodes("//Data");
			for(Node dataNode:resultNodeList){
				String[] loc=new String[4];
				loc[0]=(Integer.parseInt(dataNode.valueOf("@left")) + 2)+ "" ;//由于图片的left和top存在2个像素的误差，所以+2；
				loc[1]=(Integer.parseInt(dataNode.valueOf("@top")) + 2)+ "";
				loc[2]=dataNode.valueOf("@width");
				loc[3]=dataNode.valueOf("@height");
				String id=dataNode.valueOf("@id");
				activityMap.put(id, loc);
			}
		} catch (Exception e) {
			log.error("活动xml解析错误！", e);
		}

	}

    public String image() throws Exception {
        if (taskid != null && !taskid.equals("")) {
            PfTaskVo taskVo = taskService.getTask(taskid);
            if (taskVo == null){
                taskVo = taskService.getHistoryTask(taskid);
            }
            PfActivityVo activityVo = taskService.getActivity(taskVo
                    .getActivityId());
            wiid = activityVo.getWorkflowInstanceId();
        }
        ServletActionContext.getResponse().setContentType("image/jpeg");
        try {
            PfWorkFlowInstanceVo instanceVo = workFlowInstanceService
                    .getWorkflowInstance(wiid);
            PfWorkFlowDefineVo vo = workFlowDefineService
                    .getWorkFlowImage(instanceVo.getWorkflowDefinitionId());
            if (vo.getWorkFlowImage() != null) {
                ServletActionContext.getResponse().getOutputStream().write(
                        vo.getWorkFlowImage(), 0, vo.getWorkFlowImage().length);
                ServletActionContext.getResponse().getOutputStream().flush();
                ServletActionContext.getResponse().getOutputStream().close();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


	public String imageByWdid() throws Exception {
		
		try {
			if (StringUtils.isNotBlank(wdid)) {
				PfWorkFlowDefineVo vo = workFlowDefineService.getWorkFlowImage(wdid);
				ServletActionContext.getResponse().setContentType("image/jpeg");
				if (vo.getWorkFlowImage() != null) {
					ServletActionContext.getResponse().getOutputStream().write(
							vo.getWorkFlowImage(), 0, vo.getWorkFlowImage().length);
					ServletActionContext.getResponse().getOutputStream().flush();
					ServletActionContext.getResponse().getOutputStream().close();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

    public String simpleImage() throws Exception{
        if (StringUtils.isNotBlank(wiid)||StringUtils.isNotBlank(wdid)) {
            PfWorkFlowDefineVo vo = null;
            if(StringUtils.isNotBlank(wiid)){
                PfWorkFlowInstanceVo instanceVo = workFlowInstanceService.getWorkflowInstance(wiid);
                vo = workFlowDefineService.getWorkFlowDefine(instanceVo.getWorkflowDefinitionId());
            }else if(StringUtils.isNotBlank(wdid)){
                vo = workFlowDefineService.getWorkFlowDefine(wdid);
            }

            String workflowDefineName = vo.getWorkflowName();
            String flowChartImagePath = ServletActionContext.getRequest().getSession().getServletContext().getRealPath("/") + "\\pf\\flowchart\\" + workflowDefineName + "\\";
            if (new File(flowChartImagePath).exists()) {
                List<File> tmpFiles = (List<File>) FileUtils.listFiles(new File(flowChartImagePath), null, false);
                if (tmpFiles != null && tmpFiles.size() > 0) {
                    ServletActionContext.getResponse().setContentType("image/jpeg");
                    File tmpFile = tmpFiles.get(0);
                    FileInputStream fileInputStream = null;
                    BufferedInputStream bufferedInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(tmpFile);
                        bufferedInputStream = new BufferedInputStream(fileInputStream);
                        byte[] tmp = new byte[255];
                        int len = 0;
                        while ((len = bufferedInputStream.read(tmp, 0, 255)) != -1) {
                            ServletActionContext.getResponse().getOutputStream().write(
                                    tmp, 0, len);
                        }
                    } catch (Exception ex) {
                        throw ex;
                    } finally {
                        if (bufferedInputStream != null)
                            bufferedInputStream.close();
                        if (fileInputStream != null)
                            fileInputStream.close();
                    }
                    ServletActionContext.getResponse().getOutputStream().flush();
                    ServletActionContext.getResponse().getOutputStream().close();
                }
            }

        }
        return null;
    }


    public String simpleFlowChart(){
        return "simpleFlowChart";
    }

	public SysWorkFlowInstanceService getWorkFlowInstanceService() {
		return workFlowInstanceService;
	}

	public void setWorkFlowInstanceService(
			SysWorkFlowInstanceService workFlowInstanceService) {
		this.workFlowInstanceService = workFlowInstanceService;
	}

	public String getWiid() {
		return wiid;
	}

	public void setWiid(String wiid) {
		this.wiid = wiid;
	}

	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

	public HashMap<String, String[]> getActivityMap() {
		return activityMap;
	}

	public void setActivityMap(HashMap<String, String[]> activityMap) {
		this.activityMap = activityMap;
	}

	public String getWdid() {
		return wdid;
	}

	public void setWdid(String wdid) {
		this.wdid = wdid;
	}

    public String getEnabledSq() {
        return enabledSq;
    }

    public void setEnabledSq(String enabledSq) {
        this.enabledSq = enabledSq;
    }

	public Date getCurrentDate() {
		return currentDate;
	}

	public void setCurrentDate(Date currentDate) {
		this.currentDate = currentDate;
	}

	public String getOverTimeDesc() {
		return overTimeDesc;
	}

	public void setOverTimeDesc(String overTimeDesc) {
		this.overTimeDesc = overTimeDesc;
	}

	public String getOverEndDate() {
		return overEndDate;
	}

	public void setOverEndDate(String overEndDate) {
		this.overEndDate = overEndDate;
	}

	public String getOverStartDate() {
		return overStartDate;
	}

	public void setOverStartDate(String overStartDate) {
		this.overStartDate = overStartDate;
	}

	public boolean isCanClick() {
		return canClick;
	}

	public void setCanClick(boolean canClick) {
		this.canClick = canClick;
	}
}
