package com.gtis.web.action;

import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.web.SessionUtil;
import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import com.gtis.web.action.TaskListActionAbstract;
import com.opensymphony.xwork2.Action;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.ServletActionContext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class ProjectRelateAction{
    String IBATIS_QUERY_NAME = "getUnrelatedProjectList";
    String rid;
    SysAuthorService authorService;
    SysMenuService menuService;
    SysWorkFlowInstanceRelService workFlowInstanceRelService;
    String wiid;
    String wiidRelated;

    private SplitParam splitParam;
    /** 工作流定义列表 */
    private List<PfWorkFlowDefineVo> lstWorkFlowDefine;
    /** 业务列表 */
    private List<PfBusinessVo> businessList;
    /** 工作流定义服务 */
    private SysWorkFlowDefineService workFlowDefineService;


    private String businessid;

    public String getWiid() {
        return wiid;
    }

    public void setWiid(String wiid) {
        this.wiid = wiid;
    }

    public SysMenuService getMenuService() {
        return menuService;
    }


    public void setMenuService(SysMenuService menuService) {
        this.menuService = menuService;
    }

    public SysAuthorService getAuthorService() {
        return authorService;
    }

    public void setAuthorService(SysAuthorService authorService) {
        this.authorService = authorService;
    }

    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    /**
     * 获取当前项目可进行关联的项目列表
     * @return
     * @throws Exception
     */
    public String execute() throws Exception {
        SplitParamImpl splitParam1=new SplitParamImpl();
        splitParam1.setQueryString(IBATIS_QUERY_NAME);
        if(StringUtils.isNotBlank(wiid)){
            HashMap param = new HashMap();
            param.put("RELATEDWIID",wiid);
            splitParam1.setQueryParam(param);
        }


        splitParam=splitParam1;

        lstWorkFlowDefine=workFlowDefineService.getWorkFlowDefineList();
        PfWorkFlowDefineVo vo=new PfWorkFlowDefineVo();
        vo.setWorkflowName("----所有业务----");
        vo.setWorkflowDefinitionId("");
        lstWorkFlowDefine.add(0, vo);

        businessList = workFlowDefineService.getBusinessSimpleList();
        PfBusinessVo pbv = new PfBusinessVo();
        pbv.setBusinessName("----所有业务----");
        pbv.setBusinessId("");
        businessList.add(0,pbv);

        ServletActionContext.getRequest().setAttribute("USERID",SessionUtil.getUserId(ServletActionContext.getRequest()));
        return Action.SUCCESS;
    }

    /**
     * 对当前项目进行关联
     * @return
     */
    public String associateWorkflowInstance(){
        Map result = new HashMap();
        result.put("result","false");
        result.put("msg","项目关联失败");
        if(StringUtils.isNotBlank(wiid)&&StringUtils.isNotBlank(wiidRelated)){
            String[] wiidRelatedArray = wiidRelated.split(";");
            for(String tmpWiid:wiidRelatedArray){
                workFlowInstanceRelService.insertWorkFlowRel(wiid,tmpWiid);
            }
            result.put("result","true");
            result.put("msg","项目关联成功");
        }
        Struts2Utils.renderJson(result);
        return Action.NONE;
    }

    /**
     * 获取当前项目已经关联的项目
     * @return
     */
    public String getAssociatedWorkflowInstance(){
        List result = new ArrayList();
        if(StringUtils.isNotBlank(wiid)){
            result = workFlowInstanceRelService.getWorkFlowRelList(wiid);

        }
        Struts2Utils.renderJson(result);
        return Action.NONE;
    }

    public String getAssociatedWorkflowInstanceList() throws Exception {
        IBATIS_QUERY_NAME = "getWorkFlowRelList1";

        return "projectRelList";
    }

    /**
     * 删除与当前项目管理的关联关系
     * @return
     */
    public String delAssociatedWorkflowInstalnce(){
        Map result = new HashMap();
        result.put("result","false");
        result.put("msg","删除项目关联失败");
        if(StringUtils.isNotBlank(wiid)&&StringUtils.isNotBlank(wiidRelated)){
            String[] wiidRelatedArray = wiidRelated.split(";");
            for(String tmpWiid:wiidRelatedArray){
                workFlowInstanceRelService.deleteWorkFlowRel(wiid,tmpWiid);
                workFlowInstanceRelService.deleteWorkFlowRel(tmpWiid,wiid);
            }
            result.put("result","true");
            result.put("msg","删除项目关联成功");
        }
        Struts2Utils.renderJson(result);
        return Action.NONE;
    }

    public String getWiidRelated() {
        return wiidRelated;
    }

    public void setWiidRelated(String wiidRelated) {
        this.wiidRelated = wiidRelated;
    }

    public SysWorkFlowInstanceRelService getWorkFlowInstanceRelService() {
        return workFlowInstanceRelService;
    }

    public void setWorkFlowInstanceRelService(SysWorkFlowInstanceRelService workFlowInstanceRelService) {
        this.workFlowInstanceRelService = workFlowInstanceRelService;
    }

    public SplitParam getSplitParam() {
        return splitParam;
    }

    public void setSplitParam(SplitParam splitParam) {
        this.splitParam = splitParam;
    }

    public List<PfWorkFlowDefineVo> getLstWorkFlowDefine() {
        return lstWorkFlowDefine;
    }

    public void setLstWorkFlowDefine(List<PfWorkFlowDefineVo> lstWorkFlowDefine) {
        this.lstWorkFlowDefine = lstWorkFlowDefine;
    }

    public List<PfBusinessVo> getBusinessList() {
        return businessList;
    }

    public void setBusinessList(List<PfBusinessVo> businessList) {
        this.businessList = businessList;
    }

    public SysWorkFlowDefineService getWorkFlowDefineService() {
        return workFlowDefineService;
    }

    public void setWorkFlowDefineService(SysWorkFlowDefineService workFlowDefineService) {
        this.workFlowDefineService = workFlowDefineService;
    }

    public String getBusinessid() {
        return businessid;
    }

    public void setBusinessid(String businessid) {
        this.businessid = businessid;
    }
}
