package com.gtis.web.action;

import com.gtis.config.AppConfig;
import com.gtis.generic.util.Struts2Utils;
import com.gtis.plat.vo.OnlineUser;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionStorage;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import org.apache.struts2.ServletActionContext;
import org.springframework.security.context.HttpSessionContextIntegrationFilter;
import org.springframework.security.context.SecurityContext;

import javax.servlet.http.HttpSession;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2010-2-26
 */
public class OnlineViewAction implements Action {
// ------------------------------ FIELDS ------------------------------

    private SessionStorage sessionStorage;
    private Map<String, Set<OnlineUser>> organs;
    private int count = 0;

// --------------------- GETTER / SETTER METHODS ---------------------

    public int getCount() {
        return count;
    }

    public Map<String, Set<OnlineUser>> getOrgans() {
        return organs;
    }

    public void setSessionStorage(SessionStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
    }
// ------------------------ INTERFACE METHODS ------------------------


// --------------------- Interface Action ---------------------

    public String execute() throws Exception {
        organs = new LinkedHashMap<String, Set<OnlineUser>>();
        Set<OnlineUser> others = new LinkedHashSet<OnlineUser>();
        Collection<HttpSession> sessions = sessionStorage.getSessions();
        for (HttpSession session : sessions) {
            SecurityContext sc = (SecurityContext) session.getAttribute(HttpSessionContextIntegrationFilter.SPRING_SECURITY_CONTEXT_KEY);
            if (sc == null)
                continue;
            UserInfo ui = (UserInfo) sc.getAuthentication().getPrincipal();
            String ip = (String) session.getAttribute(OnlineUser.ONLINE_USER_IP);
            OnlineUser ou = new OnlineUser(ip,
                    new Date(session.getCreationTime()),
                    ui.getId(),
                    ui.getUsername());
            if (ui.getLstOragn() == null || ui.getLstOragn().size() == 0) {
                others.add(ou);
                continue;
            }
            String organName = ui.getLstOragn().get(0).getOrganName();
            if (organs.containsKey(organName)) {
                organs.get(organName).add(ou);
            } else {
                Set<OnlineUser> list = new LinkedHashSet<OnlineUser>();
                list.add(ou);
                organs.put(organName, list);
            }
        }
        if (others.size() > 0)
            organs.put("其他", others);
        for (Set<OnlineUser> users : organs.values()) {
            count += users.size();
        }
        return SUCCESS;
    }

    public String duplicatedLoginCheck(){
        StringBuilder content = new StringBuilder();
        Boolean duplicatedLoginCheck = AppConfig.getBooleanProperty("duplicatedLoginCheck.enable",false);
        if(duplicatedLoginCheck) {
            HttpSession currentSession = ServletActionContext.getRequest().getSession();
            String currentIp = (String) currentSession.getAttribute(OnlineUser.ONLINE_USER_IP);
            Collection<HttpSession> sessions = sessionStorage.getSessions();
            for (HttpSession session : sessions) {
                SecurityContext sc = (SecurityContext) session.getAttribute(HttpSessionContextIntegrationFilter.SPRING_SECURITY_CONTEXT_KEY);
                if (sc == null)
                    continue;
                UserInfo ui = (UserInfo) sc.getAuthentication().getPrincipal();
                String ip = (String) session.getAttribute(OnlineUser.ONLINE_USER_IP);
                if (ui.getId().equals(SessionUtil.getCurrentUserId()) && !ip.equals(currentIp)) {
                    String tmp = String.format("当前用户已在其他机器（IP地址：%s）登录！", ip);
                    content.append(tmp);
                    break;
                }
            }
        }
        Struts2Utils.renderText(content.toString());
        return NONE;
    }
}
