package com.gtis.web.action;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.gtis.web.SplitParam;
import com.gtis.web.SplitParamImpl;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.fileCenter.ex.NodeNotFoundException;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.model.Space;
import com.gtis.fileCenter.service.NodeService;
import com.gtis.plat.service.SysMessageService;
import com.gtis.plat.vo.PfMessageAcceptVo;
import com.gtis.plat.vo.PfMessageSendVo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import com.sun.syndication.feed.synd.SyndFeed;

import org.apache.struts2.json.JSONUtil;


import com.gtis.plat.service.impl.SysMessageRssBuilder;
import com.gtis.plat.service.impl.SysMessageServiceImpl;
import com.gtis.rss.RssAction;
import com.gtis.spring.Container;

public class MessageManageAction extends RssAction implements ServletRequestAware,ServletResponseAware{
	private static final long serialVersionUID = 638672113653302233L;
	
	private SyndFeed  feed;
	private SysMessageRssBuilder ressBuilder;
	
	private NodeService nodeService;
	private Integer nodeId;
    private String token;
    private PfMessageSendVo msgSendVo;
    private String msgSendId;
    
    
    private static final String MESSAGE_STUFF = "消息附件";
    SplitParam splitParam;
    
    
	private String sendDateBegin;
	private String sendDateEnd;
	private String mesageStadus;
	
	private String flag;
	private SysMessageService messageService;
	private PfMessageAcceptVo msgAcceptVo;
	
	private String sendIdList;
	private String acceptIdList;
	
	private HttpServletRequest request;
	private HttpServletResponse response;
	private String newMsg;
	private String answerAcceptUser;
	private String answerAcceptUserId;
	
	
    public String getAnswerAcceptUserId() {
		return answerAcceptUserId;
	}

	public void setAnswerAcceptUserId(String answerAcceptUserId) {
		this.answerAcceptUserId = answerAcceptUserId;
	}

	public String getAnswerAcceptUser() {
		return answerAcceptUser;
	}

	public void setAnswerAcceptUser(String answerAcceptUser) {
		this.answerAcceptUser = answerAcceptUser;
	}

	public String getAcceptIdList() {
		return acceptIdList;
	}

	public void setAcceptIdList(String acceptIdList) {
		this.acceptIdList = acceptIdList;
	}

	public String getNewMsg() {
		return newMsg;
	}

	public void setNewMsg(String newMsg) {
		this.newMsg = newMsg;
	}

	public String getSendIdList() {
		return sendIdList;
	}

	public void setSendIdList(String sendIdList) {
		this.sendIdList = sendIdList;
	}

	public String getMsgSendId() {
		return msgSendId;
	}

	public void setMsgSendId(String msgSendId) {
		this.msgSendId = msgSendId;
	}

	public String execute() throws Exception {
		
		if(msgSendId!=null&&!msgSendId.equals("")){
			msgSendVo=messageService.getSendMessage(this.msgSendId);
		}
		if(msgSendVo!=null){
			if(newMsg!=null&&newMsg.equals("answer")){
				msgSendVo.setMessageSendTitle("回复\""+msgSendVo.getMessageSendTitle()+"\"");
				this.answerAcceptUserId=msgSendVo.getUserId();
				this.answerAcceptUser=msgSendVo.getUserName();
				Space space = nodeService.getWorkSpace(MESSAGE_STUFF);
				msgSendVo.setMessageSendId(UUIDGenerator.generate());
	    		Node msgNode = nodeService.getNode(space.getId(), msgSendVo.getMessageSendId(),true);
	    		nodeId = msgNode.getId();
	    		token = nodeService.getToken(msgNode);
			}else{
				Space space = nodeService.getWorkSpace(MESSAGE_STUFF);
	    		Node msgNodeOld=nodeService.getNode(space.getId(), msgSendVo.getMessageSendId());
	    		msgSendVo.setMessageSendId(UUIDGenerator.generate());
	    		//复制附件
	    		Space spaceNew = nodeService.getWorkSpace(MESSAGE_STUFF,true);
	    		Node msgNodeNew = nodeService.getNode(spaceNew.getId(), msgSendVo.getMessageSendId(),true);
	    		
	    		List<Node> list=nodeService.getChildNodes(msgNodeOld.getId());
	    		Integer[] nodeIdList=new Integer[list.size()];
	    		for(int i=0;i<list.size();i++)
	    		{
	    			nodeIdList[i]=list.get(i).getId();
	    		}
	    		nodeService.copy(nodeIdList , msgNodeNew.getId(), true);
	    		nodeId = msgNodeNew.getId();
	    		token = nodeService.getToken(msgNodeNew);
			}
		}
		else{
	    	msgSendVo = new PfMessageSendVo();
	    	Space space = nodeService.getWorkSpace(MESSAGE_STUFF,true);
	    	Node msgNode = null;
	    	msgSendVo.setMessageSendId(UUIDGenerator.generate());
	    	msgNode = nodeService.getNode(space.getId(), msgSendVo.getMessageSendId(),true);
	    	nodeId = msgNode.getId();
	    	token = nodeService.getToken(msgNode);
		}
    	return Action.SUCCESS;
    }
    
    public String send() throws Exception {
    	PfMessageSendVo vo=messageService.getSendMessage(msgSendVo.getMessageSendId());
    	HttpServletRequest request = ServletActionContext.getRequest();
    	msgSendVo.setUserId(SessionUtil.getUserId(request));// 发送人ID
    	msgSendVo.setUserName(SessionUtil.getUserName(request));// 发送人

		boolean isok = messageService.insertMessage(msgSendVo);
		
		if(isok){
			request.setAttribute("info", "");
		}else {
			request.setAttribute("info", "上传失败！");
		}
		return "SEND_MSG";
    }
    
    
    
    public String acceptList() throws Exception {
    	SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString("queryacceptmsglist");
		HashMap<String,String> paramsMap = new HashMap<String,String>();
		
		if(!SessionUtil.getUserId(ServletActionContext.getRequest()).equals("0"))
		{
			paramsMap.put("acceptUserId",SessionUtil.getUserId(ServletActionContext.getRequest()));
		}
		
		if(mesageStadus != null && "1".equals(mesageStadus)){
			paramsMap.put("mesageStadus",mesageStadus);
		}
		splitParam1.setQueryParam(paramsMap);
		splitParam=splitParam1;
		
		return "ACCEPT_MSG_LIST";
    }
    
    public String sendList() throws Exception{
    	SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString("querysendmsglist");
		HashMap<String,String> paramsMap=new HashMap<String,String>();
		if(!SessionUtil.getUserId(ServletActionContext.getRequest()).equals("0")){
			paramsMap.put("sendUserId", SessionUtil.getUserId(ServletActionContext.getRequest()));
		}
		splitParam1.setQueryParam(paramsMap);
		splitParam = splitParam1;
		
		return "SEND_MSG_LIST";
    }
    
    public String detail() throws Exception{
    	if("accept".equals(flag)){
    		String tempMsgAcceptId = msgAcceptVo.getMessageAcceptId();
    		if(tempMsgAcceptId != null){
    			msgAcceptVo = messageService.getAcceptMessage(tempMsgAcceptId);
    			msgSendVo = msgAcceptVo.getMessageSendVo();
    			messageService.updateMessageStatus(tempMsgAcceptId);
    		}
    	}else if("send".equals(flag)){
    		msgSendVo = messageService.getSendMessage(msgSendVo.getMessageSendId());
    	}
    	
    	if(msgSendVo != null){
    		try{
        		Space space = nodeService.getWorkSpace(MESSAGE_STUFF);
        		Node msgNode = nodeService.getNode(space.getId(), msgSendVo.getMessageSendId());
        		nodeId = msgNode.getId();
    		}catch(NodeNotFoundException e){
        		e.printStackTrace();
        		request.setAttribute("message", "附件列表获取失败！");
    		}
    	}
    	return "MSG_DETAIL";
    }
    
    public String restore() throws Exception{
    	SplitParamImpl splitParam1=new SplitParamImpl();
		splitParam1.setQueryString("querymsgrestorelist");
		HashMap<String,String> paramsMap=new HashMap<String,String>();
		paramsMap.put("messageSendId", msgSendVo.getMessageSendId());
		splitParam1.setQueryParam(paramsMap);
		splitParam = splitParam1;
    	return "MSG_RESTORE_LIST";
    }
    
    public String del_sendmsg() throws Exception{
    	String result="";
		String Msg ="";
		String[] sendIdListStr=sendIdList.split(";");
		String readedCount = null;
		int delSuccessCount=0;
		int delFailCount=0;
		HashMap<String,String> resultObj = new HashMap<String,String>();
		try
		{
			SysMessageServiceImpl messageServiceImpl=(SysMessageServiceImpl) Container.getBean("SysMessageServiceImpl");
			//判断该消息是否有人阅读过
			
			for(int i=0;i<sendIdListStr.length;i++)
			{
				if(!SessionUtil.getUserId(ServletActionContext.getRequest()).equals("0")){
					readedCount=messageServiceImpl.getReadedMsgBySendId(sendIdListStr[i].toString());
				}
				if(readedCount==null||readedCount.equals("0")){
					//删除发送消息业务数据
					messageServiceImpl.delSendMsgById(sendIdListStr[i].toString());
					//删除附件
					Space space = nodeService.getWorkSpace(MESSAGE_STUFF,true);
					Node node = nodeService.getNode(space.getId(),sendIdListStr[i].toString(),true);
					nodeId = node.getId();
					nodeService.remove(nodeId);
					delSuccessCount++;
				}else{
					delFailCount++;
				}	
			}		
			if(delFailCount>0&&delSuccessCount>0){
				Msg="成功删除"+delSuccessCount+"条消息,有"+delFailCount+"条消息不能删除！";
			}else if(delSuccessCount>0&&delFailCount==0){
				Msg="成功删除"+delSuccessCount+"条消息！";
			}else{
				Msg="该消息已被查看，无法删除！";
			}
			result="true";
		}
		catch(Exception ex)
		{
			Msg="显示删除失败！";
			result="false";
		}
		response.setContentType("text/html;charset=utf-8");
		PrintWriter out = response.getWriter();
		resultObj.put("result", result);
		resultObj.put("msg", Msg);
        out.println(JSONUtil.serialize(resultObj));
		out.flush();
		out.close();
		return Action.NONE;
    }
    
    public String del_acceptmsg() throws Exception{
    	String result="";
		String Msg ="";
		String[] acceptIdListStr=acceptIdList.split(";");
		HashMap<String,String> resultObj = new HashMap<String,String>();
		try
		{
			SysMessageServiceImpl messageServiceImpl=(SysMessageServiceImpl) Container.getBean("SysMessageServiceImpl");
			for(int i=0;i<acceptIdListStr.length;i++)
			{
				//删除接收信息业务数据
				messageServiceImpl.delAcceptMsgById(acceptIdListStr[i].toString());
			}		
			Msg="消息删除成功！";
			result="true";
		}
		catch(Exception ex)
		{
			Msg="消息删除失败！";
			result="false";
		}
		response.setContentType("text/html;charset=UTF-8");
		PrintWriter out=response.getWriter();
		resultObj.put("result", result);
		resultObj.put("msg", Msg);
		out.println(JSONUtil.serialize(resultObj));
		out.flush();
		out.close();
		return Action.NONE;
    }
    
    
    public String rss() throws Exception {
        feed = ressBuilder.getFeed(0,10);
        return "RSS";    
    }
    
    
    
    public String readMsg() throws Exception{
    	return "";
    }
    
	public NodeService getNodeService() {
		return nodeService;
	}

	public void setNodeService(NodeService nodeService) {
		this.nodeService = nodeService;
	}

	public Integer getNodeId() {
		return nodeId;
	}

	public void setNodeId(Integer nodeId) {
		this.nodeId = nodeId;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public PfMessageSendVo getMsgSendVo() {
		return msgSendVo;
	}

	public void setMsgSendVo(PfMessageSendVo msgSendVo) {
		this.msgSendVo = msgSendVo;
	}

	public SplitParam getSplitParam() {
		return splitParam;
	}

	public void setSplitParam(SplitParam splitParam) {
		this.splitParam = splitParam;
	}

	public String getSendDateBegin() {
		return sendDateBegin;
	}

	public void setSendDateBegin(String sendDateBegin) {
		this.sendDateBegin = sendDateBegin;
	}

	public String getSendDateEnd() {
		return sendDateEnd;
	} 

	public void setSendDateEnd(String sendDateEnd) {
		this.sendDateEnd = sendDateEnd;
	}

	public String getMesageStadus() {
		return mesageStadus;
	}

	public void setMesageStadus(String mesageStadus) {
		this.mesageStadus = mesageStadus;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public SysMessageService getMessageService() {
		return messageService;
	}

	public void setMessageService(SysMessageService messageService) {
		this.messageService = messageService;
	}

	public PfMessageAcceptVo getMsgAcceptVo() {
		return msgAcceptVo;
	}

	public void setMsgAcceptVo(PfMessageAcceptVo msgAcceptVo) {
		this.msgAcceptVo = msgAcceptVo;
	}

	public void setServletRequest(HttpServletRequest request) {
		this.request = request;
	}

	public void setServletResponse(HttpServletResponse response) {
		this.response=response;
	}

	public SyndFeed getFeed() {
		return feed;
	}
	public void setFeed(SyndFeed feed) {
		this.feed = feed;
	}

	public SysMessageRssBuilder getRessBuilder() {
		return ressBuilder;
	}

	public void setRessBuilder(SysMessageRssBuilder ressBuilder) {
		this.ressBuilder = ressBuilder;
	}
	
}
