package com.gtis.web.action;

import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.dao.SysMessageDAO;
import com.gtis.spring.Container;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import org.apache.struts2.ServletActionContext;

import java.util.HashMap;

/**
 * @(#)LoginAction.java 2010-12-7 9:59:31
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					:
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class LoginAction implements Action {
    private UserInfo userInfo;
    private SysWorkFlowInstanceService instanceService;

    private String taskCount;
    private String msgCount;

    public String execute() throws Exception {
        userInfo = SessionUtil.getUserInfo(ServletActionContext.getRequest());
        userInfo.setPassword("");
        XStream xstr = new XStream(new DomDriver());
        xstr.alias("user",UserInfo.class);
        xstr.alias("organ", PfOrganVo.class);
        xstr.alias("role", PfRoleVo.class);
        ServletActionContext.getResponse().setCharacterEncoding("utf-8");
		ServletActionContext.getResponse().getWriter().println(xstr.toXML(userInfo));

        HashMap<String,String> map=new HashMap<String,String>();
		map.put("userId",userInfo.getId());
		taskCount = instanceService.getTaskCount(map);

        SysMessageDAO sysMessageDAO = (SysMessageDAO) Container.getBean("SysMessageDao");
        msgCount  = sysMessageDAO.getPopMessage(SessionUtil.getUserId(ServletActionContext.getRequest()));

        return Action.SUCCESS;
    }

    public void setInstanceService(SysWorkFlowInstanceService instanceService) {
        this.instanceService = instanceService;
    }

    public String getTaskCount() {
        return taskCount;
    }

    public String getMsgCount() {
        return msgCount;
    }

    public UserInfo getUserInfo() {
        return userInfo;
    }


} 