package com.gtis.web.action;

import java.util.HashMap;

import com.gtis.common.util.CommonUtil;
import com.gtis.plat.form.*;
import com.gtis.web.SessionUtil;
import com.opensymphony.xwork2.Action;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.json.JSONUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class FormViewAction {
	private static final Logger logger = LoggerFactory.getLogger(FormViewAction.class);
	FormInstanceFactory instanceFactory;
	boolean transHtml;
	String dfid;
	String proid;
	String taskid;
	String rid;
	private String paramString;
	
	public String getDfid() {
		return dfid;
	}

	public void setDfid(String dfid) {
		this.dfid = dfid;
	}

	public String getProid() {
		return proid;
	}

	public void setProid(String proid) {
		this.proid = proid;
	}

	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

	public String getRid() {
		return rid;
	}

	public void setRid(String rid) {
		this.rid = rid;
	}
    public String execute2() throws Exception {
        try {
            FormInstance formInstance = instanceFactory
                    .createFormInstance(dfid);
            formInstance.setProId(proid);
            Document iDoc = FormXmlBuilder.buildFormXml(formInstance);
            FormXmlBuilder.AddHiddenData(iDoc,"UserName", SessionUtil.getUserName(ServletActionContext.getRequest()));
            FormXmlBuilder.AddHiddenData(iDoc,"UserId", SessionUtil.getUserId(ServletActionContext.getRequest()));
            FormXmlBuilder.AddHiddenData(iDoc,"CurTime", CommonUtil.getCurrStrDate());
            FormXmlBuilder.AddHiddenData(iDoc,"hiddenProId",proid);

            DocumentSource xmlSource = new DocumentSource(iDoc);

            String xlstString = FormModelFactory.getFormDefineVo(dfid)
                    .getDefinitionXlst();
            Document doc = DocumentHelper.parseText(xlstString);
            DocumentSource xsl = new DocumentSource(doc);

            //StreamSource xmlSource = new StreamSource("E://workspace_g2//TT//src//books.xml");
            //StreamSource xsl = new StreamSource("E://workspace_g2//TT//src//books.xsl");
            javax.xml.transform.stream.StreamResult xmlResult =
                    new javax.xml.transform.stream.StreamResult(ServletActionContext.getResponse().getOutputStream());
            Transformer ts = TransformerFactory.newInstance().newTransformer(xsl);
            ts.transform(xmlSource, xmlResult);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return Action.NONE;
    }

	public String execute() throws Exception {
		String path = ServletActionContext.getRequest().getContextPath();
		String xlstPath = "";
		try {
            StopWatch clock = new StopWatch();
            clock.start();
			// 组织sql
			if (ServletActionContext.getRequest().getParameter("dfid") != null) {
				xlstPath = path + "/forms/xlst.action?dfid=" + this.dfid;
			}
			FormInstance formInstance = instanceFactory
					.createFormInstance(dfid);
			formInstance.setProId(proid);
			if (StringUtils.isNotBlank(paramString)) {
				try {
					String json = java.net.URLDecoder.decode(paramString, "utf-8");
					HashMap param = (HashMap)JSONUtil.deserialize(json);
					if (param != null && param.entrySet().size() > 0) {
						formInstance.setQueryParam(param);
					}
				} catch (Exception e) {
					logger.error("查询参数配置格式(json格式{'':'','':''})有误："+paramString);
				}
			}
			Document iDoc = FormXmlBuilder.buildFormXml(formInstance);
            FormXmlBuilder.AddHiddenData(iDoc,"UserName", SessionUtil.getUserName(ServletActionContext.getRequest()));
            FormXmlBuilder.AddHiddenData(iDoc,"UserId", SessionUtil.getUserId(ServletActionContext.getRequest()));
            FormXmlBuilder.AddHiddenData(iDoc,"CurTime", CommonUtil.getCurrStrDate());
            FormXmlBuilder.AddHiddenData(iDoc,"hiddenProId",proid);
			/////表单事件
			FormScript.runLoad(iDoc,dfid,proid);
			
			ServletActionContext.getResponse().setCharacterEncoding("utf-8");
			ServletActionContext.getResponse().setContentType("text/xml");
			OutputFormat format = OutputFormat.createPrettyPrint();
			format.setEncoding("utf-8");
			format.setTrimText(false);
			format.setOmitEncoding(false);

			XMLWriter writer = null;
			writer = new XMLWriter(ServletActionContext.getResponse()
					.getOutputStream(), format);
			// 写入xlst
			writer.processingInstruction("xml",
					"version=\"1.0\" encoding=\"utf-8\"");
			writer.processingInstruction("xml-stylesheet",
					" type=\"text/xsl\" href=\"" + xlstPath + "\"");
			writer.write(iDoc.getRootElement());
	
			ServletActionContext.getRequest().setAttribute("GroupDisabled", "false");
			
			
			ServletActionContext.getResponse().getOutputStream().flush();
			ServletActionContext.getResponse().getOutputStream().close();
            clock.stop();
			logger.debug("--显示页面耗时{0}毫秒！",clock.getTime());
		} catch (Exception e) {
			logger.error("\n写xml出错！\n{0}",e);
            e.printStackTrace();
		}
		return Action.NONE;
	}
	
	public boolean isTransHtml() {
		return transHtml;
	}

	public void setTransHtml(boolean transHtml) {
		this.transHtml = transHtml;
	}

	public FormInstanceFactory getInstanceFactory() {
		return instanceFactory;
	}

	public void setInstanceFactory(FormInstanceFactory instanceFactory) {
		this.instanceFactory = instanceFactory;
	}

	public String getParamString() {
		return paramString;
	}

	public void setParamString(String paramString) {
		this.paramString = paramString;
	}

}
